/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.ViewStack;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.LogWriter;

public final class Scaling {
    private Scaling() {
    }

    public static void execute(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI, ViewStack viewStack) {
        if (args == null) {
            if (!Values.isProcessing() && commonValues.getSelectedFile() != null) {
                Values.setProcessing(true);
                if (SwingUtilities.isEventDispatchThread()) {
                    Scaling.performScaling(decode_pdf, currentGUI, viewStack);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(() -> Scaling.performScaling(decode_pdf, currentGUI, viewStack));
                    }
                    catch (InterruptedException | InvocationTargetException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        } else {
            currentGUI.setScalingFromExternal(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performScaling(PdfDecoderInt decode_pdf, SwingGUI currentGUI, ViewStack viewStack) {
        try {
            Rectangle r2 = decode_pdf.getVisibleRect();
            Point px = currentGUI.convertComponentCoordsToPageCoords((int)r2.getX(), (int)r2.getY(), decode_pdf.getPageNumber());
            currentGUI.scaleAndRotate();
            float scaling = currentGUI.getScaling();
            int pageNumber = decode_pdf.getPageNumber();
            Rectangle area = new Rectangle((int)((double)((float)decode_pdf.getPages().getXCordForPage(pageNumber) + (float)px.x * scaling) - r2.getWidth() / 2.0), (int)((float)decode_pdf.getPages().getYCordForPage(pageNumber) + (float)(decode_pdf.getPdfPageData().getCropBoxHeight(pageNumber) - px.y) * scaling), (int)r2.getWidth(), (int)r2.getHeight());
            viewStack.add(-1, area, null);
            ((JComponent)((Object)decode_pdf)).scrollRectToVisible(area);
            ((JComponent)((Object)decode_pdf)).updateUI();
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
        }
        finally {
            Values.setProcessing(false);
        }
    }
}

