/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.io.File;
import javax.swing.JFileChooser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.utils.Messages;

public final class SaveForm {
    private SaveForm() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (args == null) {
            SaveForm.saveChangedForm(currentGUI, decode_pdf, commonValues);
        }
    }

    private static void saveChangedForm(SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        AcroRenderer formRenderer = decode_pdf.getFormRenderer();
        if (formRenderer == null) {
            return;
        }
        Object[] names = formRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, -1);
        if (names == null) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
        } else {
            String fileToSave = "";
            boolean finished = false;
            while (!finished) {
                JFileChooser chooser = new JFileChooser(commonValues.getInputDir());
                chooser.setSelectedFile(new File(commonValues.getInputDir() + '/' + commonValues.getSelectedFile()));
                chooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                chooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
                chooser.setFileSelectionMode(0);
                int approved = chooser.showSaveDialog(null);
                if (approved == 0) {
                    int n2;
                    File file = chooser.getSelectedFile();
                    fileToSave = file.getAbsolutePath();
                    if (!fileToSave.endsWith(".pdf")) {
                        fileToSave = fileToSave + ".pdf";
                        file = new File(fileToSave);
                    }
                    if (fileToSave.equals(commonValues.getSelectedFile())) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.SaveError"));
                        continue;
                    }
                    if (file.exists() && (n2 = currentGUI.showConfirmDialog(fileToSave + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    finished = true;
                    continue;
                }
                return;
            }
            if (currentGUI.getAnnotationPanel().annotationAdded()) {
                currentGUI.getAnnotationPanel().saveAnnotations(commonValues.getSelectedFile(), fileToSave);
            }
            commonValues.setFormsChanged(false);
            currentGUI.setViewerTitle();
        }
    }
}

