/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationPanel;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class SaveFile {
    private static final FileFilterer pdf = new FileFilterer(new String[]{"pdf"}, "PDF (*.pdf)");
    private static final FileFilterer fdf = new FileFilterer(new String[]{"fdf"}, "FDF (*.fdf)");
    private static final FileFilterer[] supportedImages;

    private SaveFile() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, Values commonValues) {
        if (args == null) {
            SaveFile.saveFile(currentGUI, commonValues);
        }
    }

    public static void handleUnsaveForms(SwingGUI currentGUI, Values commonValues) {
        if (commonValues.isFormsChanged() && !currentGUI.getPdfDecoder().isEncrypted()) {
            if ("true".equalsIgnoreCase(System.getProperty("org.jpedal.updateFileOnClose"))) {
                File saveFile = new File(commonValues.getSelectedFile());
                if (saveFile.canWrite()) {
                    SaveFile.saveAsPdf(saveFile, currentGUI, commonValues, true);
                } else {
                    LogWriter.writeLog("Unable to save the file as we can't write to the file.");
                }
            } else {
                int n2 = currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerFormsUnsavedOptions.message"), Messages.getMessage("PdfViewerFormsUnsavedWarning.message"), 0);
                if (n2 == 0) {
                    SaveFile.saveFile(currentGUI, commonValues);
                }
            }
        }
        commonValues.setFormsChanged(false);
        currentGUI.setViewerTitle();
    }

    private static void saveFile(SwingGUI currentGUI, Values commonValues) {
        if (currentGUI.getPdfDecoder().isLoadingLinearizedPDF()) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.LineariseSaveWait"));
        } else {
            if (currentGUI.getPdfDecoder().isEncrypted() && currentGUI.getAnnotationPanel().annotationAdded()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NewAnnotInEncryptedFile"));
                return;
            }
            JFileChooser chooser = new JFileChooser(commonValues.getInputDir());
            chooser.setSelectedFile(new File(commonValues.getInputDir() + '/' + commonValues.getSelectedFile()));
            chooser.addChoosableFileFilter(pdf);
            chooser.addChoosableFileFilter(fdf);
            for (FileFilterer filterer : supportedImages) {
                chooser.addChoosableFileFilter(filterer);
            }
            chooser.setFileFilter(pdf);
            chooser.setFileSelectionMode(0);
            int approved = chooser.showSaveDialog(null);
            if (approved == 0) {
                String filter = chooser.getFileFilter().getDescription().toLowerCase();
                String ext = filter.substring(0, filter.indexOf(32));
                if ("all".equalsIgnoreCase(ext) || "pdf".equalsIgnoreCase(ext) || "fdf".equalsIgnoreCase(ext)) {
                    SaveFile.saveAsPdf(chooser.getSelectedFile(), currentGUI, commonValues, false);
                } else if (SupportedFormats.hasEncoderSupportForImageFormat(ext)) {
                    SaveFile.saveAsImage(chooser.getSelectedFile(), currentGUI, ext);
                }
            }
        }
    }

    private static void saveAsImage(File file, SwingGUI currentGUI, String ext) {
        if (SupportedFormats.hasEncoderSupportForImageFormat(ext)) {
            PdfDecoder decoder = currentGUI.getPdfDecoder();
            File f2 = new File(file.getPath().replace('.' + ext, "").replace(".pdf", ""));
            f2.mkdir();
            for (int i2 = 1; i2 <= decoder.getPageCount(); ++i2) {
                try {
                    BufferedImage imageToSave = decoder.getPageAsImage(i2, 1.0f);
                    String filename = f2.getAbsolutePath() + System.getProperty("file.separator") + file.getName().replace(".pdf", "") + '_' + i2 + '.' + ext;
                    try {
                        JDeli.write(imageToSave, ext, new File(filename));
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("Exception in writing image " + e2);
                    }
                    continue;
                }
                catch (PdfException ex) {
                    LogWriter.writeLog("Exception attempting to Save as image: " + ex);
                }
            }
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.ImagesSaveUnsupported") + ' ' + ext);
            LogWriter.writeLog("Saving as " + ext + " is currently unsupported.");
        }
    }

    private static void saveAsPdf(File file, SwingGUI currentGUI, Values commonValues, boolean replaceFileWithoutWarning) {
        int n2;
        String fileToSave = file.getAbsolutePath();
        File tempFile = null;
        if (!fileToSave.endsWith(".pdf")) {
            fileToSave = fileToSave + ".pdf";
            file = new File(fileToSave);
        }
        if (file.exists() && !replaceFileWithoutWarning && (n2 = currentGUI.showConfirmDialog(fileToSave + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) {
            return;
        }
        try {
            tempFile = File.createTempFile(file.getName().substring(0, file.getName().lastIndexOf(46)) + "SaveTemp", file.getName().substring(file.getName().lastIndexOf(46)));
            ObjectStore.copy(commonValues.getSelectedFile(), tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            LogWriter.writeLog("Exception attempting to create temp file: " + ex);
        }
        if (tempFile != null) {
            Object[] objArr;
            if (currentGUI.getValues().isFormsChanged() && (objArr = currentGUI.getPdfDecoder().getFormRenderer().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_REF, -1)) != null && objArr.length > 0) {
                SwingAnnotationPanel.saveForms(commonValues.getSelectedFile(), tempFile.getAbsolutePath(), objArr);
            }
            boolean removeTempFile = true;
            try {
                if (currentGUI.getAnnotationPanel().annotationAdded()) {
                    currentGUI.getAnnotationPanel().saveAnnotationsWithFail(tempFile.getAbsolutePath(), fileToSave);
                } else {
                    ObjectStore.copyWithFail(tempFile.getAbsolutePath(), fileToSave);
                }
            }
            catch (IOException e2) {
                LogWriter.writeLog("Exception " + e2 + " copying file");
                currentGUI.showMessageDialog(String.format("Error saving file: %s%nFile saved at %s", e2.getMessage(), tempFile.getAbsolutePath()));
                removeTempFile = false;
            }
            if (removeTempFile) {
                tempFile.delete();
            }
            commonValues.setFormsChanged(false);
            currentGUI.setViewerTitle();
        }
    }

    static {
        String[][] formats = SupportedFormats.getSupportedImageEncoders();
        supportedImages = new FileFilterer[formats.length];
        for (int i2 = 0; i2 != formats.length; ++i2) {
            StringBuilder descriptionBuilder = new StringBuilder();
            descriptionBuilder.append(formats[i2][0].toUpperCase());
            descriptionBuilder.append(" (*.").append(formats[i2][0]);
            for (int f2 = 1; f2 != formats[i2].length; ++f2) {
                descriptionBuilder.append(";*.").append(formats[i2][f2]);
            }
            descriptionBuilder.append(')');
            SaveFile.supportedImages[i2] = new FileFilterer(formats[i2], descriptionBuilder.toString());
        }
    }
}

