/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.Messages;

public final class Print {
    private Print() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, Values commonValues, PropertiesFile properties, Printer currentPrinter, PdfDecoderInt decode_pdf) {
        if (args == null) {
            if (commonValues.getSelectedFile() != null && decode_pdf.isOpen()) {
                if (!PrintStatus.isPrinting()) {
                    if (!commonValues.isPDF()) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImagePrinting"));
                    } else {
                        String defaultPrinter = properties.getValue("defaultPrinter");
                        currentPrinter.printPDF(decode_pdf, currentGUI, properties.getValue("printerBlacklist"), defaultPrinter);
                    }
                } else {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintFinish.message"));
                }
            } else {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerNoFile.message"));
            }
        }
    }
}

