/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import com.idrsolutions.image.tiff.TiffDecoder;
import java.io.File;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Images;
import org.jpedal.examples.viewer.commands.Scroll;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.Messages;

public final class PageNavigator {
    private static boolean pageTurnAnimating;
    private static int lastPageDecoded;
    private static TiffDecoder tiffDecoder;
    private static boolean pageChanging;

    private PageNavigator() {
    }

    public static void gotoPage(String page, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        int newPage;
        page = page.split("/")[0];
        try {
            newPage = Integer.parseInt(page);
            if (!decode_pdf.isPageAvailable(newPage)) {
                currentGUI.showMessageDialog("Page " + newPage + " is not yet loaded");
                currentGUI.setPageCounterText(SwingGUI.PageCounter.PAGECOUNTER2, currentGUI.getPageLabel(commonValues.getCurrentPage()));
                return;
            }
            switch (decode_pdf.getDisplayView()) {
                case 3: {
                    if ((newPage & 1) != 1 || newPage == 1) break;
                    --newPage;
                    break;
                }
                case 4: {
                    if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                        if ((newPage & 1) != 1 || newPage == 1) break;
                        --newPage;
                        break;
                    }
                    if ((newPage & 1) != 0) break;
                    --newPage;
                    break;
                }
            }
            if (newPage > decode_pdf.getPageCount() | newPage < 1) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + page + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + decode_pdf.getPageCount());
                newPage = commonValues.getCurrentPage();
                currentGUI.setPageNumber();
            }
        }
        catch (NumberFormatException e2) {
            currentGUI.showMessageDialog('>' + page + "< " + Messages.getMessage("PdfViewerInvalidNumber.text") + ' ' + e2);
            newPage = commonValues.getCurrentPage();
            currentGUI.setPageCounterText(SwingGUI.PageCounter.PAGECOUNTER2, currentGUI.getPageLabel(commonValues.getCurrentPage()));
        }
        PageNavigator.navigatePages(newPage - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
        if (decode_pdf.getDisplayView() == 5) {
            PageNavigator.navigatePages(0, commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goPage(Object[] args, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            String page = currentGUI.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
            if (page != null) {
                PageNavigator.gotoPage(page, currentGUI, commonValues, decode_pdf);
            }
        } else {
            PageNavigator.gotoPage((String)args[0], currentGUI, commonValues, decode_pdf);
        }
    }

    public static void goLastPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null && commonValues.getPageCount() > 1 && commonValues.getPageCount() - commonValues.getCurrentPage() > 0) {
            PageNavigator.navigatePages(commonValues.getPageCount() - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goFirstPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null && commonValues.getPageCount() > 1 && commonValues.getCurrentPage() != 1) {
            PageNavigator.navigatePages(-(commonValues.getCurrentPage() - 1), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goFForwardPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null) {
            if (commonValues.getPageCount() < commonValues.getCurrentPage() + 10) {
                PageNavigator.navigatePages(commonValues.getPageCount() - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
            } else {
                PageNavigator.navigatePages(10, commonValues, decode_pdf, currentGUI);
            }
        }
    }

    public static void goForwardPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        if (args == null) {
            if (commonValues.getSelectedFile() != null) {
                PageNavigator.navigatePages(1, commonValues, decode_pdf, currentGUI);
            }
        } else if (commonValues.getSelectedFile() != null) {
            PageNavigator.navigatePages(Integer.parseInt((String)args[0]), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goBackPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        if (args == null) {
            if (commonValues.getSelectedFile() != null) {
                PageNavigator.navigatePages(-1, commonValues, decode_pdf, currentGUI);
            }
        } else if (commonValues.getSelectedFile() != null) {
            PageNavigator.navigatePages(-Integer.parseInt((String)args[0]), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goFBackPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null) {
            if (commonValues.getCurrentPage() <= 10) {
                PageNavigator.navigatePages(-(commonValues.getCurrentPage() - 1), commonValues, decode_pdf, currentGUI);
            } else {
                PageNavigator.navigatePages(-10, commonValues, decode_pdf, currentGUI);
            }
        }
    }

    private static int getUpdatedPageNumber(int displayMode, int currentPage, int totalPageCount, int changeCount) {
        if (displayMode == 4 || displayMode == 3) {
            if (changeCount == -1 && currentPage != 2) {
                changeCount = -2;
            }
            if (changeCount == 1 && currentPage != totalPageCount - 1) {
                changeCount = 2;
            }
        }
        return currentPage + changeCount;
    }

    private static void changePage(PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues, int updatedTotal) {
        commonValues.setCurrentPage(updatedTotal);
        if (decode_pdf.getDisplayView() == 2 || decode_pdf.getDisplayView() == 3) {
            currentGUI.decodePage();
            currentGUI.setPageNumber();
            pageChanging = false;
            return;
        }
        currentGUI.resetStatusMessage("Loading Page " + commonValues.getCurrentPage());
        decode_pdf.setPageParameters(currentGUI.getScaling(), commonValues.getCurrentPage());
        if (commonValues.isPDF()) {
            currentGUI.decodePage();
        }
        if (decode_pdf.getDisplayView() == 1) {
            Scroll.rectToHighlight(new int[]{0, decode_pdf.getPDFHeight(), 1, 1}, updatedTotal, decode_pdf);
        }
    }

    private static void navigatePagePrevious(int count, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        int updatedTotal = PageNavigator.getUpdatedPageNumber(decode_pdf.getDisplayView(), commonValues.getCurrentPage(), decode_pdf.getPageCount(), count);
        if (!decode_pdf.isPageAvailable(updatedTotal)) {
            currentGUI.showMessageDialog("Page " + updatedTotal + " is not yet loaded");
            pageChanging = false;
            return;
        }
        if (!Values.isProcessing()) {
            if (updatedTotal <= commonValues.getPageCount()) {
                if (commonValues.isMultiTiff()) {
                    PageNavigator.changeTiffPage(commonValues, decode_pdf, currentGUI, count, updatedTotal);
                } else {
                    if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                        if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) {
                            if (updatedTotal > commonValues.getPageCount()) {
                                updatedTotal = commonValues.getPageCount();
                            }
                            if ((updatedTotal & 1) == 1 && updatedTotal != 1) {
                                --updatedTotal;
                            }
                            if (decode_pdf.getDisplayView() == 4) {
                                count = updatedTotal / 2 - commonValues.getCurrentPage() / 2;
                            }
                        } else {
                            if ((updatedTotal & 1) == 0) {
                                --updatedTotal;
                            }
                            count = (updatedTotal + 1) / 2 - (commonValues.getCurrentPage() + 1) / 2;
                        }
                    }
                    if (count == 1 && decode_pdf.getDisplayView() == 4 && decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && decode_pdf.getPageCount() != 2 && currentGUI.getPageTurnScalingAppropriate() && updatedTotal / 2 != commonValues.getCurrentPage() / 2 && !decode_pdf.getPdfPageData().hasMultipleSizes() && !pageTurnAnimating) {
                        currentGUI.triggerPageTurnAnimation(decode_pdf, commonValues, updatedTotal, false);
                    } else {
                        PageNavigator.changePage(decode_pdf, currentGUI, commonValues, updatedTotal);
                    }
                }
            }
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    private static void navigatePageNext(int count, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        int updatedTotal = PageNavigator.getUpdatedPageNumber(decode_pdf.getDisplayView(), commonValues.getCurrentPage(), decode_pdf.getPageCount(), count);
        if (!decode_pdf.isPageAvailable(updatedTotal)) {
            currentGUI.showMessageDialog("Page " + updatedTotal + " is not yet loaded");
            pageChanging = false;
            return;
        }
        if (!Values.isProcessing()) {
            if (updatedTotal >= 1) {
                if (commonValues.isMultiTiff()) {
                    PageNavigator.changeTiffPage(commonValues, decode_pdf, currentGUI, count, updatedTotal);
                } else {
                    if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                        if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) {
                            if (count == -1) {
                                --updatedTotal;
                            }
                            if (updatedTotal < 1) {
                                updatedTotal = 1;
                            }
                            if ((updatedTotal & 1) == 1 && updatedTotal != 1) {
                                --updatedTotal;
                            }
                            if (decode_pdf.getDisplayView() == 4) {
                                count = updatedTotal / 2 - commonValues.getCurrentPage() / 2;
                            }
                        } else {
                            if ((updatedTotal & 1) == 0) {
                                --updatedTotal;
                            }
                            if (decode_pdf.getDisplayView() == 4) {
                                count = (updatedTotal + 1) / 2 - (commonValues.getCurrentPage() + 1) / 2;
                            }
                        }
                    }
                    if (count == -1 && decode_pdf.getDisplayView() == 4 && decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && currentGUI.getPageTurnScalingAppropriate() && decode_pdf.getPageCount() != 2 && (updatedTotal != commonValues.getCurrentPage() - 1 || updatedTotal == 1) && !decode_pdf.getPdfPageData().hasMultipleSizes() && !pageTurnAnimating) {
                        currentGUI.triggerPageTurnAnimation(decode_pdf, commonValues, updatedTotal, true);
                    } else {
                        PageNavigator.changePage(decode_pdf, currentGUI, commonValues, updatedTotal);
                    }
                }
            }
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    private static void navigatePages(int count, Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI) {
        if (count == 0 || commonValues.getFileType() == Values.FileType.PDF && !decode_pdf.isOpen()) {
            return;
        }
        if (!pageChanging) {
            pageChanging = true;
            if (count > 0) {
                PageNavigator.navigatePageNext(count, commonValues, decode_pdf, currentGUI);
            } else {
                PageNavigator.navigatePagePrevious(count, commonValues, decode_pdf, currentGUI);
            }
            if (currentGUI.getThumbnailScrollBar() != null) {
                currentGUI.setThumbnailScrollBarValue(commonValues.getCurrentPage() - 1);
            }
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
            currentGUI.setPageNumber();
            pageChanging = false;
        }
    }

    private static void changeTiffPage(Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI, int count, int updatedTotal) {
        commonValues.setTiffImageToLoad(lastPageDecoded - 1 + count);
        PageNavigator.drawMultiPageTiff(commonValues, decode_pdf);
        commonValues.setCurrentPage(updatedTotal);
        lastPageDecoded = commonValues.getTiffImageToLoad() + 1;
        currentGUI.setPageNumber();
        currentGUI.scaleAndRotate();
    }

    public static void drawMultiPageTiff(Values commonValues, PdfDecoderInt decode_pdf) {
        if (tiffDecoder != null) {
            try {
                commonValues.setBufferedImg(tiffDecoder.readImageAt(commonValues.getTiffImageToLoad(), new File(commonValues.getSelectedFile())));
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            if (commonValues.getBufferedImg() != null) {
                decode_pdf.getDynamicRenderer().writeCustom(43, null);
                decode_pdf.getPages().refreshDisplay();
                Images.addImage(decode_pdf, commonValues);
            }
        }
    }

    public static void setPageTurnAnimating(boolean a10, SwingGUI currentGUI) {
        pageTurnAnimating = a10;
        if (a10) {
            currentGUI.getButtons().getButton(53).setEnabled(false);
            currentGUI.getButtons().getButton(52).setEnabled(false);
            currentGUI.getButtons().getButton(54).setEnabled(false);
            currentGUI.getButtons().getButton(51).setEnabled(false);
            currentGUI.getButtons().getButton(55).setEnabled(false);
            currentGUI.getButtons().getButton(50).setEnabled(false);
        } else {
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
        }
    }

    public static boolean getPageTurnAnimating() {
        return pageTurnAnimating;
    }

    public static void setLastPageDecoded(int x2) {
        lastPageDecoded = x2;
    }

    public static TiffDecoder getTiffDecoder() {
        return tiffDecoder;
    }

    public static void setTiffDecoder(TiffDecoder tiffDecode) {
        tiffDecoder = tiffDecode;
    }

    static {
        lastPageDecoded = -1;
    }
}

