/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.ModeChange;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.JavaFXHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class PageFlow {
    private PageFlow() {
    }

    public static void execute(Object[] args, final SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingSearchWindow searchFrame) {
        if (!decode_pdf.isOpen() || decode_pdf.getDisplayView() == 5) {
            return;
        }
        searchFrame.removeSearchWindow(false);
        if (args == null) {
            if (!JavaFXHelper.isJavaFXAvailable()) {
                String flag = System.getProperty("org.jpedal.suppressViewerPopups");
                boolean suppressViewerPopups = false;
                if ("true".equalsIgnoreCase(flag)) {
                    suppressViewerPopups = true;
                }
                String propValue = properties.getValue("showpageflowmessage");
                if (!suppressViewerPopups && !propValue.isEmpty() && "true".equals(propValue)) {
                    final JPanel a10 = new JPanel();
                    a10.setLayout(new BoxLayout(a10, 1));
                    JLabel m1 = new JLabel(Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Message"));
                    m1.setHorizontalTextPosition(0);
                    a10.add(m1);
                    MouseAdapter linkListener = new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent e2) {
                            if (GUIDisplay.allowChangeCursor) {
                                a10.setCursor(new Cursor(12));
                            }
                        }

                        @Override
                        public void mouseExited(MouseEvent e2) {
                            if (GUIDisplay.allowChangeCursor) {
                                a10.setCursor(new Cursor(0));
                            }
                        }

                        @Override
                        public void mouseClicked(MouseEvent e2) {
                            try {
                                Desktop.getDesktop().browse(new URI(Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Link")));
                            }
                            catch (Exception e1) {
                                LogWriter.writeLog("Exception " + e1.getMessage());
                                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                            }
                        }
                    };
                    JLabel link = new JLabel("<html><u>" + Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Download") + "</u></html>");
                    link.setForeground(Color.BLUE);
                    link.addMouseListener(linkListener);
                    link.setHorizontalAlignment(0);
                    a10.add(link);
                    Object[] options = new Object[]{Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Continue")};
                    JOptionPane.showOptionDialog(currentGUI.getFrame(), a10, Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Title"), -1, -1, null, options, options[0]);
                    return;
                }
            }
            currentGUI.getCombo(252).setEnabled(false);
            currentGUI.getButtons().getButton(29).setEnabled(false);
            currentGUI.getButtons().getButton(13).setEnabled(false);
            currentGUI.getButtons().getButton(35).setEnabled(false);
            currentGUI.getButtons().getButton(36).setEnabled(false);
            if (currentGUI.getGlassPane() != null) {
                ((Component)currentGUI.getGlassPane()).setVisible(false);
            }
            currentGUI.getButtons().alignLayoutMenuOption(5);
            ModeChange.changeModeInSwing(5, decode_pdf, currentGUI, commonValues);
            currentGUI.getCombo(251).setEnabled(false);
            currentGUI.updateTextBoxSize();
        }
    }
}

