/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class OpenInSystemDefault {
    private OpenInSystemDefault() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, Values commonValues) {
        String file = commonValues.getSelectedFile();
        if (args != null && args.length > 0) {
            file = (String)args[0];
        }
        if (file != null) {
            try {
                if (DecoderOptions.isRunningOnWindows) {
                    Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", file});
                } else if (DecoderOptions.isRunningOnMac || DecoderOptions.isRunningOnLinux) {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", file});
                } else if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(new File(file));
                    }
                    catch (IOException ex) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfSystemDefault.error"));
                        LogWriter.writeLog(Messages.getMessage("PdfSystemDefault.exception") + ex.getMessage());
                    }
                } else {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfSystemDefault.unsupported"));
                }
            }
            catch (IOException ex) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfSystemDefault.error"));
                LogWriter.writeLog(Messages.getMessage("PdfSystemDefault.exception") + ex.getMessage());
            }
        }
    }
}

