/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.commands.Images;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.commands.SaveFile;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.DownloadProgress;
import org.jpedal.examples.viewer.gui.popups.ErrorDialog;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.raw.LinearizedObject;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class OpenFile {
    public static boolean isPDf;
    private static InputStream inputStream;

    private OpenFile() {
    }

    public static void executeOpenURL(Object[] args, Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingThumbnailPanel thumbnails) {
        inputStream = null;
        if (args == null) {
            SaveFile.handleUnsaveForms(currentGUI, commonValues);
            String newFile = OpenFile.selectURL(commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            if (newFile != null) {
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
            }
        } else {
            currentGUI.resetNavBar();
            String newFile = (String)args[0];
            if (newFile != null) {
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
                boolean failed = false;
                try {
                    URL testExists = new URL(newFile);
                    URLConnection conn = testExists.openConnection();
                    if (conn.getContent() == null) {
                        failed = true;
                    }
                }
                catch (IOException e2) {
                    failed = true;
                    LogWriter.writeLog("Unable to open as URL " + newFile + ' ' + e2);
                }
                if (failed) {
                    newFile = null;
                }
                if (newFile != null) {
                    commonValues.setFileSize(0L);
                    currentGUI.setViewerTitle();
                    if (!Values.isProcessing()) {
                        thumbnails.terminateDrawing();
                        decode_pdf.flushObjectValues(true);
                        currentGUI.stopThumbnails();
                        try {
                            OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException e3) {
                            LogWriter.writeLog("Exception attempting to open file: " + e3);
                        }
                    }
                } else {
                    decode_pdf.repaint();
                }
            }
        }
    }

    public static void executeOpenFile(Object[] args, Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingThumbnailPanel thumbnails) {
        inputStream = null;
        SaveFile.handleUnsaveForms(currentGUI, commonValues);
        if (args == null) {
            if (PrintStatus.isPrinting()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
            } else if (Values.isProcessing()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            } else {
                OpenFile.selectFile(commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                commonValues.setFileIsURL(false);
            }
        } else if (args.length == 2 && args[0] instanceof byte[] && args[1] instanceof String) {
            byte[] data = (byte[])args[0];
            String filename = (String)args[1];
            commonValues.setFileSize(data.length);
            commonValues.setSelectedFile(filename);
            currentGUI.setViewerTitle();
            if (commonValues.getSelectedFile() != null && !Values.isProcessing()) {
                try {
                    isPDf = true;
                    commonValues.setMultiTiff(false);
                    thumbnails.resetToDefault();
                    currentGUI.reinitThumbnails();
                    currentGUI.setNoPagesDecoded();
                    if (searchFrame != null) {
                        searchFrame.removeSearchWindow(false);
                        searchFrame.resetSearchWindow();
                    }
                    commonValues.maxViewY = 0;
                    OpenFile.setFileType(commonValues.getSelectedFile(), commonValues);
                    commonValues.setCurrentPage(1);
                    decode_pdf.closePdfFile();
                    decode_pdf.openPdfArray(data);
                    currentGUI.updateStatusMessage("opening file");
                    boolean fileCanBeOpened = true;
                    if (decode_pdf.isEncrypted() && !decode_pdf.isFileViewable()) {
                        fileCanBeOpened = false;
                        String password = System.getProperty("org.jpedal.password");
                        if (password == null) {
                            password = currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                        }
                        if (password != null) {
                            decode_pdf.setEncryptionPassword(password);
                            if (decode_pdf.isFileViewable()) {
                                fileCanBeOpened = true;
                            }
                        }
                        if (!fileCanBeOpened) {
                            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                        }
                    }
                    if (fileCanBeOpened) {
                        if ("true".equals(properties.getValue("Recentdocuments"))) {
                            properties.addRecentDocument(commonValues.getSelectedFile());
                            currentGUI.getRecentDocument().updateRecentDocuments(properties.getRecentDocuments());
                        }
                        currentGUI.getRecentDocument().addToFileList(commonValues.getSelectedFile());
                        commonValues.setCurrentPage(1);
                    }
                    OpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
                }
                catch (PdfException e2) {
                    LogWriter.writeLog("Exception attempting to open file: " + e2);
                }
            }
        } else if (args.length >= 1) {
            if (args[0] instanceof InputStream) {
                inputStream = (InputStream)args[0];
                String newFile = "InputStream-" + System.currentTimeMillis() + ".pdf";
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
                if (inputStream != null) {
                    try {
                        commonValues.setFileSize(0L);
                        currentGUI.setViewerTitle();
                    }
                    catch (Exception e3) {
                        LogWriter.writeLog(e3);
                    }
                    if (!Values.isProcessing()) {
                        thumbnails.terminateDrawing();
                        decode_pdf.flushObjectValues(true);
                        currentGUI.stopThumbnails();
                        try {
                            OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                            commonValues.setSelectedFile(decode_pdf.getFileName());
                        }
                        catch (InterruptedException e4) {
                            LogWriter.writeLog("Exception attempting to open file: " + e4);
                        }
                    }
                } else {
                    decode_pdf.repaint();
                }
            } else {
                File file;
                if (args[0] instanceof File) {
                    file = (File)args[0];
                } else if (args[0] instanceof String) {
                    String filename = (String)args[0];
                    char[] str = filename.toCharArray();
                    if (str[1] == ':' || str[0] == '\\' || str[0] == '/') {
                        file = new File(filename);
                    } else {
                        String parent = new File(commonValues.getSelectedFile()).getParent();
                        file = new File(parent, filename);
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException e5) {
                            file = new File(parent, filename);
                            LogWriter.writeLog("Exception in IO " + e5);
                        }
                    }
                } else {
                    file = null;
                }
                if (file != null) {
                    try {
                        commonValues.setInputDir(file.getParentFile().getCanonicalPath());
                        OpenFile.open(file.getAbsolutePath(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                        String bookmarkPage = null;
                        if (args.length > 1 && args[1] instanceof String) {
                            String bookmark = (String)args[1];
                            bookmarkPage = decode_pdf.getIO().convertNameToRef(bookmark);
                        }
                        if (bookmarkPage != null) {
                            OutlineObject namedDest = new OutlineObject(bookmarkPage);
                            decode_pdf.getIO().readObject(namedDest);
                            decode_pdf.getFormRenderer().getActionHandler().gotoDest(namedDest, 3, 339034948);
                        }
                        while (Values.isProcessing()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e6) {
                                LogWriter.writeLog("Exception attempting to open file: " + e6);
                            }
                        }
                    }
                    catch (IOException e1) {
                        LogWriter.writeLog("Exception attempting to open file: " + e1);
                    }
                } else {
                    decode_pdf.repaint();
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                }
            }
        }
    }

    public static void open(String file, Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingThumbnailPanel thumbnails) {
        currentGUI.removePageListener();
        String ending = file.toLowerCase().trim();
        if (ending.endsWith(".pdf") || ending.endsWith(".fdf")) {
            currentGUI.setDisplayView(1, decode_pdf.getPageAlignment());
        }
        currentGUI.getAnnotationPanel().clearAnnotations();
        boolean isURL = file.startsWith("http:") || file.startsWith("file:");
        try {
            if (!isURL) {
                commonValues.setFileIsURL(false);
                commonValues.setFileSize(new File(file).length() >> 10);
            } else {
                commonValues.setFileIsURL(true);
            }
            commonValues.setSelectedFile(file);
            currentGUI.setViewerTitle();
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " getting paths");
        }
        File testFile = new File(commonValues.getSelectedFile());
        if (!isURL && !testFile.exists()) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (commonValues.getSelectedFile() != null && !Values.isProcessing()) {
            decode_pdf.flushObjectValues(true);
            OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
        }
        if (isPDf) {
            currentGUI.setDisplayView(decode_pdf.getDecoderOptions().getPageMode(), decode_pdf.getPageAlignment());
        }
    }

    public static void openFile(String selectedFile, Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingThumbnailPanel thumbnails) {
        PdfObject collectionObj;
        isPDf = false;
        commonValues.setMultiTiff(false);
        thumbnails.resetToDefault();
        currentGUI.setNoPagesDecoded();
        if (searchFrame != null) {
            searchFrame.removeSearchWindow(false);
        }
        commonValues.maxViewY = 0;
        OpenFile.setFileType(selectedFile, commonValues);
        if (!commonValues.isPDF()) {
            if (SwingUtilities.isEventDispatchThread()) {
                currentGUI.setDisplayView(1, 2);
            } else {
                Runnable doPaintComponent = () -> currentGUI.setDisplayView(1, 2);
                try {
                    SwingUtilities.invokeAndWait(doPaintComponent);
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
        }
        commonValues.setCurrentPage(1);
        currentGUI.setupGUIElementsForFiletype(commonValues.getFileType());
        try {
            boolean fileCanBeOpened = OpenFile.openUpFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            if (fileCanBeOpened) {
                OpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
            } else {
                currentGUI.setViewerTitle();
                decode_pdf.getDynamicRenderer().writeCustom(43, null);
                decode_pdf.getPages().refreshDisplay();
                currentGUI.scaleAndRotate();
                commonValues.setPageCount(1);
                commonValues.setCurrentPage(1);
            }
        }
        catch (PdfException e3) {
            LogWriter.writeLog(Messages.getMessage("PdfViewerError.Exception") + ' ' + e3 + ' ' + Messages.getMessage("PdfViewerError.DecodeFile"));
        }
        if (isPDf && (collectionObj = decode_pdf.getIO().getPDFObject(-2139781200)) != null) {
            isPDf = false;
            commonValues.setFileType(Values.FileType.PORTFOLIO);
            currentGUI.setupGUIElementsForFiletype(commonValues.getFileType());
            decode_pdf.getIO().checkResolved(collectionObj);
            String view = collectionObj.getName(641283399);
            if (view == null || "C".equals(view) || "D".equals(view)) {
                currentGUI.setDisplayView(6, 2);
            } else if ("T".equals(view)) {
                currentGUI.setDisplayView(7, 2);
            }
        }
    }

    private static void setFileType(String selectedFile, Values commonValues) {
        String ending = selectedFile.toLowerCase().trim();
        if (ending.endsWith(".pdf") || ending.endsWith(".fdf")) {
            commonValues.setFileType(Values.FileType.PDF);
            isPDf = true;
        } else {
            commonValues.setFileType(Values.FileType.IMAGES);
            isPDf = false;
        }
    }

    public static boolean openUpFile(String selectedFile, Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingThumbnailPanel thumbnails) throws PdfException {
        commonValues.maxViewY = 0;
        OpenFile.setFileType(selectedFile, commonValues);
        if (searchFrame != null) {
            searchFrame.resetSearchWindow();
        }
        commonValues.setMultiTiff(false);
        boolean fileCanBeOpened = true;
        DecryptionFactory decyptionFactory = null;
        decode_pdf.closePdfFile();
        try {
            if (commonValues.isPDF()) {
                if (inputStream != null || selectedFile.startsWith("http") || selectedFile.startsWith("file:") || selectedFile.startsWith("jar:")) {
                    try {
                        boolean isLinearized = false;
                        isLinearized = inputStream != null ? true : Commands.isPDFLinearized(commonValues.getSelectedFile());
                        if (!isLinearized) {
                            if (commonValues.getSelectedFile().startsWith("jar:")) {
                                InputStream is = Commands.class.getResourceAsStream(commonValues.getSelectedFile().substring(4));
                                decode_pdf.openPdfFileFromInputStream(is, false);
                            } else {
                                String encPassword;
                                DownloadProgress dlp = new DownloadProgress(commonValues.getSelectedFile());
                                Thread t2 = new Thread(() -> {
                                    while (dlp.isDownloading()) {
                                        currentGUI.setDownloadProgress("download", dlp.getProgress());
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (InterruptedException e2) {
                                            LogWriter.writeLog("Exception attempting to open file: " + e2);
                                        }
                                    }
                                });
                                t2.setDaemon(true);
                                t2.start();
                                if (decyptionFactory == null) {
                                    encPassword = DecryptionFactory.getDynamicPassword();
                                    decode_pdf.getObjectStore().setIdrPassword(encPassword.getBytes());
                                } else {
                                    encPassword = Arrays.toString(decyptionFactory.getEncHash());
                                    decode_pdf.getObjectStore().setIdrPassword(decyptionFactory.getEncHash());
                                }
                                dlp.startDownload(encPassword);
                                File tempFile = dlp.getFile();
                                decode_pdf.openPdfFile(tempFile.getCanonicalPath(), encPassword);
                            }
                        } else {
                            currentGUI.setViewerTitle();
                            if (inputStream != null) {
                                decode_pdf.openPdfFileFromInputStream(inputStream, true);
                            } else {
                                decode_pdf.openPdfFileFromURL(commonValues.getSelectedFile(), true);
                            }
                            PdfObject linearObj = (PdfObject)decode_pdf.getJPedalObject(2004845231);
                            if (linearObj != null) {
                                int linearfileLength = linearObj.getInt(28);
                                StringBuilder message = new StringBuilder("Downloading ");
                                if ((linearfileLength /= 1024) < 1024) {
                                    message.append(linearfileLength).append(" kB");
                                } else {
                                    message.append(linearfileLength /= 1024).append(" M");
                                }
                                String fMessage = message.toString();
                                Thread fullReaderer = new Thread(() -> {
                                    LinearThread linearizedBackgroundReaderer = (LinearThread)decode_pdf.getJPedalObject(-1276915978);
                                    while (linearizedBackgroundReaderer != null && linearizedBackgroundReaderer.isAlive()) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException e2) {
                                            LogWriter.writeLog(e2);
                                        }
                                        currentGUI.setDownloadProgress(fMessage, linearizedBackgroundReaderer.getPercentageLoaded());
                                    }
                                    currentGUI.setDownloadProgress(fMessage, 100);
                                    if (SwingUtilities.isEventDispatchThread()) {
                                        OpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
                                    } else {
                                        Runnable doPaintComponent = () -> OpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
                                        try {
                                            SwingUtilities.invokeAndWait(doPaintComponent);
                                        }
                                        catch (InterruptedException | InvocationTargetException e3) {
                                            LogWriter.writeLog("Exception: " + e3.getMessage());
                                        }
                                    }
                                });
                                fullReaderer.setDaemon(true);
                                fullReaderer.start();
                            }
                        }
                    }
                    catch (IOException | PdfException e2) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + " file=" + selectedFile + '\n' + e2.getMessage());
                        decode_pdf.closePdfFile();
                        fileCanBeOpened = false;
                    }
                } else {
                    try {
                        decode_pdf.openPdfFile(commonValues.getSelectedFile());
                    }
                    catch (RuntimeException e3) {
                        currentGUI.showMessageDialog("Exception in code " + e3.getMessage() + " please send to IDRsolutions");
                        LogWriter.writeLog("Exception " + e3.getMessage());
                    }
                    if (decode_pdf.getPageCount() > 1) {
                        currentGUI.getButtons().setPageLayoutButtonsEnabled(true);
                    }
                }
                currentGUI.reinitThumbnails();
            } else {
                boolean isURL;
                decode_pdf.resetForNonPDFPage(1);
                PageNavigator.setLastPageDecoded(1);
                boolean isTiff = selectedFile.toLowerCase().contains(".tif");
                boolean bl2 = isURL = selectedFile.startsWith("http:") || selectedFile.startsWith("file:");
                if (isTiff) {
                    try {
                        TiffDecoder tiff = new TiffDecoder();
                        PageNavigator.setTiffDecoder(tiff);
                        int pageCount = tiff.getImageCount(new File(commonValues.getSelectedFile()));
                        commonValues.setTiffImageToLoad(1);
                        if (pageCount > 1) {
                            decode_pdf.resetForNonPDFPage(pageCount);
                            commonValues.setPageCount(pageCount);
                            PageNavigator.setLastPageDecoded(1);
                            commonValues.setMultiTiff(true);
                            currentGUI.setupGUIElementsForFiletype(commonValues.getFileType());
                        }
                        PageNavigator.drawMultiPageTiff(commonValues, decode_pdf);
                    }
                    catch (Exception e4) {
                        LogWriter.writeLog("Exception " + e4 + Messages.getMessage("PdfViewerError.Loading") + commonValues.getSelectedFile());
                    }
                } else {
                    try {
                        if (isURL) {
                            URL url = new URL(selectedFile);
                            commonValues.setBufferedImg(JDeli.read(url.openStream()));
                        } else {
                            commonValues.setBufferedImg(JDeli.read(new File(selectedFile)));
                        }
                    }
                    catch (Exception e5) {
                        LogWriter.writeLog("Exception " + e5 + "loading " + commonValues.getSelectedFile());
                    }
                }
            }
            currentGUI.updateStatusMessage("opening file");
            if (fileCanBeOpened && decode_pdf.isEncrypted() && !decode_pdf.isFileViewable()) {
                fileCanBeOpened = false;
                String password = System.getProperty("org.jpedal.password");
                boolean cancel = false;
                while (!fileCanBeOpened && !cancel) {
                    if (password == null) {
                        password = currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                        boolean bl3 = cancel = password == null;
                    }
                    if (password != null) {
                        decode_pdf.setEncryptionPassword(password);
                        if (decode_pdf.isFileViewable()) {
                            fileCanBeOpened = true;
                        }
                    }
                    if (fileCanBeOpened) continue;
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                    password = null;
                }
            }
            currentGUI.setBookmarks(true);
            if (fileCanBeOpened) {
                if ("true".equals(properties.getValue("Recentdocuments"))) {
                    properties.addRecentDocument(commonValues.getSelectedFile());
                    currentGUI.getRecentDocument().updateRecentDocuments(properties.getRecentDocuments());
                }
                currentGUI.getRecentDocument().addToFileList(commonValues.getSelectedFile());
                commonValues.setCurrentPage(1);
            }
        }
        catch (PdfException e6) {
            LogWriter.writeLog("Exception " + e6 + " opening file");
            if (SwingGUI.showMessages) {
                ErrorDialog.showError(e6, Messages.getMessage("PdfViewerOpenerror"), currentGUI.getFrame(), commonValues.getSelectedFile());
            }
            Exit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
            throw e6;
        }
        if (!decode_pdf.isOpen() && commonValues.isPDF() && decode_pdf.getJPedalObject(2004845231) == null) {
            return false;
        }
        return fileCanBeOpened;
    }

    public static void selectFile(Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingThumbnailPanel thumbnails) {
        File file;
        if (searchFrame != null) {
            searchFrame.removeSearchWindow(false);
        }
        if ((file = OpenFile.showFileDialog(currentGUI.getFrame(), commonValues.getInputDir(), commonValues.getSelectedFile(), true)) != null) {
            if (OpenFile.isSupportedFileExtension(file.getName())) {
                commonValues.setInputDir(file.getParent());
                OpenFile.open(file.getAbsolutePath(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            } else {
                decode_pdf.repaint();
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            }
        } else {
            decode_pdf.repaint();
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
    }

    public static void processPage(Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI, SwingThumbnailPanel thumbnails) {
        Object linearObject = decode_pdf.getJPedalObject(2004845231);
        if (commonValues.isPDF() && (decode_pdf.isOpen() || !commonValues.isPDF() || linearObject != null)) {
            PdfFileInformation currentFileInformation = decode_pdf.getFileInformationData();
            decode_pdf.setRenderMode(3);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = PdfFileInformation.getFieldNames();
            String[] ocr = new String[]{"TeleForm", "dgn2pdf", "ABBYY FineReader 8.0 Professional Edition"};
            for (int i2 = 0; i2 < fields.length; ++i2) {
                if (!"Creator".equals(fields[i2]) && !"Producer".equals(fields[i2])) continue;
                for (String anOcr : ocr) {
                    if (!values[i2].equals(anOcr)) continue;
                    decode_pdf.setRenderMode(2);
                }
            }
        }
        if (commonValues.isPDF()) {
            commonValues.setPageCount(decode_pdf.getPageCount());
        } else if (!commonValues.isMultiTiff()) {
            commonValues.setPageCount(1);
        }
        if (commonValues.getPageCount() < commonValues.getCurrentPage()) {
            commonValues.setCurrentPage(commonValues.getPageCount());
            System.err.println(commonValues.getCurrentPage() + " out of range. Opening on last page");
            LogWriter.writeLog(commonValues.getCurrentPage() + " out of range. Opening on last page");
        }
        decode_pdf.setExtractionMode(1, currentGUI.getScaling());
        currentGUI.setPageNumber();
        currentGUI.resetRotationBox();
        if (commonValues.isPDF()) {
            currentGUI.decodePage();
        } else {
            currentGUI.scaleAndRotate();
            currentGUI.reinitialiseTabs(false);
            Images.decodeImage(decode_pdf, currentGUI, thumbnails, commonValues);
        }
        if (linearObject != null) {
            ((LinearizedObject)linearObject).setBoolean(859785322, true);
        }
    }

    private static String selectURL(Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, SwingThumbnailPanel thumbnails) {
        String selectedFile = currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.RequestURL"));
        if (selectedFile != null) {
            selectedFile = selectedFile.trim();
        }
        if (!(selectedFile == null || selectedFile.trim().startsWith("http://") || selectedFile.trim().startsWith("https://") || selectedFile.trim().startsWith("file:/"))) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.URLMustContain"));
            selectedFile = null;
        }
        if (selectedFile != null && !OpenFile.isSupportedFileExtension(selectedFile)) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            selectedFile = null;
        }
        if (selectedFile != null) {
            commonValues.setSelectedFile(selectedFile);
            boolean failed = false;
            try {
                URL testExists = new URL(selectedFile);
                URLConnection conn = testExists.openConnection();
                if (conn.getContent() == null) {
                    failed = true;
                }
            }
            catch (IOException e2) {
                failed = true;
                LogWriter.writeLog("Exception in handling URL " + e2);
            }
            if (failed) {
                selectedFile = null;
                currentGUI.showMessageDialog("URL null" + Messages.getMessage("PdfViewerError.DoesNotExist"));
            }
        }
        if (selectedFile != null) {
            try {
                commonValues.setFileSize(0L);
                currentGUI.setViewerTitle();
            }
            catch (Exception e3) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + e3 + ' ' + Messages.getMessage("PdfViewerError.GettingPaths"));
            }
            if (!Values.isProcessing()) {
                thumbnails.terminateDrawing();
                decode_pdf.flushObjectValues(true);
                currentGUI.stopThumbnails();
                OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            }
        } else {
            decode_pdf.repaint();
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
        return selectedFile;
    }

    public static boolean isSupportedFileExtension(String filename) {
        String ext;
        int idx;
        if (filename != null && !filename.isEmpty() && (idx = filename.lastIndexOf(46)) != -1 && !(ext = filename.substring(idx + 1)).isEmpty()) {
            if ("pdf".equalsIgnoreCase(ext = ext.toLowerCase()) || "fdf".equalsIgnoreCase(ext)) {
                return true;
            }
            return SupportedFormats.hasDecoderSupportForImageFormat(ext);
        }
        return false;
    }

    public static File showFileDialog(Component parentComponent, String startingDir, String startingFile, boolean open) {
        if (DecoderOptions.isRunningOnMac) {
            return OpenFile.showFileDialogMac(startingDir, startingFile, open);
        }
        return OpenFile.showFileDialogWin(parentComponent, startingDir, startingFile, open);
    }

    private static File showFileDialogMac(String startingDir, String startingFile, boolean open) {
        FileDialog fileDialog = new FileDialog((Frame)null, "chooser");
        fileDialog.setFile(startingDir);
        if (startingFile != null) {
            fileDialog.setFile(startingFile);
        }
        if (open) {
            fileDialog.setMode(0);
        } else {
            fileDialog.setMode(1);
        }
        fileDialog.setFilenameFilter((dir, name) -> OpenFile.isSupportedFileExtension(name));
        fileDialog.setVisible(true);
        String dir2 = fileDialog.getDirectory();
        String file = fileDialog.getFile();
        return file == null ? null : new File(dir2, file);
    }

    private static File showFileDialogWin(Component parentComponent, String startingDir, String startingFile, boolean open) {
        JFileChooser chooser = new JFileChooser(startingDir);
        chooser.setName("chooser");
        if (startingFile != null) {
            chooser.setSelectedFile(new File(startingFile));
        }
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "PDF (*.pdf)"));
        chooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "FDF (*.fdf)"));
        String[][] formats = SupportedFormats.getSupportedImageDecoders();
        for (int i2 = 0; i2 != formats.length; ++i2) {
            StringBuilder descriptionBuilder = new StringBuilder();
            descriptionBuilder.append(formats[i2][0].toUpperCase());
            descriptionBuilder.append(" (*.").append(formats[i2][0]);
            for (int f2 = 1; f2 != formats[i2].length; ++f2) {
                descriptionBuilder.append(";*.").append(formats[i2][f2]);
            }
            descriptionBuilder.append(')');
            chooser.addChoosableFileFilter(new FileFilterer(formats[i2], descriptionBuilder.toString()));
        }
        int state = open ? chooser.showOpenDialog(parentComponent) : chooser.showSaveDialog(parentComponent);
        if (state == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }
}

