/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.ObjectsViewer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class Objects {
    private Objects() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            if (commonValues.getSelectedFile() == null) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.OpenFile"));
            } else if (!decode_pdf.isExtractionAllowed()) {
                if (commonValues.isPDF()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPermissionsError.Extraction"));
                }
            } else {
                ObjectsViewer objectsViewer = new ObjectsViewer(currentGUI, commonValues, decode_pdf.getIO());
                try {
                    objectsViewer.init();
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Exception reading Objects: " + e2);
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ObjectsParsingError"));
                }
            }
        }
    }
}

