/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.util.Objects;
import javax.swing.JList;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SearchList;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public final class NextResults {
    private NextResults() {
    }

    public static Object execute(Object[] args, Values commonValues, SwingSearchWindow searchFrame, SwingGUI currentGUI, PdfDecoderInt decode_pdf) {
        Integer status = null;
        JList results = null;
        if (args == null) {
            int index;
            int page;
            int id2;
            int currPage = commonValues.getCurrentPage();
            if (!(decode_pdf.getDisplayView() != 3 && decode_pdf.getDisplayView() != 4 || (id2 = (results = searchFrame.getResults()).getSelectedIndex()) == -1 || (page = ((SearchList)results).getTextPages().get(id2).intValue()) != currPage && page != currPage + 1)) {
                currPage = page;
            }
            if ((index = (results = searchFrame.getResults(currPage)).getSelectedIndex()) < 0) {
                index = 0;
                results.setSelectedIndex(index);
            }
            if (index == ((SearchList)results).getResultCount() - 1 || ((SearchList)results).getResultCount() == 0) {
                index = 0;
                int currentPage = currPage + 1;
                if (currentPage > commonValues.getPageCount()) {
                    currentPage = 1;
                }
                results = searchFrame.getResults(currentPage);
                while (((SearchList)results).getResultCount() < 1 && currentPage < commonValues.getPageCount() + 1 && searchFrame.getViewStyle() == 2) {
                    results = searchFrame.getResults(currentPage);
                    ++currentPage;
                }
                if (((SearchList)results).getResultCount() < 1 && currentPage == commonValues.getPageCount() + 1) {
                    status = Commands.SEARCH_RETURNED_TO_START;
                    for (currentPage = 1; ((SearchList)results).getResultCount() < 1 && currentPage <= commonValues.getCurrentPage() && searchFrame.getViewStyle() == 2; ++currentPage) {
                        results = searchFrame.getResults(currentPage);
                    }
                    if (((SearchList)results).getResultCount() < 1) {
                        status = Commands.SEARCH_NOT_FOUND;
                    }
                }
            } else {
                ++index;
            }
            currentGUI.setResults((SearchList)results);
            results.setSelectedIndex(index);
            int id3 = results.getSelectedIndex();
            if (!commonValues.getAllHighlightsShown()) {
                decode_pdf.getTextLines().clearHighlights();
            }
            if (id3 != -1) {
                Integer key = id3;
                Integer newPage = ((SearchList)results).getTextPages().get(key);
                if (newPage != null) {
                    if (commonValues.getCurrentPage() != newPage.intValue()) {
                        PageNavigator.gotoPage(newPage.toString(), currentGUI, commonValues, decode_pdf);
                    }
                    while (Values.isProcessing()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e2) {
                            LogWriter.writeLog(e2);
                        }
                    }
                    if (!Objects.equals(currPage, newPage) && commonValues.getAllHighlightsShown()) {
                        NextResults.addAllHighlightsToPage((SearchList)results, searchFrame, decode_pdf, newPage);
                    }
                    if (!commonValues.getAllHighlightsShown()) {
                        NextResults.addSingleHighlightToPage((SearchList)results, decode_pdf, newPage, id3);
                    }
                    decode_pdf.getPages().refreshDisplay();
                    decode_pdf.repaintPane(commonValues.getCurrentPage());
                }
            }
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
        }
        if (commonValues.getCurrentPage() == searchFrame.getFirstPageWithResults() && results != null && results.getSelectedIndex() == 0) {
            status = Commands.FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN;
        }
        return status;
    }

    private static void addSingleHighlightToPage(SearchList results, PdfDecoderInt decode_pdf, Integer newPage, int key) {
        Object highlight = results.textAreas().get(key);
        if (highlight instanceof int[]) {
            decode_pdf.getTextLines().addHighlights(new int[][]{(int[])highlight}, true, newPage);
        } else {
            decode_pdf.getTextLines().addHighlights((int[][])highlight, true, newPage);
        }
    }

    private static void addAllHighlightsToPage(SearchList results, SwingSearchWindow searchFrame, PdfDecoderInt decode_pdf, Integer newPage) {
        Vector_Rectangle_Int storageVector = new Vector_Rectangle_Int();
        for (int k2 = 0; k2 != results.getResultCount(); ++k2) {
            if (!Objects.equals(results.getTextPages().get(k2), newPage)) continue;
            Object h2 = searchFrame.getTextRectangles().get(k2);
            if (h2 instanceof int[]) {
                storageVector.addElement((int[])h2);
            }
            if (!(h2 instanceof int[][])) continue;
            int[][] areas = (int[][])h2;
            for (int i2 = 0; i2 != areas.length; ++i2) {
                storageVector.addElement(areas[i2]);
            }
        }
        storageVector.trim();
        int[][] finalHighlight = storageVector.get();
        decode_pdf.getTextLines().addHighlights(finalHighlight, true, newPage);
    }
}

