/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.LogWriter;

final class ModeChange {
    private ModeChange() {
    }

    static void changeModeInSwing(int mode, PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        if (SwingUtilities.isEventDispatchThread()) {
            currentGUI.setDisplayView(mode, 2);
            ModeChange.chooseMode(decode_pdf, commonValues, currentGUI);
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
            if (decode_pdf.getDisplayView() == 5) {
                ModeChange.selectCurrentGui(currentGUI);
            } else {
                currentGUI.setSelectedComboIndex(251, 0);
                currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
            }
        } else {
            Runnable doPaintComponent = () -> {
                currentGUI.setDisplayView(mode, 2);
                ModeChange.chooseMode(decode_pdf, commonValues, currentGUI);
                currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
                if (decode_pdf.getDisplayView() == 5) {
                    ModeChange.selectCurrentGui(currentGUI);
                } else {
                    currentGUI.setSelectedComboIndex(251, 0);
                    currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                }
            };
            try {
                SwingUtilities.invokeAndWait(doPaintComponent);
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
    }

    private static void chooseMode(PdfDecoderInt decode_pdf, Values commonValues, SwingGUI currentGUI) {
        if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
            boolean isRightPage;
            boolean separateCoverOn = "true".equalsIgnoreCase(currentGUI.getProperties().getValue("separateCoverOn"));
            decode_pdf.getPages().setBoolean(Display.BoolValue.SEPARATE_COVER, separateCoverOn);
            int p2 = commonValues.getCurrentPage();
            if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                isRightPage = (p2 & 1) == 1;
            } else {
                boolean bl2 = isRightPage = (p2 & 1) == 0;
            }
            if (isRightPage && p2 != 1) {
                --p2;
            }
            commonValues.setCurrentPage(p2);
            currentGUI.setPage(p2);
            currentGUI.decodePage();
        }
    }

    private static void selectCurrentGui(SwingGUI currentGUI) {
        currentGUI.decodePage();
        if (currentGUI.getSelectedComboIndex(252) != 0) {
            currentGUI.setSelectedComboIndex(252, 0);
            currentGUI.getSelectedComboItem(252);
        }
        if (currentGUI.getSelectedComboIndex(252) == 0) {
            int w2 = currentGUI.getPdfDecoder().getPdfPageData().getCropBoxWidth(currentGUI.getValues().getCurrentPage()) / 2;
            int h2 = currentGUI.getPdfDecoder().getPdfPageData().getCropBoxHeight(currentGUI.getValues().getCurrentPage()) / 2;
            if (w2 > 800) {
                w2 = 800;
            }
            if (h2 > 600) {
                h2 = 600;
            }
            currentGUI.getFrame().setMinimumSize(new Dimension(w2, h2));
        }
    }
}

