/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SwingWorker;

final class Images {
    private Images() {
    }

    public static void addImage(PdfDecoderInt decode_pdf, Values commonValues) {
        GraphicsState gs = new GraphicsState();
        gs.CTM[0][0] = commonValues.getBufferedImg().getWidth();
        gs.CTM[1][1] = commonValues.getBufferedImg().getHeight();
        decode_pdf.getDynamicRenderer().drawImage(1, commonValues.getBufferedImg(), gs, false, "image", -1);
        if (commonValues.isMultiTiff()) {
            if (commonValues.getBufferedImg() != null) {
                decode_pdf.getPdfPageData().setMediaBox(new float[]{0.0f, 0.0f, commonValues.getBufferedImg().getWidth(), commonValues.getBufferedImg().getHeight()});
            }
            decode_pdf.getPdfPageData().checkSizeSet(1);
        }
    }

    public static void decodeImage(final PdfDecoderInt decode_pdf, final SwingGUI currentGUI, final SwingThumbnailPanel thumbnails, final Values commonValues) {
        decode_pdf.getTextLines().clearHighlights();
        currentGUI.resetComboBoxes(false);
        currentGUI.getButtons().setPageLayoutButtonsEnabled(false);
        decode_pdf.getDynamicRenderer().writeCustom(43, null);
        decode_pdf.getPages().refreshDisplay();
        thumbnails.terminateDrawing();
        Values.setProcessing(true);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    if (commonValues.getBufferedImg() != null) {
                        Images.addImage(decode_pdf, commonValues);
                    }
                    PdfPageData page_data = decode_pdf.getPdfPageData();
                    if (commonValues.getBufferedImg() != null) {
                        page_data.setMediaBox(new float[]{0.0f, 0.0f, commonValues.getBufferedImg().getWidth(), commonValues.getBufferedImg().getHeight()});
                    }
                    page_data.checkSizeSet(1);
                    currentGUI.resetRotationBox();
                    if (thumbnails.isShownOnscreen()) {
                        currentGUI.scaleAndRotate();
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    currentGUI.setPageNumber();
                    currentGUI.setViewerTitle();
                    currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
                }
                catch (InterruptedException e2) {
                    LogWriter.writeLog("Exception in handling title " + e2);
                    currentGUI.setViewerTitle();
                    Values.setProcessing(false);
                }
                currentGUI.setStatusProgress(100);
                currentGUI.resetComboBoxes(true);
                decode_pdf.repaint();
                Values.setOpeningTransferedFile(false);
                Values.setProcessing(false);
                return null;
            }
        };
        worker.start();
    }
}

