/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.utils.PropertiesFile;

public final class FullScreen {
    private static Window win;
    private static Point screenPosition;

    private FullScreen() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, SwingThumbnailPanel thumbnails, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        if (args == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            if (win == null) {
                Frame frame = new Frame(gs.getDefaultConfiguration());
                win = new Window(frame);
            } else if (gs.getFullScreenWindow() != null && gs.getFullScreenWindow().equals(win)) {
                FullScreen.exitFullScreen(currentGUI);
                return;
            }
            currentGUI.getFrame().remove(currentGUI.getDisplayPane());
            win.add((Component)currentGUI.getDisplayPane(), "Center");
            JButton btn = new JButton("Return");
            win.add((Component)btn, "North");
            btn.addActionListener(evt -> FullScreen.exitFullScreen(currentGUI));
            try {
                screenPosition = currentGUI.getFrame().getLocation();
                gs.setFullScreenWindow(win);
                win.validate();
                currentGUI.scaleAndRotate();
            }
            catch (Error e2) {
                currentGUI.showMessageDialog("Full screen mode not supported on this machine.\nJPedal will now exit " + e2);
                Exit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
            }
        }
    }

    private static void exitFullScreen(SwingGUI currentGUI) {
        Runnable doPaintComponent = () -> {
            if (win != null) {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                gs.setFullScreenWindow(null);
                win.remove(currentGUI.getDisplayPane());
                if (currentGUI.getFrame() instanceof JFrame) {
                    ((RootPaneContainer)((Object)currentGUI.getFrame())).getContentPane().add((Component)currentGUI.getDisplayPane(), "Center");
                    currentGUI.getFrame().setVisible(true);
                    if (screenPosition != null) {
                        currentGUI.getFrame().setLocation(screenPosition);
                    }
                    screenPosition = null;
                } else {
                    currentGUI.getFrame().add((Component)currentGUI.getDisplayPane(), "Center");
                }
                ((Component)currentGUI.getDisplayPane()).invalidate();
                ((JComponent)currentGUI.getDisplayPane()).updateUI();
                if (currentGUI.getFrame() instanceof JFrame) {
                    ((RootPaneContainer)((Object)currentGUI.getFrame())).getContentPane().validate();
                } else {
                    ((Component)currentGUI.getFrame()).validate();
                }
                win.dispose();
                win = null;
                currentGUI.scaleAndRotate();
            }
        };
        SwingUtilities.invokeLater(doPaintComponent);
    }
}

