/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Copy;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.utils.Messages;

public final class Find {
    private Find() {
    }

    public static void execute(Object[] args, Values commonValues, SwingGUI currentGUI, PdfDecoderInt decode_pdf, SwingSearchWindow searchFrame) {
        if (args == null) {
            if (commonValues.getSelectedFile() == null) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
            } else if (!commonValues.isPDF()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
            } else if (decode_pdf.getDisplayView() != 1 && decode_pdf.getDisplayView() != 2 && decode_pdf.getDisplayView() != 3) {
                currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SingleContfacingFacingPageOnly"));
            } else if (!searchFrame.isSearchVisible()) {
                searchFrame.find(decode_pdf, commonValues);
                searchFrame.grabFocusInInput();
            }
            if (decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage()) != null) {
                String searchText = Copy.copySelectedText(decode_pdf, currentGUI, commonValues);
                searchFrame.setSearchText(searchText);
            }
        } else {
            boolean singlePageSearch;
            boolean multiTerms;
            int searchType;
            String value = (String)args[0];
            if (args.length > 1) {
                searchType = (Integer)args[1];
                multiTerms = (Boolean)args[2];
                singlePageSearch = (Boolean)args[3];
            } else {
                searchType = 0;
                multiTerms = false;
                singlePageSearch = false;
            }
            if ((searchType & 0x10) == 16) {
                commonValues.setAllHighlightsShown(true);
            }
            searchFrame.findWithoutWindow(decode_pdf, commonValues, searchType, multiTerms, singlePageSearch, value);
        }
    }
}

