/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Component;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.ModeChange;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.Messages;

public final class Facing {
    private static boolean irregularSizesWarningShown;

    private Facing() {
    }

    public static void execute(Object[] args, PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        if (!decode_pdf.isOpen() || decode_pdf.getDisplayView() == 4) {
            return;
        }
        if (args == null) {
            String defaultValue = currentGUI.getProperties().getValue("enhancedFacingMode");
            if (Boolean.parseBoolean(defaultValue)) {
                if (decode_pdf.getPdfPageData().hasMultipleSizes()) {
                    if (!irregularSizesWarningShown) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.PageDragIrregularSizes"));
                        irregularSizesWarningShown = true;
                    }
                    decode_pdf.getPages().setBoolean(Display.BoolValue.TURNOVER_ON, false);
                } else {
                    decode_pdf.getPages().setBoolean(Display.BoolValue.TURNOVER_ON, true);
                }
            }
            currentGUI.getCombo(252).setEnabled(true);
            currentGUI.getCombo(251).setEnabled(false);
            currentGUI.getButtons().getButton(35).setEnabled(false);
            currentGUI.getButtons().getButton(36).setEnabled(false);
            if (currentGUI.getGlassPane() != null) {
                ((Component)currentGUI.getGlassPane()).setVisible(true);
            }
            currentGUI.getButtons().getButton(29).setEnabled(true);
            currentGUI.getButtons().getButton(13).setEnabled(true);
            currentGUI.setSelectedComboIndex(252, 0);
            currentGUI.scaleAndRotate();
            currentGUI.getButtons().alignLayoutMenuOption(4);
            ModeChange.changeModeInSwing(4, decode_pdf, currentGUI, commonValues);
            currentGUI.updateTextBoxSize();
        }
    }
}

