/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Copy;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public final class ExtractText {
    private ExtractText() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (args == null) {
            ExtractText.extractSelectedText(currentGUI, decode_pdf, commonValues);
        }
    }

    private static String extractTextList(PdfDecoderInt decode_pdf, Values commonValues, SwingGUI currentGUI, boolean isXML, int t_x1, int t_x2, int t_y1, int t_y2) throws PdfException {
        String extractedText = "";
        List<String> words = decode_pdf.getGroupingObject().extractTextAsWordlist(t_x1, t_y1, t_x2, t_y2, commonValues.getCurrentPage(), true, null);
        if (words == null) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + t_x1 + " y1:" + t_y1 + " x2:" + t_x2 + " y2:" + t_y2);
        } else {
            StringBuilder textOutput = new StringBuilder();
            Iterator<String> wordIterator = words.iterator();
            while (wordIterator.hasNext()) {
                String currentWord = wordIterator.next();
                if (!isXML) {
                    currentWord = Strip.convertToText(currentWord, decode_pdf.isXMLExtraction());
                }
                int wx1 = (int)Float.parseFloat(wordIterator.next());
                int wy1 = (int)Float.parseFloat(wordIterator.next());
                int wx2 = (int)Float.parseFloat(wordIterator.next());
                int wy2 = (int)Float.parseFloat(wordIterator.next());
                textOutput.append(currentWord).append(',').append(wx1).append(',').append(wy1).append(',').append(wx2).append(',').append(wy2).append('\n');
            }
            extractedText = textOutput.toString();
        }
        return extractedText;
    }

    private static String extractTextRectangle(Values commonValues, PdfDecoderInt decode_pdf, SwingGUI currentGUI, boolean isXML, int t_x1, int t_x2, int t_y1, int t_y2) throws PdfException {
        String extractedText = decode_pdf.getGroupingObject().extractTextInRectangle(t_x1, t_y1, t_x2, t_y2, commonValues.getCurrentPage(), false, true);
        if (extractedText == null) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + t_x1 + " y1:" + t_y1 + " x2:" + t_x2 + " y2:" + t_y2);
            return "";
        }
        if (!isXML) {
            extractedText = Strip.stripXML(extractedText, decode_pdf.isXMLExtraction()).toString();
        }
        return extractedText;
    }

    private static void extractSelectedText(SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (!decode_pdf.isExtractionAllowed()) {
            currentGUI.showMessageDialog("Not allowed");
            return;
        }
        int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
        if (highlights == null) {
            currentGUI.showMessageDialog("There is no text selected.\nPlease highlight the text you wish to extract.", "No Text selected", 0);
            return;
        }
        JScrollPane examplePane = new JScrollPane();
        JPanel display_value = new JPanel();
        ButtonGroup group = new ButtonGroup();
        JRadioButton text = new JRadioButton(Messages.getMessage("PdfViewerOption.ExtractAsText"));
        JRadioButton xml = new JRadioButton(Messages.getMessage("PdfViewerOption.ExtractAsXML"));
        JRadioButton rectangleGrouping = new JRadioButton(Messages.getMessage("PdfViewerRect.label"));
        JRadioButton wordListExtraction = new JRadioButton(Messages.getMessage("PdfViewerWordList.label"));
        SpringLayout layout = new SpringLayout();
        JFrame extractionFrame = new JFrame(Messages.getMessage("PdfViewerCoords.message") + ' ' + commonValues.m_x1 + " , " + commonValues.m_y1 + " , " + (commonValues.m_x2 - commonValues.m_x1) + " , " + (commonValues.m_y2 - commonValues.m_y1));
        extractionFrame.setDefaultCloseOperation(2);
        JLabel demoMessage = new JLabel("                         ");
        ButtonGroup type = new ButtonGroup();
        Object[] options = new Object[]{Messages.getMessage("PdfViewerHelpMenu.text"), Messages.getMessage("PdfViewerCancel.text"), Messages.getMessage("PdfViewerextract.text")};
        JButton help = new JButton((String)options[0]);
        JButton cancel = new JButton((String)options[1]);
        JButton extract = new JButton((String)options[2]);
        display_value.setLayout(layout);
        Runnable r2 = ExtractText.updateScrollPane(currentGUI, decode_pdf, commonValues, display_value, group, xml, wordListExtraction, layout);
        ActionListener scrollPaneUpdater = e2 -> SwingUtilities.invokeLater(r2);
        demoMessage.setFont(new Font("SansSerif", 1, 10));
        demoMessage.setForeground(Color.red);
        layout.putConstraint("West", (Component)demoMessage, 5, "West", (Component)display_value);
        layout.putConstraint("South", (Component)demoMessage, -5, "South", (Component)display_value);
        display_value.add(demoMessage);
        rectangleGrouping.setSelected(true);
        rectangleGrouping.addActionListener(scrollPaneUpdater);
        group.add(rectangleGrouping);
        rectangleGrouping.setToolTipText(Messages.getMessage("PdfViewerRect.message"));
        layout.putConstraint("West", (Component)rectangleGrouping, 10, "West", (Component)display_value);
        layout.putConstraint("North", (Component)rectangleGrouping, 5, "North", (Component)display_value);
        display_value.add(rectangleGrouping);
        wordListExtraction.setSelected(true);
        wordListExtraction.addActionListener(scrollPaneUpdater);
        group.add(wordListExtraction);
        wordListExtraction.setToolTipText(Messages.getMessage("PdfViewerWordList.message"));
        layout.putConstraint("East", (Component)wordListExtraction, -5, "East", (Component)display_value);
        layout.putConstraint("North", (Component)wordListExtraction, 5, "North", (Component)display_value);
        display_value.add(wordListExtraction);
        examplePane.setPreferredSize(new Dimension(315, 150));
        examplePane.setMinimumSize(new Dimension(315, 150));
        layout.putConstraint("East", (Component)examplePane, -5, "East", (Component)display_value);
        layout.putConstraint("North", (Component)examplePane, 5, "South", (Component)display_value);
        display_value.add(examplePane);
        type.add(xml);
        type.add(text);
        xml.addActionListener(scrollPaneUpdater);
        text.addActionListener(scrollPaneUpdater);
        text.setSelected(true);
        layout.putConstraint("West", (Component)xml, 5, "West", (Component)display_value);
        layout.putConstraint("South", (Component)xml, -5, "North", (Component)extract);
        display_value.add(xml);
        layout.putConstraint("East", (Component)text, -5, "East", (Component)display_value);
        layout.putConstraint("South", (Component)text, -5, "North", (Component)extract);
        display_value.add(text);
        layout.putConstraint("South", (Component)extract, -5, "North", (Component)demoMessage);
        layout.putConstraint("East", (Component)extract, -5, "East", (Component)display_value);
        display_value.add(extract);
        layout.putConstraint("South", (Component)cancel, -5, "North", (Component)demoMessage);
        layout.putConstraint("East", (Component)cancel, -5, "West", (Component)extract);
        display_value.add(cancel);
        layout.putConstraint("South", (Component)help, -5, "North", (Component)demoMessage);
        layout.putConstraint("East", (Component)help, -5, "West", (Component)cancel);
        display_value.add(help);
        help.addActionListener(e2 -> {
            JTextArea info = new JTextArea(Messages.getMessage("PdfViewerGroupingInfo.message"));
            currentGUI.showMessageDialog(info);
        });
        cancel.addActionListener(e2 -> {
            extractionFrame.setVisible(false);
            extractionFrame.dispose();
        });
        extract.addActionListener(e2 -> ExtractText.popupExtractedTextInDisplay(currentGUI, decode_pdf, commonValues, highlights, xml, rectangleGrouping, wordListExtraction));
        extractionFrame.getContentPane().add((Component)display_value, "Center");
        extractionFrame.setSize(350, 300);
        SwingUtilities.invokeLater(r2);
        extractionFrame.setLocationRelativeTo(currentGUI.getFrame());
        extractionFrame.setResizable(false);
        extractionFrame.setVisible(true);
    }

    private static Runnable updateScrollPane(SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues, JPanel display_value, ButtonGroup group, JRadioButton xml, JRadioButton wordListExtraction, SpringLayout layout) {
        return () -> {
            Enumeration<AbstractButton> en = group.getElements();
            while (en.hasMoreElements()) {
                AbstractButton button = en.nextElement();
                if (!button.isSelected()) continue;
                Component[] com = display_value.getComponents();
                for (int i2 = 0; i2 != com.length; ++i2) {
                    if (!(com[i2] instanceof JScrollPane)) continue;
                    display_value.remove(com[i2]);
                }
                try {
                    JScrollPane scroll = ExtractText.updateExtractionExample(decode_pdf, commonValues, currentGUI, button, xml.isSelected());
                    if (scroll != null) {
                        layout.putConstraint("East", (Component)scroll, -5, "East", (Component)display_value);
                        layout.putConstraint("North", (Component)scroll, 5, "South", (Component)wordListExtraction);
                        display_value.add(scroll);
                        break;
                    }
                    JLabel noExample = new JLabel("No Example Available");
                    Font exampleFont = noExample.getFont();
                    exampleFont = exampleFont.deriveFont(exampleFont.getStyle(), 20.0f);
                    noExample.setFont(exampleFont);
                    noExample.setForeground(Color.RED);
                    layout.putConstraint("East", (Component)noExample, -75, "East", (Component)display_value);
                    layout.putConstraint("North", (Component)noExample, 50, "South", (Component)wordListExtraction);
                    display_value.add(noExample);
                }
                catch (PdfException ex) {
                    LogWriter.writeLog("[PDFException] " + ex);
                }
                break;
            }
            display_value.updateUI();
        };
    }

    private static void popupExtractedTextInDisplay(SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues, int[][] highlights, JRadioButton xml, JRadioButton rectangleGrouping, JRadioButton wordListExtraction) {
        try {
            StringBuilder finalValue = new StringBuilder();
            if (highlights != null) {
                for (int t2 = 0; t2 != highlights.length; ++t2) {
                    String extractedText = "";
                    PdfPageData page_data = decode_pdf.getPdfPageData();
                    int[] adjustedHighlight = Copy.adjustHighlightForExtraction(highlights[t2]);
                    highlights[t2] = Copy.convertHighlightToPageCoords(adjustedHighlight, page_data, commonValues.getCurrentPage());
                    int[] pageCoords = highlights[t2];
                    if (rectangleGrouping.isSelected()) {
                        extractedText = ExtractText.extractTextRectangle(commonValues, decode_pdf, currentGUI, xml.isSelected(), pageCoords[0], pageCoords[2], pageCoords[1], pageCoords[3]) + '\r' + '\n';
                    } else if (wordListExtraction.isSelected()) {
                        extractedText = ExtractText.extractTextList(decode_pdf, commonValues, currentGUI, xml.isSelected(), pageCoords[0], pageCoords[2], pageCoords[1], pageCoords[3]);
                    }
                    finalValue.append(extractedText);
                }
            }
            ExtractText.displayText(currentGUI, finalValue.toString());
        }
        catch (PdfException e2) {
            LogWriter.writeLog(e2);
        }
    }

    private static void displayText(SwingGUI currentGUI, String finalValue) {
        JScrollPane scroll = new JScrollPane();
        try {
            JTextPane text_pane = new JTextPane();
            scroll = ExtractText.createPane(text_pane, finalValue, true);
        }
        catch (BadLocationException e2) {
            LogWriter.writeLog(e2);
        }
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setPreferredSize(new Dimension(400, 400));
        JDialog displayFrame = new JDialog((Frame)null, true);
        displayFrame.setDefaultCloseOperation(2);
        Container frame = currentGUI.getFrame();
        displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
        displayFrame.setSize(450, 450);
        displayFrame.setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
        displayFrame.getContentPane().setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)scroll, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)buttonBar, "South");
        JButton yes = new JButton(Messages.getMessage("PdfViewerMenu.return"));
        yes.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)yes, "West");
        yes.addActionListener(e13 -> displayFrame.dispose());
        JButton no = new JButton(Messages.getMessage("PdfViewerFileMenuExit.text"));
        no.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)no, "East");
        no.addActionListener(e12 -> displayFrame.dispose());
        displayFrame.setVisible(true);
    }

    private static JScrollPane createPane(JTextPane text_pane, String content, boolean useXML) throws BadLocationException {
        text_pane.setEditable(true);
        text_pane.setFont(new Font("SansSerif", 0, 14));
        text_pane.setToolTipText(Messages.getMessage("PdfViewerTooltip.text"));
        Document doc = text_pane.getDocument();
        text_pane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), Messages.getMessage("PdfViewerTitle.text")));
        SimpleAttributeSet token_attribute = new SimpleAttributeSet();
        SimpleAttributeSet text_attribute = new SimpleAttributeSet();
        SimpleAttributeSet plain_attribute = new SimpleAttributeSet();
        Color bgColor = text_pane.getBackground();
        if (bgColor != null) {
            double luma = (0.299 * (double)bgColor.getRed() + 0.587 * (double)bgColor.getGreen() + 0.114 * (double)bgColor.getBlue()) / 255.0;
            if (luma > 0.5) {
                StyleConstants.setForeground(token_attribute, Color.blue);
            } else {
                StyleConstants.setForeground(token_attribute, new Color(64, 128, 255));
            }
        } else {
            StyleConstants.setForeground(token_attribute, Color.blue);
        }
        StyleConstants.setForeground(text_attribute, text_pane.getForeground());
        StyleConstants.setForeground(plain_attribute, text_pane.getForeground());
        int pointer = 0;
        if (useXML && content != null) {
            StringTokenizer data_As_tokens = new StringTokenizer(content, "<>", true);
            while (data_As_tokens.hasMoreTokens()) {
                String next_item = data_As_tokens.nextToken();
                if ("<".equals(next_item) && data_As_tokens.hasMoreTokens()) {
                    String current_token = next_item + data_As_tokens.nextToken() + data_As_tokens.nextToken();
                    doc.insertString(pointer, current_token, token_attribute);
                    pointer += current_token.length();
                    continue;
                }
                doc.insertString(pointer, next_item, text_attribute);
                pointer += next_item.length();
            }
        } else {
            doc.insertString(pointer, content, plain_attribute);
        }
        JScrollPane text_scroll = new JScrollPane();
        text_scroll.getViewport().add(text_pane);
        text_scroll.setHorizontalScrollBarPolicy(31);
        text_scroll.setVerticalScrollBarPolicy(20);
        return text_scroll;
    }

    private static JScrollPane updateExtractionExample(PdfDecoderInt decode_pdf, Values commonValues, SwingGUI currentGUI, AbstractButton button, boolean xml) throws PdfException {
        JScrollPane scroll = new JScrollPane();
        StringBuilder finalString = new StringBuilder();
        PdfPageData page_data = decode_pdf.getPdfPageData();
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
        if (highlights != null) {
            for (int t2 = 0; t2 != highlights.length; ++t2) {
                int temp;
                if (highlights[t2] == null) continue;
                highlights[t2] = Copy.adjustHighlightForExtraction(highlights[t2]);
                int t_x1 = highlights[t2][0];
                int t_x2 = highlights[t2][0] + highlights[t2][2];
                int t_y1 = highlights[t2][1] + highlights[t2][3];
                int t_y2 = highlights[t2][1];
                if (t_y1 < t_y2) {
                    temp = t_y2;
                    t_y2 = t_y1;
                    t_y1 = temp;
                }
                if (t_x1 > t_x2) {
                    temp = t_x2;
                    t_x2 = t_x1;
                    t_x1 = temp;
                }
                if (t_x1 < cropX) {
                    t_x1 = cropX;
                }
                if (t_x1 > cropX + cropW) {
                    t_x1 = cropX + cropW;
                }
                if (t_x2 < cropX) {
                    t_x2 = cropX;
                }
                if (t_x2 > cropX + cropW) {
                    t_x2 = cropX + cropW;
                }
                if (t_y1 < cropY) {
                    t_y1 = cropY;
                }
                if (t_y1 > cropY + cropH) {
                    t_y1 = cropY + cropH;
                }
                if (t_y2 < cropY) {
                    t_y2 = cropY;
                }
                if (t_y2 > cropY + cropH) {
                    t_y2 = cropY + cropH;
                }
                if ("Rectangle".equals(button.getText())) {
                    finalString.append(ExtractText.extractTextRectangle(commonValues, decode_pdf, currentGUI, xml, t_x1, t_x2, t_y1, t_y2)).append(' ');
                    continue;
                }
                if (!"WordList".equals(button.getText())) continue;
                finalString.append(ExtractText.extractTextList(decode_pdf, commonValues, currentGUI, xml, t_x1, t_x2, t_y1, t_y2));
            }
        }
        if (finalString.length() > 0) {
            return ExtractText.createScrollPane(xml, scroll, finalString);
        }
        return null;
    }

    private static JScrollPane createScrollPane(boolean xml, JScrollPane scroll, StringBuilder finalString) {
        try {
            scroll = ExtractText.createPane(new JTextPane(), finalString.toString(), xml);
        }
        catch (BadLocationException e2) {
            LogWriter.writeLog(e2);
        }
        scroll.setPreferredSize(new Dimension(315, 150));
        scroll.setMinimumSize(new Dimension(315, 150));
        Component[] coms = scroll.getComponents();
        for (int i2 = 0; i2 != coms.length; ++i2) {
            if (!(scroll.getComponent(i2) instanceof JViewport)) continue;
            JViewport view = (JViewport)scroll.getComponent(i2);
            Component[] coms1 = view.getComponents();
            for (int j2 = 0; j2 != coms1.length; ++j2) {
                if (!(coms1[j2] instanceof JTextPane)) continue;
                ((JTextComponent)coms1[j2]).setEditable(false);
            }
        }
        return scroll;
    }
}

