/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.ClipboardImage;
import org.jpedal.examples.viewer.commands.IconiseImage;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class ExtractSelectionAsImage {
    private static BufferedImage snapShot;

    private ExtractSelectionAsImage() {
    }

    private static void extractSelectedScreenAsImage(Values commonValues, SwingGUI currentGUI, PdfDecoderInt decode_pdf) {
        int t_x1 = commonValues.m_x1;
        int t_x2 = commonValues.m_x2;
        int t_y1 = commonValues.m_y1;
        int t_y2 = commonValues.m_y2;
        if (commonValues.m_y1 < commonValues.m_y2) {
            t_y2 = commonValues.m_y1;
            t_y1 = commonValues.m_y2;
        }
        if (commonValues.m_x1 > commonValues.m_x2) {
            t_x2 = commonValues.m_x1;
            t_x1 = commonValues.m_x2;
        }
        snapShot = decode_pdf.getSelectedRectangleOnscreen(t_x1, t_y1, t_x2, t_y2, 100.0f * currentGUI.getScaling());
    }

    public static void execute(Values commonValues, SwingGUI currentGUI, PdfDecoderInt decode_pdf) {
        int col;
        ExtractSelectionAsImage.extractSelectedScreenAsImage(commonValues, currentGUI, decode_pdf);
        if (snapShot == null) {
            return;
        }
        Container frame = currentGUI.getFrame();
        JDialog displayFrame = new JDialog((Frame)null, true);
        JPanel image_display = new JPanel();
        displayFrame.setDefaultCloseOperation(2);
        displayFrame.setLocationRelativeTo(null);
        displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
        String propValue = currentGUI.getProperties().getValue("replacePdfDisplayBackground");
        if (!propValue.isEmpty() && "true".equalsIgnoreCase(propValue)) {
            propValue = currentGUI.getProperties().getValue("pdfDisplayBackground");
            col = Integer.parseInt(propValue);
            image_display.setBackground(new Color(col));
        } else if (decode_pdf.getDecoderOptions().getDisplayBackgroundColor() != null) {
            col = decode_pdf.getDecoderOptions().getDisplayBackgroundColor().getRGB();
            image_display.setBackground(new Color(col));
        } else if (decode_pdf.useNewGraphicsMode()) {
            image_display.setBackground(new Color(55, 55, 65));
        } else {
            image_display.setBackground(new Color(190, 190, 190));
        }
        IconiseImage icon_image = new IconiseImage(snapShot);
        image_display.add((Component)new JLabel(icon_image), "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setBackground(image_display.getBackground());
        JButton copy = new JButton(Messages.getMessage("PdfSnapshotPreview.Copy"));
        copy.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)copy, "East");
        copy.addActionListener(e2 -> {
            displayFrame.setVisible(false);
            ClipboardImage clipboardImage = new ClipboardImage(snapShot);
            Clipboard c2 = Toolkit.getDefaultToolkit().getSystemClipboard();
            c2.setContents(clipboardImage, null);
        });
        JButton yes = new JButton(Messages.getMessage("PdfSnapshotPreview.Save"));
        yes.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)yes, "West");
        yes.addActionListener(e2 -> {
            displayFrame.setVisible(false);
            ExtractSelectionAsImage.saveSnapshot(image_display, currentGUI);
            displayFrame.dispose();
        });
        JButton no = new JButton(Messages.getMessage("PdfSnapshotPreview.Cancel"));
        no.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)no, "East");
        no.addActionListener(e2 -> displayFrame.dispose());
        displayFrame.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        displayFrame.getContentPane().add((Component)image_display, "Center");
        displayFrame.getContentPane().add((Component)buttonBar, "South");
        displayFrame.setResizable(false);
        displayFrame.pack();
        displayFrame.setVisible(true);
    }

    private static void saveSnapshot(Component image_display, SwingGUI currentGUI) {
        boolean finished = false;
        while (!finished) {
            String[][] supportedFormats;
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            for (String[] supportedFormatNames : supportedFormats = SupportedFormats.getSupportedImageEncoders()) {
                chooser.addChoosableFileFilter(new FileFilterer(supportedFormatNames, supportedFormatNames[0]));
            }
            int approved = chooser.showSaveDialog(image_display);
            if (approved == 0) {
                int n2;
                File file = chooser.getSelectedFile();
                StringBuilder fileToSave = new StringBuilder(file.getAbsolutePath());
                String format = chooser.getFileFilter().getDescription();
                if ("All Files".equals(format)) {
                    format = "PNG";
                    String formatChosen = fileToSave.substring(fileToSave.lastIndexOf(".") + 1);
                    String[][] stringArray = supportedFormats;
                    int n3 = stringArray.length;
                    block4: for (int i2 = 0; i2 < n3; ++i2) {
                        String[] supportedFormatNames;
                        for (String supportedFormat : supportedFormatNames = stringArray[i2]) {
                            if (!formatChosen.equals(supportedFormat)) continue;
                            format = supportedFormat;
                            continue block4;
                        }
                    }
                }
                if (!fileToSave.toString().toLowerCase().endsWith(('.' + format).toLowerCase())) {
                    fileToSave.append('.').append(format);
                    file = new File(fileToSave.toString());
                }
                if (file.exists() && (n2 = currentGUI.showConfirmDialog(fileToSave.append('\n') + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                if (snapShot != null) {
                    try {
                        JDeli.write(snapShot, format, new File(fileToSave.toString()));
                    }
                    catch (Exception ex) {
                        LogWriter.writeLog("Exception in writing image " + ex);
                    }
                }
                finished = true;
                continue;
            }
            return;
        }
    }
}

