/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.SaveFile;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class Exit {
    private Exit() {
    }

    public static void execute(Object[] args, SwingThumbnailPanel thumbnails, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        if (args == null) {
            if (PrintStatus.isPrinting()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerStillPrinting.text"));
            } else {
                Exit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
            }
        }
    }

    public static void exit(SwingThumbnailPanel thumbnails, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        thumbnails.terminateDrawing();
        SaveFile.handleUnsaveForms(currentGUI, commonValues);
        if (LogWriter.isRunningFromIDE) {
            int choice = currentGUI.confirmClose() ? JOptionPane.showConfirmDialog(null, new JLabel(Messages.getMessage("PdfViewerExiting")), Messages.getMessage("PdfViewerprogramExit"), 2, -1) : 0;
            if (choice == 2) {
                return;
            }
            if (decode_pdf.getDisplayView() == 5) {
                decode_pdf.getPages().stopGeneratingPage();
            }
        }
        decode_pdf.closePdfFile();
        try {
            properties.setValue("lastDocumentPage", String.valueOf(commonValues.getCurrentPage()));
            if ("true".equalsIgnoreCase(properties.getValue("trackViewerSize"))) {
                properties.setValue("startViewerWidth", String.valueOf(currentGUI.getFrame().getWidth()));
                properties.setValue("startViewerHeight", String.valueOf(currentGUI.getFrame().getHeight()));
            }
            if ("true".equalsIgnoreCase(properties.getValue("trackScaling"))) {
                properties.setValue("startScaling", String.valueOf(currentGUI.getSelectedComboItem(252)));
            }
            if ("true".equalsIgnoreCase(properties.getValue("trackView"))) {
                properties.setValue("startView", String.valueOf(decode_pdf.getDisplayView()));
            }
            if ("true".equalsIgnoreCase(properties.getValue("startSideTabOpen"))) {
                properties.setValue("startSideTabOpen", "true");
            }
            if ("true".equalsIgnoreCase(properties.getValue("trackSelectedSideTab"))) {
                JTabbedPane tabs = currentGUI.getSideTabBar();
                if (DecoderOptions.isRunningOnMac) {
                    properties.setValue("startSelectedSideTab", tabs.getTitleAt(tabs.getSelectedIndex()));
                } else {
                    properties.setValue("startSelectedSideTab", tabs.getIconAt(tabs.getSelectedIndex()).toString());
                }
            }
            if ("true".equalsIgnoreCase(properties.getValue("trackSideTabExpandedSize"))) {
                properties.setValue("sideTabBarExpandLength", String.valueOf(currentGUI.getSplitDividerLocation()));
            }
            properties.writeDoc();
        }
        catch (Exception e1) {
            LogWriter.writeLog("Exception attempting to Write proterties: " + e1);
        }
        if (!Viewer.exitOnClose) {
            currentGUI.getFrame().setVisible(false);
            if (currentGUI.getFrame() instanceof JFrame) {
                ((Window)currentGUI.getFrame()).dispose();
            }
            decode_pdf.dispose();
            currentGUI.dispose();
        } else {
            currentGUI.getFrame().setVisible(false);
            if (currentGUI.getFrame() instanceof JFrame) {
                ((Window)currentGUI.getFrame()).dispose();
            }
            decode_pdf.dispose();
            currentGUI.dispose();
            System.exit(0);
        }
    }
}

