/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.io.IOException;
import org.jpedal.examples.text.ExtractOutline;
import org.jpedal.exception.PdfException;
import org.jpedal.io.outline.OutlineWriter;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public final class CopyOutline {
    private CopyOutline() {
    }

    public static void main(String[] args) {
        int len = args.length;
        if (len == 2) {
            try {
                ExtractOutline extract = new ExtractOutline(args[0]);
                extract.openPDFFile();
                Document outlines = extract.getPDFTextOutline();
                extract.closePDFfile();
                OutlineWriter writer = new OutlineWriter(args[1], outlines);
                writer.writeOutline();
            }
            catch (IOException | PdfException e2) {
                LogWriter.writeLog(e2);
                throw new RuntimeException(e2.getMessage());
            }
        } else {
            System.out.println("Class takes 2 parameters: ");
            System.out.println("Value 1 is the file name of a PDF to copy outlines from");
            System.out.println("Value 2 is the file name of a PDF to copy outlines to");
            if (len > 2) {
                System.out.println("\nToo many arguments entered");
            }
            StringBuilder arguments = new StringBuilder();
            for (String arg : args) {
                arguments.append(arg).append('\n');
            }
            System.out.println("You entered:\n" + arguments);
        }
    }
}

