/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public final class Copy {
    private Copy() {
    }

    public static void execute(SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        String copyText = Copy.copySelectedText(decode_pdf, currentGUI, commonValues);
        StringSelection ss = new StringSelection(copyText);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public static String copySelectedText(PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        if (!decode_pdf.isExtractionAllowed()) {
            currentGUI.showMessageDialog("Not allowed");
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
        if (highlights == null) {
            return "";
        }
        boolean multipleAreas = highlights.length > 1;
        for (int t2 = 0; t2 != highlights.length; ++t2) {
            PdfPageData page_data = decode_pdf.getPdfPageData();
            int[] adjustedHighlight = Copy.adjustHighlightForExtraction(highlights[t2]);
            highlights[t2] = Copy.convertHighlightToPageCoords(adjustedHighlight, page_data, commonValues.getCurrentPage());
            int[] pageCoords = highlights[t2];
            try {
                PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                String extractedText = currentGrouping.extractTextInRectangle(pageCoords[0], pageCoords[1], pageCoords[2], pageCoords[3], commonValues.getCurrentPage(), false, true);
                if (extractedText == null || extractedText.isEmpty()) {
                    if (!multipleAreas) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                    }
                } else {
                    extractedText = Strip.stripXML(extractedText, decode_pdf.isXMLExtraction()).toString();
                }
                if (extractedText == null) continue;
                returnValue.append(extractedText).append('\r').append('\n');
                continue;
            }
            catch (PdfException e2) {
                LogWriter.writeLog(e2);
            }
        }
        if (returnValue.length() > 2) {
            return returnValue.substring(0, returnValue.length() - 2);
        }
        return "";
    }

    public static int[] adjustHighlightForExtraction(int[] highlight) {
        int x2 = highlight[0] - 1;
        int y2 = highlight[1] - 3;
        int width = highlight[2] + 2;
        int height = highlight[3] + 6;
        return new int[]{x2, y2, width, height};
    }

    public static int[] convertHighlightToPageCoords(int[] highlight, PdfPageData page_data, int page) {
        int temp;
        int cropX = page_data.getCropBoxX(page);
        int cropY = page_data.getCropBoxY(page);
        int cropW = page_data.getCropBoxWidth(page);
        int cropH = page_data.getCropBoxHeight(page);
        int t_x1 = highlight[0];
        int t_x2 = highlight[0] + highlight[2];
        int t_y1 = highlight[1] + highlight[3];
        int t_y2 = highlight[1];
        if (t_y1 < t_y2) {
            temp = t_y2;
            t_y2 = t_y1;
            t_y1 = temp;
        }
        if (t_x1 > t_x2) {
            temp = t_x2;
            t_x2 = t_x1;
            t_x1 = temp;
        }
        if (t_x1 < cropX) {
            t_x1 = cropX;
        }
        if (t_x1 > cropW + cropX) {
            t_x1 = cropW + cropX;
        }
        if (t_x2 < cropX) {
            t_x2 = cropX;
        }
        if (t_x2 > cropW + cropX) {
            t_x2 = cropW + cropX;
        }
        if (t_y1 < cropY) {
            t_y1 = cropY;
        }
        if (t_y1 > cropH + cropY) {
            t_y1 = cropH + cropY;
        }
        if (t_y2 < cropY) {
            t_y2 = cropY;
        }
        if (t_y2 > cropH + cropY) {
            t_y2 = cropH + cropY;
        }
        return new int[]{t_x1, t_y1, t_x2, t_y2};
    }
}

