/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.SaveBitmap;
import org.jpedal.examples.viewer.utils.Exporter;
import org.jpedal.utils.Messages;

public final class BitMap {
    private BitMap() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            if (commonValues.getSelectedFile() == null) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.OpenFile"));
            } else if (!decode_pdf.isExtractionAllowed()) {
                if (commonValues.isPDF()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPermissionsError.Extraction"));
                }
            } else {
                SaveBitmap current_selection = new SaveBitmap(commonValues.getInputDir(), commonValues.getPageCount(), commonValues.getCurrentPage());
                int userChoice = current_selection.display(currentGUI.getFrame(), Messages.getMessage("PdfViewer.SaveAsBitmap"));
                if (commonValues.getFileIsURL()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                } else if (userChoice == 0) {
                    Exporter exporter = new Exporter(currentGUI, commonValues.getSelectedFile(), decode_pdf);
                    exporter.extractPagesAsImages(current_selection);
                }
            }
        }
    }
}

