/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.ViewerValues;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SearchList;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.objects.SwingClientExternalHandler;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Node;

public class Viewer {
    private Values commonValues = new Values();
    PdfDecoderInt decode_pdf;
    private SwingThumbnailPanel thumbnails;
    private PropertiesFile properties = new PropertiesFile();
    SwingGUI currentGUI;
    private SwingSearchWindow searchFrame;
    private Commands currentCommands;
    private boolean isSetup;
    public static boolean exitOnClose;
    public static boolean closeCalled;

    public Viewer() {
        String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
        if (prefFile != null) {
            this.properties.loadProperties(prefFile);
        } else {
            this.properties.loadProperties();
        }
        this.init();
        DecoderOptions.showErrorMessages = true;
    }

    public Viewer(Accessible rootContainer, String preferencesPath) {
        if (preferencesPath != null && !preferencesPath.isEmpty()) {
            try {
                this.properties.loadProperties(preferencesPath);
            }
            catch (Exception e2) {
                System.err.println("Specified Preferrences file not found at " + preferencesPath + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + e2);
                this.properties.loadProperties();
            }
        } else {
            this.properties.loadProperties();
        }
        this.init();
        DecoderOptions.showErrorMessages = true;
        this.setRootContainer(rootContainer);
    }

    public Viewer(String prefs) {
        try {
            this.properties.loadProperties(prefs);
        }
        catch (Exception e2) {
            System.err.println("Specified Preferrences file not found at " + prefs + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + e2);
            this.properties.loadProperties();
        }
        this.init();
        DecoderOptions.showErrorMessages = true;
    }

    private Viewer(boolean enableDebugMode) {
        if (enableDebugMode) {
            this.properties.loadDebugProperties();
        } else {
            String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
            if (prefFile != null) {
                this.properties.loadProperties(prefFile);
            } else {
                this.properties.loadProperties();
            }
        }
        this.init();
        this.currentGUI.setDebugMode(enableDebugMode);
        DecoderOptions.showErrorMessages = true;
    }

    private void init() {
        String lafOption = System.getProperty("org.jpedal.userControlledLAF");
        String altLafOption = System.getProperty("org.jpedal.userControledLAF");
        if (altLafOption != null && !altLafOption.isEmpty()) {
            lafOption = altLafOption;
        }
        if (lafOption != null && !lafOption.isEmpty()) {
            if (!"true".equalsIgnoreCase(lafOption)) {
                if ("false".equalsIgnoreCase(lafOption)) {
                    Viewer.setLookAndFeel();
                } else {
                    try {
                        UIManager.setLookAndFeel(lafOption);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                        this.currentGUI.showMessageDialog("Exception " + ex + " could not be found. LookAndFeel not set.");
                    }
                }
            }
        } else {
            String laf = this.properties.getValue("viewerLookAndFeel");
            if (!laf.isEmpty()) {
                if ("SystemDefault".equals(laf) || !Arrays.toString(UIManager.getInstalledLookAndFeels()).contains(laf)) {
                    Viewer.setLookAndFeel();
                } else {
                    try {
                        UIManager.setLookAndFeel(laf);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                        LogWriter.writeLog("Exception " + ex + " setting look and feel to viewerLookAndFeel value");
                    }
                }
            }
        }
        if (System.getProperty("org.jpedal.viewerLargeImageCaching") == null) {
            System.setProperty("org.jpedal.viewerLargeImageCaching", "true");
        }
        this.decode_pdf = new PdfDecoder(true);
        this.thumbnails = new SwingThumbnailPanel(this.decode_pdf);
        this.currentGUI = new SwingGUI(this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
        this.decode_pdf.addExternalHandler(new DefaultActionHandler(this.currentGUI), 5);
        this.decode_pdf.addExternalHandler(new SwingClientExternalHandler(), 39);
        this.searchFrame = new SwingSearchWindow(this.currentGUI);
        this.currentCommands = new Commands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame);
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            LogWriter.writeLog("Exception " + e2 + " setting look and feel");
        }
    }

    public SearchList getSearchResults() {
        return this.currentCommands.getSearchList();
    }

    public static void main(String[] args) {
        Viewer current = new Viewer();
        current.setupViewer();
        current.handleArguments(args);
    }

    public static void debug(String[] args) {
        Viewer current = new Viewer(true);
        current.setupViewer();
        current.handleArguments(args);
    }

    public SwingGUI getSwingGUI() {
        return this.currentGUI;
    }

    public void openDefaultFile(String defaultFile) {
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (defaultFile != null) {
            File testExists = new File(defaultFile);
            boolean isURL = false;
            if (defaultFile.startsWith("http:") || defaultFile.startsWith("jar:") || defaultFile.startsWith("file:")) {
                LogWriter.writeLog("Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setFileSize(testExists.length() >> 10);
                this.commonValues.setSelectedFile(defaultFile);
                this.currentGUI.setViewerTitle();
                String page = System.getProperty("org.jpedal.page");
                String bookmark = System.getProperty("org.jpedal.bookmark");
                if (page != null && !isURL) {
                    try {
                        int pageNum = Integer.parseInt(page);
                        if (pageNum < 1) {
                            pageNum = -1;
                            System.err.println(page + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(page + " must be 1 or larger. Opening on page 1");
                        }
                        if (pageNum != -1) {
                            this.openFile(testExists, pageNum);
                        }
                    }
                    catch (NumberFormatException e2) {
                        System.err.println(page + "is not a valid number for a page number. Opening on page 1 " + e2);
                        LogWriter.writeLog(page + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (bookmark != null) {
                    this.openFile(testExists, bookmark);
                } else {
                    this.currentGUI.openFile(defaultFile);
                }
            }
        }
    }

    private void openDefaultFileAtPage(String defaultFile, int page) {
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (defaultFile != null) {
            File testExists = new File(defaultFile);
            boolean isURL = false;
            if (defaultFile.startsWith("http:") || defaultFile.startsWith("jar:")) {
                LogWriter.writeLog("Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(defaultFile);
                this.commonValues.setFileSize(testExists.length() >> 10);
                this.currentGUI.setViewerTitle();
                this.openFile(testExists, page);
            }
        }
    }

    public PdfDecoderInt getPdfDecoder() {
        return this.decode_pdf;
    }

    public void setRootContainer(Object rootContainer) {
        this.currentGUI.setRootContainer(rootContainer);
    }

    public void loadProperties(String props) {
        this.properties.loadProperties(props);
    }

    public void setupViewer() {
        boolean showFirstTimePopup;
        ResourceBundle bundle;
        String searchType;
        String flag = System.getProperty("org.jpedal.suppressViewerPopups");
        boolean suppressViewerPopups = false;
        if ("true".equalsIgnoreCase(flag)) {
            suppressViewerPopups = true;
        }
        if ((searchType = this.properties.getValue("searchWindowType")) != null && !searchType.isEmpty()) {
            int type = Integer.parseInt(searchType);
            this.searchFrame.setViewStyle(type);
        } else {
            this.searchFrame.setViewStyle(2);
        }
        this.searchFrame.setUpdateListDuringSearch("true".equals(this.properties.getValue("updateResultsDuringSearch")));
        this.currentGUI.setSearchFrame(this.searchFrame);
        String setThumbnail = System.getProperty("org.jpedal.thumbnail");
        if (setThumbnail != null) {
            if ("true".equals(setThumbnail)) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if ("false".equals(setThumbnail)) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        String customBundle = System.getProperty("org.jpedal.bundleLocation");
        if (customBundle != null) {
            String fileName = customBundle.replaceAll("\\.", "/") + '_' + Locale.getDefault().getLanguage() + ".properties";
            URL resource = Messages.class.getResource(fileName);
            if (resource != null) {
                bundle = ResourceBundle.getBundle(customBundle);
            } else {
                Locale.setDefault(new Locale("en", "EN"));
                this.currentGUI.showMessageDialog("No locale file " + fileName + " has been defined for this Locale - using English as Default\n Format is path, using '.' as break ie org.jpedal.international.messages");
                bundle = null;
            }
        } else {
            bundle = null;
        }
        this.init(bundle);
        this.currentGUI.init(this.currentCommands);
        if (this.searchFrame.getViewStyle() == 1) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        String propValue = this.properties.getValue("showfirsttimepopup");
        boolean bl2 = showFirstTimePopup = !suppressViewerPopups && !propValue.isEmpty() && "true".equals(propValue);
        if (showFirstTimePopup) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        }
        propValue = this.properties.getValue("displaytipsonstartup");
        if (!suppressViewerPopups && !propValue.isEmpty() && "true".equals(propValue)) {
            this.currentCommands.executeCommand(ViewerCommands.TIP, null);
        }
        this.isSetup = true;
    }

    private void init(ResourceBundle bundle) {
        if (bundle == null) {
            try {
                Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
            }
            catch (Exception e2) {
                LogWriter.writeLog(e2);
                LogWriter.writeLog("Exception " + e2 + " loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            }
        } else {
            try {
                Messages.setBundle(bundle);
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception with bundle " + bundle);
                LogWriter.writeLog(ee);
            }
        }
        this.decode_pdf.addExternalHandler(this.currentGUI, 4);
        DecoderOptions.embedWidthData = true;
        this.decode_pdf.setExtractionMode(0, 1.0f);
        FontMappings.setFontReplacements();
    }

    void handleArguments(String[] args) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (args.length > 0) {
                this.openDefaultFile(args[0]);
            } else if ("true".equalsIgnoreCase(this.properties.getValue("openLastDocument")) && this.properties.getRecentDocuments() != null && this.properties.getRecentDocuments().length > 1) {
                int lastPageViewed = Integer.parseInt(this.properties.getValue("lastDocumentPage"));
                if (lastPageViewed < 0) {
                    lastPageViewed = 1;
                }
                this.openDefaultFileAtPage(this.properties.getRecentDocuments()[0], lastPageViewed);
            }
        } else {
            Runnable run = () -> {
                if (args.length > 0) {
                    this.openDefaultFile(args[0]);
                } else if ("true".equalsIgnoreCase(this.properties.getValue("openLastDocument")) && this.properties.getRecentDocuments() != null && this.properties.getRecentDocuments().length > 1) {
                    int lastPageViewed = Integer.parseInt(this.properties.getValue("lastDocumentPage"));
                    if (lastPageViewed < 0) {
                        lastPageViewed = 1;
                    }
                    this.openDefaultFileAtPage(this.properties.getRecentDocuments()[0], lastPageViewed);
                }
            };
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
    }

    private void openFile(File file, String bookmark) {
        try {
            boolean fileCanBeOpened = OpenFile.openUpFile(file.getCanonicalPath(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
            String bookmarkPage = null;
            int page = -1;
            if (this.decode_pdf.getOutlineAsXML() != null) {
                Node rootNode = this.decode_pdf.getOutlineAsXML().getFirstChild();
                if (rootNode != null) {
                    bookmarkPage = this.currentGUI.getBookmark(bookmark);
                }
                if (bookmarkPage != null) {
                    page = Integer.parseInt(bookmarkPage);
                }
            }
            if (bookmarkPage == null && (bookmarkPage = this.decode_pdf.getIO().convertNameToRef(bookmark)) != null) {
                OutlineObject namedDest = new OutlineObject(bookmarkPage);
                this.decode_pdf.getIO().readObject(namedDest);
                if (fileCanBeOpened) {
                    OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
                }
                this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(namedDest, 3, 339034948);
            }
            if (bookmarkPage == null) {
                throw new PdfException("Unknown bookmark " + bookmark);
            }
            if (page > -1) {
                this.commonValues.setCurrentPage(page);
                if (fileCanBeOpened) {
                    OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
                }
            }
        }
        catch (IOException | NumberFormatException | PdfException e2) {
            LogWriter.writeLog(e2);
            Values.setProcessing(false);
        }
    }

    private void openFile(File file, int page) {
        try {
            boolean fileCanBeOpened = OpenFile.openUpFile(file.getCanonicalPath(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
            this.commonValues.setCurrentPage(page);
            if (fileCanBeOpened) {
                OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
            }
        }
        catch (IOException | PdfException e2) {
            LogWriter.writeLog(e2);
            Values.setProcessing(false);
        }
    }

    @Deprecated
    public Object executeCommand(int commandID, Object[] args) {
        if (!this.isSetup) {
            throw new RuntimeException("You must call viewer.setupViewer(); before you call any commands");
        }
        ViewerCommands command = ViewerCommands.createFromID(commandID);
        if (command != null) {
            return this.currentCommands.executeCommand(command, args);
        }
        LogWriter.writeLog("Command for ID value " + commandID + " does not exist.");
        return null;
    }

    public Object executeCommand(ViewerCommands command, Object ... args) {
        if (!this.isSetup) {
            throw new RuntimeException("You must call viewer.setupViewer(); before you call any commands");
        }
        return this.currentCommands.executeCommand(command, args);
    }

    public Object getViewerValue(ViewerValues value) {
        if (!this.isSetup) {
            throw new RuntimeException("You must call viewer.setupViewer(); before query and values");
        }
        return this.currentCommands.getValue(value);
    }

    public Object getOutlinePanel() {
        return this.currentGUI.getOutlinePanel();
    }

    public SwingThumbnailPanel getThumbnailPanel() {
        return this.currentGUI.getThumbnailPanel();
    }

    public Object getPageGrouping(int pageNumber) {
        PdfGroupingAlgorithms grouping = null;
        if (pageNumber == this.decode_pdf.getlastPageDecoded()) {
            try {
                grouping = this.decode_pdf.getGroupingObject();
            }
            catch (PdfException e2) {
                LogWriter.writeLog(e2);
            }
        } else {
            try {
                this.decode_pdf.decodePageInBackground(pageNumber);
                grouping = this.decode_pdf.getBackgroundGroupingObject();
            }
            catch (Exception e3) {
                LogWriter.writeLog(e3);
            }
        }
        this.decode_pdf.waitForDecodingToFinish();
        return grouping;
    }

    public Object getPageCounter() {
        return this.currentGUI.getPageCounter(SwingGUI.PageCounter.PAGECOUNTER2);
    }

    public void addExternalHandler(Map<Integer, Object> newHandler, int type) {
        this.decode_pdf.addExternalHandler(newHandler, type);
    }

    public void dispose() {
        this.commonValues = null;
        if (this.thumbnails != null) {
            this.thumbnails.dispose();
        }
        this.thumbnails = null;
        if (this.properties != null) {
            this.properties.dispose();
        }
        this.properties = null;
        if (this.currentGUI != null) {
            this.currentGUI.dispose();
        }
        this.currentGUI = null;
        this.searchFrame = null;
        this.currentCommands = null;
        if (this.decode_pdf != null) {
            this.decode_pdf.dispose();
        }
        this.decode_pdf = null;
        Messages.dispose();
    }

    static {
        FlatDarkLaf.installLafInfo();
        FlatDarculaLaf.installLafInfo();
        FlatIntelliJLaf.installLafInfo();
        FlatLightLaf.installLafInfo();
        exitOnClose = true;
    }
}

