/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.ArrayDeque;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.SaveFile;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecentDocuments {
    private final int noOfRecentDocs;
    private final ArrayDeque<String> previousFiles = new ArrayDeque();
    private final ArrayDeque<String> nextFiles = new ArrayDeque();
    private final JMenuItem[] recentDocuments;

    public RecentDocuments(int noOfRecentDocs) {
        this.noOfRecentDocs = noOfRecentDocs;
        this.recentDocuments = new JMenuItem[noOfRecentDocs];
    }

    private static String getShortenedFileName(String fileNameToAdd) {
        int maxChars = 30;
        if (fileNameToAdd.length() <= 30) {
            return fileNameToAdd;
        }
        StringTokenizer st = new StringTokenizer(fileNameToAdd, "\\/");
        int noOfTokens = st.countTokens();
        if (noOfTokens == 1) {
            return fileNameToAdd.substring(0, 30);
        }
        String[] arrayedFile = new String[noOfTokens];
        for (int i2 = 0; i2 < noOfTokens; ++i2) {
            arrayedFile[i2] = st.nextToken();
        }
        String filePathBody = fileNameToAdd.substring(arrayedFile[0].length(), fileNameToAdd.length() - arrayedFile[noOfTokens - 1].length());
        StringBuilder sb = new StringBuilder(filePathBody);
        for (int i3 = noOfTokens - 2; i3 > 0; --i3) {
            int start = sb.lastIndexOf(arrayedFile[i3]);
            int end = start + arrayedFile[i3].length();
            sb.replace(start, end, "...");
            if (sb.length() <= 30) break;
        }
        return arrayedFile[0] + sb + arrayedFile[noOfTokens - 1];
    }

    public String getPreviousDocument() {
        String fileToOpen = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            fileToOpen = this.previousFiles.pop();
        }
        return fileToOpen;
    }

    public String getNextDocument() {
        String fileToOpen = null;
        if (!this.nextFiles.isEmpty()) {
            fileToOpen = this.nextFiles.pop();
        }
        return fileToOpen;
    }

    public void addToFileList(String selectedFile) {
        this.previousFiles.push(selectedFile);
    }

    public void enableRecentDocuments(boolean enable) {
        for (int i2 = 0; i2 < this.recentDocuments.length; ++i2) {
            if (this.recentDocuments[i2] == null || this.recentDocuments[i2].getText().equals(i2 + 1 + ": ")) continue;
            this.recentDocuments[i2].setVisible(enable);
            this.recentDocuments[i2].setEnabled(enable);
        }
    }

    public void updateRecentDocuments(String[] recentDocs) {
        if (recentDocs == null) {
            return;
        }
        for (int i2 = 0; i2 < recentDocs.length; ++i2) {
            if (recentDocs[i2] == null) continue;
            String shortenedFileName = RecentDocuments.getShortenedFileName(recentDocs[i2]);
            if (this.recentDocuments[i2] == null) {
                this.recentDocuments[i2] = new JMenuItem();
            }
            this.recentDocuments[i2].setText(i2 + 1 + ": " + shortenedFileName);
            this.recentDocuments[i2].setVisible(!this.recentDocuments[i2].getText().equals(i2 + 1 + ": "));
            this.recentDocuments[i2].setName(recentDocs[i2]);
        }
    }

    public void clearRecentDocuments(PropertiesFile properties) {
        NodeList nl = properties.getDoc().getElementsByTagName("recentfiles");
        if (nl != null && nl.getLength() > 0) {
            NodeList allRecentDocs = ((Element)nl.item(0)).getElementsByTagName("*");
            for (int i2 = 0; i2 < allRecentDocs.getLength(); ++i2) {
                Node item = allRecentDocs.item(i2);
                nl.item(0).removeChild(item);
            }
        }
        for (int i3 = 0; i3 < this.noOfRecentDocs; ++i3) {
            this.recentDocuments[i3].setText(i3 + 1 + ": ");
            this.recentDocuments[i3].setVisible(false);
        }
    }

    public void createMenuItems(String fileNameToAdd, int position, SwingGUI currentGUI, Values commonValues) {
        String shortenedFileName = RecentDocuments.getShortenedFileName(fileNameToAdd);
        this.recentDocuments[position] = new JMenuItem(position + 1 + ": " + shortenedFileName);
        if (this.recentDocuments[position].getText().equals(position + 1 + ": ")) {
            this.recentDocuments[position].setVisible(false);
        }
        this.recentDocuments[position].addActionListener(e2 -> {
            if (PrintStatus.isPrinting()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
            } else if (Values.isProcessing()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            } else {
                SaveFile.handleUnsaveForms(currentGUI, commonValues);
                JMenuItem item = (JMenuItem)e2.getSource();
                String fileName = item.getName();
                if (!fileName.isEmpty()) {
                    currentGUI.open(fileName);
                }
            }
        });
        this.recentDocuments[position].setName(fileNameToAdd);
        currentGUI.getMenuItems().addToMenu(this.recentDocuments[position], 317);
    }
}

