/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.MouseMode;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.ViewerValues;
import org.jpedal.examples.viewer.commands.AccelerationOff;
import org.jpedal.examples.viewer.commands.AccelerationOn;
import org.jpedal.examples.viewer.commands.AlwaysShowMouse;
import org.jpedal.examples.viewer.commands.AutoScroll;
import org.jpedal.examples.viewer.commands.BitMap;
import org.jpedal.examples.viewer.commands.Bookmark;
import org.jpedal.examples.viewer.commands.Buy;
import org.jpedal.examples.viewer.commands.ChangeLineArt;
import org.jpedal.examples.viewer.commands.Continuous;
import org.jpedal.examples.viewer.commands.ContinuousFacing;
import org.jpedal.examples.viewer.commands.Copy;
import org.jpedal.examples.viewer.commands.DeSelectAll;
import org.jpedal.examples.viewer.commands.DeletePropertiesOnExit;
import org.jpedal.examples.viewer.commands.DocInfo;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.commands.ExtractSelectionAsImage;
import org.jpedal.examples.viewer.commands.ExtractText;
import org.jpedal.examples.viewer.commands.Facing;
import org.jpedal.examples.viewer.commands.Find;
import org.jpedal.examples.viewer.commands.FullScreen;
import org.jpedal.examples.viewer.commands.Help;
import org.jpedal.examples.viewer.commands.Highlight;
import org.jpedal.examples.viewer.commands.Info;
import org.jpedal.examples.viewer.commands.MouseModeCommand;
import org.jpedal.examples.viewer.commands.NavigateDocuments;
import org.jpedal.examples.viewer.commands.NextResults;
import org.jpedal.examples.viewer.commands.Objects;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.commands.OpenInSystemDefault;
import org.jpedal.examples.viewer.commands.PageCount;
import org.jpedal.examples.viewer.commands.PageFlow;
import org.jpedal.examples.viewer.commands.PageGrouping;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.commands.PanMode;
import org.jpedal.examples.viewer.commands.Preferences;
import org.jpedal.examples.viewer.commands.PreviousResult;
import org.jpedal.examples.viewer.commands.Print;
import org.jpedal.examples.viewer.commands.ReplaceTextColor;
import org.jpedal.examples.viewer.commands.Reset;
import org.jpedal.examples.viewer.commands.Rotation;
import org.jpedal.examples.viewer.commands.RotationLeft;
import org.jpedal.examples.viewer.commands.RotationRight;
import org.jpedal.examples.viewer.commands.SaveFile;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.commands.Scaling;
import org.jpedal.examples.viewer.commands.Scroll;
import org.jpedal.examples.viewer.commands.SelectAll;
import org.jpedal.examples.viewer.commands.SeparateCover;
import org.jpedal.examples.viewer.commands.SetDisplayBackground;
import org.jpedal.examples.viewer.commands.SetEnhanceFractionalLines;
import org.jpedal.examples.viewer.commands.SetHideLineWeights;
import org.jpedal.examples.viewer.commands.SetHighlightFormFields;
import org.jpedal.examples.viewer.commands.SetPageColor;
import org.jpedal.examples.viewer.commands.SetReplacementThreshold;
import org.jpedal.examples.viewer.commands.SetTextColor;
import org.jpedal.examples.viewer.commands.SetUndrawnPageColor;
import org.jpedal.examples.viewer.commands.ShowFormNames;
import org.jpedal.examples.viewer.commands.Single;
import org.jpedal.examples.viewer.commands.Snapshot;
import org.jpedal.examples.viewer.commands.Text;
import org.jpedal.examples.viewer.commands.TextSelect;
import org.jpedal.examples.viewer.commands.Tip;
import org.jpedal.examples.viewer.commands.UpdateGUILayout;
import org.jpedal.examples.viewer.commands.ViewStack;
import org.jpedal.examples.viewer.commands.VisitWebsite;
import org.jpedal.examples.viewer.commands.Xref;
import org.jpedal.examples.viewer.commands.ZoomIn;
import org.jpedal.examples.viewer.commands.ZoomOut;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.SaveImage;
import org.jpedal.examples.viewer.gui.swing.SearchList;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.utils.Exporter;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.external.JPedalActionHandler;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Commands {
    protected final ViewStack viewStack = new ViewStack();
    public boolean extractingAsImage;
    private final Printer currentPrinter;
    public static final int ABOUT = 1;
    public static final int BITMAP = 2;
    public static final int IMAGES = 3;
    public static final int TEXT = 4;
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    public static final int EXIT = 7;
    public static final int AUTOSCROLL = 8;
    public static final int DOCINFO = 9;
    public static final int OPENFILE = 10;
    public static final int BOOKMARK = 11;
    public static final int FIND = 12;
    public static final int SNAPSHOT = 13;
    public static final int OPENURL = 14;
    public static final int VISITWEBSITE = 15;
    public static final int PREVIOUSDOCUMENT = 16;
    public static final int NEXTDOCUMENT = 17;
    public static final int PREVIOUSRESULT = 18;
    public static final int NEXTRESULT = 19;
    public static final int TIP = 20;
    public static final int PREFERENCES = 24;
    public static final int COPY = 25;
    public static final int SELECTALL = 26;
    public static final int DESELECTALL = 27;
    public static final int UPDATEGUILAYOUT = 28;
    public static final int MOUSEMODE = 29;
    public static final int PANMODE = 30;
    public static final int TEXTSELECT = 31;
    public static final int SEPARATECOVER = 32;
    public static final int EXTRACTTEXT = 33;
    public static final int EXTRACTASIMAGE = 34;
    public static final int ROTATELEFT = 35;
    public static final int ROTATERIGHT = 36;
    public static final int OPENINSYSTEMDEFAULT = 37;
    public static final int XREF = 38;
    public static final int OBJECTS = 39;
    public static final int FIRSTPAGE = 50;
    public static final int FBACKPAGE = 51;
    public static final int BACKPAGE = 52;
    public static final int FORWARDPAGE = 53;
    public static final int FFORWARDPAGE = 54;
    public static final int LASTPAGE = 55;
    public static final int GOTO = 56;
    public static final int SINGLE = 57;
    public static final int CONTINUOUS = 58;
    public static final int CONTINUOUS_FACING = 59;
    public static final int FACING = 60;
    public static final int PAGEFLOW = 61;
    public static final int FULLSCREEN = 62;
    public static final int ZOOMIN = 63;
    public static final int ZOOMOUT = 64;
    public static final int PORTFOLIO_DETAIL = 65;
    public static final int PORTFOLIO_TILES = 66;
    public static final int ROTATION = 251;
    public static final int SCALING = 252;
    public static final int CURRENTMENU = 300;
    public static final int CONTENTMENU = 304;
    public static final int PDFMENU = 306;
    public static final int EXPORTMENU = 307;
    public static final int WINDOWMENU = 308;
    public static final int PAGELAYOUTMENU = 309;
    public static final int EDITMENU = 310;
    public static final int GOTOMENU = 311;
    public static final int VIEWMENU = 312;
    public static final int OPENMENU = 316;
    public static final int FILEMENU = 317;
    public static final int HELPFORUM = 318;
    public static final int PORTFOLIOMENU = 319;
    public static final int SAVEFORM = 500;
    public static final int HIGHLIGHT = 600;
    public static final int SCROLL = 601;
    public static final int ADDVIEW = 700;
    public static final int FORWARD = 701;
    public static final int BACK = 702;
    public static final int PAGECOUNT = 703;
    public static final int CURRENTPAGE = 704;
    public static final int GETOUTLINEPANEL = 705;
    public static final int GETTHUMBNAILPANEL = 706;
    public static final int GETPAGECOUNTER = 707;
    public static final int PAGEGROUPING = 708;
    public static final int SETPAGECOLOR = 709;
    public static final int SETUNDRAWNPAGECOLOR = 710;
    public static final int REPLACETEXTCOLOR = 711;
    public static final int SETTEXTCOLOR = 712;
    public static final int CHANGELINEART = 713;
    public static final int SETDISPLAYBACKGROUND = 714;
    public static final int SETREPLACEMENTCOLORTHRESHOLD = 715;
    public static final int SETENHANCEFRACTIONALLINES = 717;
    public static final int SETHIDELINEWEIGHTS = 718;
    public static final int SETHIGHLIGHTFORMFIELDS = 719;
    public static final int HIDEVERSIONNUMBER = 720;
    public static final int SHOWVERSIONNUMBER = 721;
    public static final int HELP = 998;
    public static final int BUY = 999;
    public static final int RESET = 1002;
    public static final int ACCELERATIONON = 1003;
    public static final int ACCELERATIONOFF = 1004;
    public static final int SHOWFORMNAMES = 1006;
    public static final int DELETEPROPERTIESONEXIT = 1007;
    public static final int ALWAYSSHOWMOUSE = 1008;
    public static final Integer FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN = 1;
    public static final Integer SEARCH_RETURNED_TO_START = 2;
    public static final Integer SEARCH_NOT_FOUND = 3;
    protected final Values commonValues;
    protected final SwingGUI currentGUI;
    protected final PdfDecoderInt decode_pdf;
    protected final SwingThumbnailPanel thumbnails;
    protected final PropertiesFile properties;
    protected final SwingSearchWindow searchFrame;
    protected final MouseMode mouseMode = new MouseMode();

    public Commands(Values commonValues, SwingGUI currentGUI, PdfDecoderInt decode_pdf, SwingThumbnailPanel thumbnails, PropertiesFile properties, SwingSearchWindow searchFrame) {
        this.commonValues = commonValues;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.thumbnails = thumbnails;
        this.properties = properties;
        this.searchFrame = searchFrame;
        this.currentPrinter = new Printer();
    }

    @Deprecated
    public Object executeCommand(int ID2, Object[] args) {
        return this.commandExecutor(ID2, args);
    }

    private Object commandExecutor(int ID2, Object[] args) {
        JPedalActionHandler jpedalAction;
        Map jpedalActionHandlers;
        if (args != null && args.length == 1 && args[0] == null) {
            args = null;
        }
        if ((jpedalActionHandlers = (Map)this.decode_pdf.getExternalHandler(24)) != null && (jpedalAction = (JPedalActionHandler)jpedalActionHandlers.get(ID2)) != null) {
            jpedalAction.actionPerformed(this.currentGUI, this);
            return null;
        }
        Object status = null;
        if (ID2 < 50) {
            status = this.executeMenuBarCommands(ID2, args);
        } else if (ID2 < 251) {
            this.executeDisplayCommands(ID2, args);
        } else if (ID2 < 300) {
            this.executeComboCommands(ID2, args);
        } else if (ID2 < 600) {
            this.executeExternalCommands(ID2, args);
        } else if (ID2 < 700) {
            this.executePageCommands(ID2, args);
        } else if (ID2 < 997) {
            status = this.executeViewerFunctionalityCommands(ID2, args);
        } else if (ID2 < 1000) {
            this.executeDemoVersionCommands(ID2, args);
        } else {
            this.executeDebugCommands(ID2, args);
        }
        return status;
    }

    public Object executeCommand(ViewerCommands command, Object[] args) {
        return this.commandExecutor(command.commandID, args);
    }

    public Object getValue(ViewerValues value) {
        switch (value) {
            case PAGECOUNT: {
                return this.commandExecutor(703, null);
            }
            case PDFNAME: {
                return this.commonValues.getSelectedFile();
            }
            case CURRENTPAGE: {
                return this.commandExecutor(704, null);
            }
            case SCALE: {
                return Float.valueOf(this.decode_pdf.getScaling());
            }
            case PAGELAYOUT: {
                return this.decode_pdf.getDisplayView();
            }
            case ROTATION: {
                return this.decode_pdf.getDisplayRotation();
            }
        }
        return null;
    }

    public void handleTransferedFile(String file) {
        SaveFile.handleUnsaveForms(this.currentGUI, this.commonValues);
        while (Values.getOpeningTransferedFile() || Values.isProcessing()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e2) {
                LogWriter.writeLog(e2);
            }
        }
        Values.setOpeningTransferedFile(true);
        boolean isURL = file.startsWith("http:") || file.startsWith("file:");
        try {
            if (!isURL) {
                this.commonValues.setFileIsURL(false);
                this.commonValues.setFileSize(new File(file).length() >> 10);
            } else {
                this.commonValues.setFileIsURL(true);
            }
            this.commonValues.setSelectedFile(file);
            this.currentGUI.setViewerTitle();
        }
        catch (Exception e3) {
            LogWriter.writeLog("Exception " + e3 + " getting paths");
        }
        Path testFile = isURL ? Paths.get(URI.create(this.commonValues.getSelectedFile())) : Paths.get(this.commonValues.getSelectedFile(), new String[0]);
        if (!isURL && Files.notExists(testFile, new LinkOption[0])) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + this.commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null && !Values.isProcessing()) {
            this.openTransferedFile();
            if (this.commonValues.isPDF()) {
                Values.setOpeningTransferedFile(false);
            }
        }
    }

    public void recentDocumentsOption() {
        this.currentGUI.setRecentDocument();
        String[] recentDocs = this.properties.getRecentDocuments();
        if (recentDocs == null) {
            return;
        }
        for (int i2 = 0; i2 < PropertiesFile.getNoRecentDocumentsToDisplay(); ++i2) {
            if (recentDocs[i2] == null) {
                recentDocs[i2] = "";
            }
            try {
                String fileNameToAdd = recentDocs[i2];
                this.currentGUI.getRecentDocument().createMenuItems(fileNameToAdd, i2, this.currentGUI, this.commonValues);
                continue;
            }
            catch (Exception ee) {
                LogWriter.writeLog(ee);
            }
        }
    }

    public SearchList getSearchList() {
        return this.searchFrame.getResults();
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public static boolean isPDFLinearized(String pdfUrl) {
        if (pdfUrl.startsWith("jar")) {
            return false;
        }
        boolean isLinear = false;
        try (InputStream is = new URL(pdfUrl).openStream();){
            byte[] buffer = new byte[128];
            is.read(buffer);
            is.close();
            int len = buffer.length;
            for (int i2 = 0; i2 < len; ++i2) {
                if (buffer[i2] != 47 || buffer[i2 + 1] != 76 || buffer[i2 + 2] != 105 || buffer[i2 + 3] != 110 || buffer[i2 + 4] != 101 || buffer[i2 + 5] != 97 || buffer[i2 + 6] != 114) continue;
                isLinear = true;
                i2 = len;
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog("[PDF] Exception " + e2 + " scanning URL " + pdfUrl);
        }
        return isLinear;
    }

    protected void openTransferedFile() {
        this.decode_pdf.flushObjectValues(true);
        OpenFile.openFile(this.commonValues.getSelectedFile(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
    }

    private Object executeMenuBarCommands(int ID2, Object[] args) {
        Object status = null;
        switch (ID2) {
            case 1: {
                Info.execute(args, this.currentGUI);
                break;
            }
            case 2: {
                BitMap.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 3: {
                Commands.saveImage(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 4: {
                Text.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 5: {
                SaveFile.execute(args, this.currentGUI, this.commonValues);
                break;
            }
            case 6: {
                Print.execute(args, this.currentGUI, this.commonValues, this.properties, this.currentPrinter, this.decode_pdf);
                break;
            }
            case 7: {
                Exit.execute(args, this.thumbnails, this.currentGUI, this.commonValues, this.decode_pdf, this.properties);
                break;
            }
            case 8: {
                AutoScroll.execute(args, this.currentGUI);
                break;
            }
            case 9: {
                DocInfo.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 10: {
                OpenFile.executeOpenFile(args, this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
                break;
            }
            case 11: {
                Bookmark.execute(args, this.currentGUI);
                break;
            }
            case 12: {
                Find.execute(args, this.commonValues, this.currentGUI, this.decode_pdf, this.searchFrame);
                break;
            }
            case 13: {
                status = Snapshot.execute(args, this.currentGUI, this.decode_pdf, this.extractingAsImage);
                this.extractingAsImage = (Boolean)status;
                break;
            }
            case 14: {
                OpenFile.executeOpenURL(args, this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
                break;
            }
            case 15: {
                VisitWebsite.execute(args, this.currentGUI);
                break;
            }
            case 16: {
                NavigateDocuments.executePrevDoc(args, this.currentGUI);
                break;
            }
            case 17: {
                NavigateDocuments.executeNextDoc(args, this.currentGUI);
                break;
            }
            case 18: {
                status = PreviousResult.execute(args, this.commonValues, this.currentGUI, this.decode_pdf, this.searchFrame);
                break;
            }
            case 19: {
                status = NextResults.execute(args, this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf);
                break;
            }
            case 20: {
                Tip.execute(args, this.currentGUI, this.properties);
                break;
            }
            case 24: {
                Preferences.execute(args, this.currentGUI);
                break;
            }
            case 25: {
                Copy.execute(this.currentGUI, this.decode_pdf, this.commonValues);
                break;
            }
            case 26: {
                SelectAll.execute(this.currentGUI, this.decode_pdf, this.commonValues);
                break;
            }
            case 27: {
                DeSelectAll.execute(this.currentGUI, this.decode_pdf);
                break;
            }
            case 28: {
                UpdateGUILayout.execute(args, this.currentGUI);
                break;
            }
            case 29: {
                MouseModeCommand.execute(args, this.currentGUI, this.mouseMode, this.decode_pdf);
                break;
            }
            case 30: {
                PanMode.execute(args, this.currentGUI, this.mouseMode, this.decode_pdf);
                break;
            }
            case 31: {
                TextSelect.execute(args, this.currentGUI, this.mouseMode);
                break;
            }
            case 32: {
                SeparateCover.execute(args, this.decode_pdf, this.properties, this.currentGUI, this.commonValues);
                break;
            }
            case 33: {
                ExtractText.execute(args, this.currentGUI, this.decode_pdf, this.commonValues);
                break;
            }
            case 34: {
                ExtractSelectionAsImage.execute(this.commonValues, this.currentGUI, this.decode_pdf);
                break;
            }
            case 35: {
                RotationLeft.execute(this.currentGUI, this.commonValues);
                break;
            }
            case 36: {
                RotationRight.execute(this.currentGUI, this.commonValues);
                break;
            }
            case 37: {
                OpenInSystemDefault.execute(args, this.currentGUI, this.commonValues);
                break;
            }
            case 38: {
                Xref.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 39: {
                Objects.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
            }
        }
        return status;
    }

    private void executeDisplayCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 50: {
                PageNavigator.goFirstPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 51: {
                PageNavigator.goFBackPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 52: {
                PageNavigator.goBackPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 53: {
                PageNavigator.goForwardPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 54: {
                PageNavigator.goFForwardPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 55: {
                PageNavigator.goLastPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 56: {
                PageNavigator.goPage(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 57: {
                Single.execute(args, this.decode_pdf, this.currentGUI);
                TextSelect.execute(args, this.currentGUI, this.mouseMode);
                break;
            }
            case 58: {
                Continuous.execute(this.decode_pdf, this.currentGUI, args);
                PanMode.execute(args, this.currentGUI, this.mouseMode, this.decode_pdf);
                break;
            }
            case 59: {
                ContinuousFacing.execute(args, this.decode_pdf, this.currentGUI, this.commonValues);
                PanMode.execute(args, this.currentGUI, this.mouseMode, this.decode_pdf);
                break;
            }
            case 60: {
                Facing.execute(args, this.decode_pdf, this.currentGUI, this.commonValues);
                PanMode.execute(args, this.currentGUI, this.mouseMode, this.decode_pdf);
                break;
            }
            case 61: {
                PageFlow.execute(args, this.currentGUI, this.commonValues, this.decode_pdf, this.properties, this.searchFrame);
                break;
            }
            case 62: {
                FullScreen.execute(args, this.currentGUI, this.thumbnails, this.commonValues, this.decode_pdf, this.properties);
                break;
            }
            case 63: {
                ZoomIn.execute(args, this.currentGUI, this.decode_pdf);
                break;
            }
            case 64: {
                ZoomOut.execute(args, this.currentGUI, this.decode_pdf);
                break;
            }
            case 65: {
                this.currentGUI.setDisplayView(6, 2);
                break;
            }
            case 66: {
                this.currentGUI.setDisplayView(7, 2);
            }
        }
    }

    private void executeDemoVersionCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 998: {
                Help.execute(args);
                break;
            }
            case 999: {
                Buy.execute(args, this.currentGUI);
            }
        }
    }

    private void executeComboCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 252: {
                Scaling.execute(args, this.commonValues, this.decode_pdf, this.currentGUI, this.viewStack);
                break;
            }
            case 251: {
                Rotation.execute(args, this.currentGUI, this.commonValues);
            }
        }
    }

    private void executeExternalCommands(int ID2, Object[] args) {
        if (ID2 == 500) {
            SaveForm.execute(args, this.currentGUI, this.decode_pdf, this.commonValues);
        }
    }

    private void executePageCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 600: {
                Highlight.execute(args, this.decode_pdf);
                break;
            }
            case 601: {
                Scroll.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
            }
        }
    }

    private Object executeViewerFunctionalityCommands(int ID2, Object[] args) {
        Object status = null;
        switch (ID2) {
            case 700: {
                this.viewStack.add((Integer)args[0], (Rectangle)args[1], (Integer)args[2]);
                break;
            }
            case 701: {
                if (this.viewStack.forward() == null) break;
                this.decode_pdf.getFormRenderer().getActionHandler().changeTo(null, this.viewStack.forward().getPage(), this.viewStack.forward().getLocation(), this.viewStack.forward().getType(), false);
                break;
            }
            case 702: {
                if (this.viewStack.back() == null) break;
                this.decode_pdf.getFormRenderer().getActionHandler().changeTo(null, this.viewStack.back().getPage(), this.viewStack.back().getLocation(), this.viewStack.back().getType(), false);
                break;
            }
            case 703: {
                status = PageCount.execute(this.decode_pdf);
                break;
            }
            case 704: {
                status = this.currentGUI.getValues().getCurrentPage();
                break;
            }
            case 705: {
                this.currentGUI.setBookmarks(true);
                status = this.currentGUI.getOutlinePanel();
                break;
            }
            case 706: {
                this.currentGUI.setBookmarks(true);
                status = this.currentGUI.getThumbnailPanel();
                break;
            }
            case 707: {
                status = this.currentGUI.getPageCounter(SwingGUI.PageCounter.PAGECOUNTER2);
                break;
            }
            case 708: {
                status = PageGrouping.execute(args, this.decode_pdf);
                break;
            }
            case 709: {
                SetPageColor.execute(args, this.decode_pdf);
                break;
            }
            case 710: {
                SetUndrawnPageColor.execute(args, this.decode_pdf);
                break;
            }
            case 711: {
                ReplaceTextColor.execute(args, this.decode_pdf);
                break;
            }
            case 712: {
                SetTextColor.execute(args, this.decode_pdf);
                break;
            }
            case 713: {
                ChangeLineArt.execute(args, this.decode_pdf);
                break;
            }
            case 714: {
                SetDisplayBackground.execute(args, this.decode_pdf);
                break;
            }
            case 715: {
                SetReplacementThreshold.execute(args, this.decode_pdf);
                break;
            }
            case 717: {
                SetEnhanceFractionalLines.execute(args, this.decode_pdf);
                break;
            }
            case 718: {
                SetHideLineWeights.execute(args, this.decode_pdf);
                break;
            }
            case 719: {
                SetHighlightFormFields.execute(args, this.decode_pdf);
                break;
            }
            case 720: {
                this.currentGUI.hideVersionNumber();
                break;
            }
            case 721: {
                this.currentGUI.showVersionNumber();
            }
        }
        return status;
    }

    private void executeDebugCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 1002: {
                Reset.execute(args, this.commonValues);
                break;
            }
            case 1003: {
                AccelerationOn.execute(args, this.decode_pdf);
                break;
            }
            case 1004: {
                AccelerationOff.execute(args, this.decode_pdf);
                break;
            }
            case 1006: {
                ShowFormNames.execute(args, this.decode_pdf);
                break;
            }
            case 1007: {
                DeletePropertiesOnExit.execute(args);
                break;
            }
            case 1008: {
                AlwaysShowMouse.execute(args);
            }
        }
    }

    private static void saveImage(Object[] args, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            if (commonValues.getSelectedFile() == null) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
            } else if (!decode_pdf.isExtractionAllowed()) {
                if (commonValues.isPDF()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPermissionsError.Extraction"));
                }
            } else {
                SaveImage current_selection = new SaveImage(commonValues.getInputDir(), commonValues.getPageCount(), commonValues.getCurrentPage());
                int userChoice = current_selection.display(currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SaveImagesFromPageRange"));
                if (commonValues.getFileIsURL()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                } else if (userChoice == 0) {
                    Exporter exporter = new Exporter(currentGUI, commonValues.getSelectedFile(), decode_pdf);
                    exporter.extractImagesOnPages(current_selection);
                }
            }
        }
    }
}

