/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text.output;

import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.text.output.StructuredTextWriter;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.Document;

public class HTMLStructuredTextWriter
implements StructuredTextWriter {
    private final String separator;

    public HTMLStructuredTextWriter(String separator) {
        this.separator = separator;
    }

    @Override
    public void write(Document tree, String file_name, String output_dir) throws PdfException {
        TransformerFactory transformerFactory = SecureTransformerFactory.newInstance();
        try (InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/text/htmlstyle.xslt");){
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
            if (!tree.hasChildNodes() || !tree.getDocumentElement().hasChildNodes()) {
                tree.appendChild(tree.createComment("There is no structured text in the file to extract!"));
                tree.appendChild(tree.createComment("JPedal can only extract it if it has been added when PDF created"));
                tree.appendChild(tree.createComment("Please read our blog post at https://support.idrsolutions.com/jpedal/faqs/content_extraction/does-this-pdf-document-contain-structured-text-content"));
            }
            String outputFile = StructuredTextWriter.getOuputFile(file_name, output_dir, this.separator, "html");
            transformer.transform(new DOMSource(tree), new StreamResult(outputFile));
        }
        catch (Error | Exception e2) {
            throw new PdfException(e2.getMessage(), e2);
        }
    }
}

