/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class FindTextInRectangle
extends BaseTextExtraction {
    private final ArrayList<float[]> co_ords = new ArrayList();
    private String textToFind;

    public FindTextInRectangle(String fileName) {
        super(fileName);
        this.init();
    }

    public FindTextInRectangle(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        this.fileName = file_name;
        if (this.openPDFFile()) {
            boolean start = true;
            int end = this.getPageCount();
            try {
                for (int currentPage = 1; currentPage <= end; ++currentPage) {
                    this.selectPage(currentPage);
                    if (this.currentGrouping == null) continue;
                    float[] co_ords = this.findTextOnPage(currentPage, this.textToFind, 8);
                    this.co_ords.add(co_ords);
                }
                this.decode_pdf.flushObjectValues(false);
            }
            catch (Exception e2) {
                LogWriter.writeLog(e2);
                System.exit(1);
            }
        }
    }

    public float[] findTextOnPage(int page, String textToFind, int searchType) throws PdfException {
        this.checkFileOpened();
        this.selectPage(page);
        return this.currentGrouping.findText(new String[]{textToFind}, searchType);
    }

    public float[] findTextOnPage(int page, int x1, int y1, int x2, int y2, String textToFind, int searchType) throws PdfException {
        this.checkFileOpened();
        this.selectPage(page);
        return this.currentGrouping.findText(x1, y1, x2, y2, new String[]{textToFind}, searchType);
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.FIND_TEXT_IN_RECTANGLE;
        super.init();
    }

    public static List<float[]> findTextOnAllPages(String inputDir, String textToFind) throws PdfException {
        FindTextInRectangle extract = new FindTextInRectangle(inputDir);
        extract.setup(textToFind);
        extract.processFiles(inputDir);
        extract.closePDFfile();
        return Collections.unmodifiableList(extract.co_ords);
    }

    private void setup(String textToFind) {
        this.textToFind = textToFind;
    }
}

