/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.examples.text.configuration.ExtractStructuredTextProperties;
import org.jpedal.examples.text.configuration.OutputModes;
import org.jpedal.examples.text.output.HTMLStructuredTextWriter;
import org.jpedal.examples.text.output.XMLStructuredTextWriter;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class ExtractStructuredText
extends BaseTextExtraction {
    ExtractStructuredTextProperties properties = new ExtractStructuredTextProperties();

    public ExtractStructuredText(String fileName) {
        super(fileName);
        this.init();
    }

    public ExtractStructuredText(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    public ExtractStructuredText(String fileName, ExtractStructuredTextProperties properties) {
        super(fileName);
        if (properties != null) {
            this.properties = properties;
        }
        this.init();
    }

    public ExtractStructuredText(byte[] byteArray, ExtractStructuredTextProperties properties) {
        super(byteArray);
        if (properties != null) {
            this.properties = properties;
        }
        this.init();
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        Document tree;
        this.fileName = file_name;
        if (this.openPDFFile() && (tree = this.getStructuredTextContent()) != null) {
            OutputModes x2 = this.properties.getFileOutputMode();
            switch (x2) {
                case XML: {
                    XMLStructuredTextWriter XMLwriter = new XMLStructuredTextWriter(separator);
                    XMLwriter.write(tree, file_name, this.output_dir);
                    break;
                }
                case HTML: {
                    HTMLStructuredTextWriter HTMLwriter = new HTMLStructuredTextWriter(separator);
                    HTMLwriter.write(tree, file_name, this.output_dir);
                    break;
                }
            }
        }
    }

    public static void main(String[] args) {
        int len = args.length;
        switch (len) {
            case 0: 
            case 1: {
                System.out.println("Example takes 2 parameters");
                System.out.println("Value 1 is the file name or directory of PDF files to process");
                System.out.println("Value 2 is Directory for writing the data as text files");
                System.out.println("(Optional) Value 3 is the output format, defaults to xml if not present");
                System.exit(0);
            }
            case 2: {
                try {
                    ExtractStructuredText.writeAllStructuredTextOutlinesToDir(args[0], args[1]);
                }
                catch (PdfException e2) {
                    LogWriter.writeLog(e2);
                }
                break;
            }
            case 3: {
                try {
                    String outputFormat = args[2];
                    ExtractStructuredTextProperties properties = new ExtractStructuredTextProperties();
                    switch (outputFormat.toLowerCase()) {
                        case "html": {
                            properties.setFileOutputMode(OutputModes.HTML);
                            break;
                        }
                        case "xml": {
                            properties.setFileOutputMode(OutputModes.XML);
                            break;
                        }
                        default: {
                            OutputModes[] modes;
                            StringBuilder message = new StringBuilder();
                            message.append("Output format of \"").append(outputFormat).append(" is not recognised.\n");
                            message.append("Valid values are as follows,");
                            for (OutputModes mode : modes = OutputModes.values()) {
                                message.append((Object)mode);
                            }
                            throw new IllegalArgumentException(message.toString());
                        }
                    }
                    ExtractStructuredText.writeAllStructuredTextOutlinesToDir(args[0], "", args[1], null, properties);
                }
                catch (PdfException e3) {
                    LogWriter.writeLog(e3);
                }
                break;
            }
            default: {
                System.out.println("too many arguments entered - run with no values to see defaults");
                StringBuilder arguments = new StringBuilder();
                for (String arg : args) {
                    arguments.append(arg).append('\n');
                }
                System.out.println("you entered:\n" + arguments + "as the arguments");
                System.exit(0);
            }
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.STRUCTURED_TEXT;
        super.init();
    }

    public static void writeAllStructuredTextOutlinesToDir(String inputDir, String password, String outputDir) throws PdfException {
        ExtractStructuredText.writeAllStructuredTextOutlinesToDir(inputDir, password, outputDir, null, null);
    }

    public static void writeAllStructuredTextOutlinesToDir(String inputDir, String password, String outputDir, ErrorTracker errorTracker) throws PdfException {
        ExtractStructuredText.writeAllStructuredTextOutlinesToDir(inputDir, password, outputDir, errorTracker, null);
    }

    public static void writeAllStructuredTextOutlinesToDir(String inputDir, String password, String outputDir, ErrorTracker errorTracker, ExtractStructuredTextProperties properties) throws PdfException {
        ExtractStructuredText extract = properties == null ? new ExtractStructuredText(inputDir) : new ExtractStructuredText(inputDir, properties);
        if (password != null) {
            extract.setPassword(password);
        }
        if (errorTracker != null) {
            extract.decode_pdf.addExternalHandler(extract, 31);
        }
        extract.setup(outputDir);
        extract.processFiles(inputDir);
        extract.closePDFfile();
    }

    public static void writeAllStructuredTextOutlinesToDir(String inputDir, String outputDir) throws PdfException {
        ExtractStructuredText.writeAllStructuredTextOutlinesToDir(inputDir, null, outputDir, null, null);
    }

    private void setup(String outputDir) {
        if (!outputDir.endsWith(separator)) {
            outputDir = outputDir + separator;
        }
        this.output_dir = outputDir;
    }

    public Document getStructuredTextContent() {
        return this.decode_pdf.getMarkedContent();
    }
}

