/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.splash;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.jpedal.examples.splash.JPedalSplash;
import org.jpedal.examples.viewer.utils.FileFilterer;

public class SplashToolBuilder {
    private final JPedalSplash splash;
    private String titleText = "";
    private String inputTitleText = "Input File / Directory";
    private FileFilterer inputFilter;
    private int inputType = 2;
    private boolean enableOutput;
    private String outputTitleText = "Output Directory";
    private boolean enableSelection;
    private String comboTitleText = "";
    private List<String> comboItems = new ArrayList<String>();
    private boolean fullSizeCombo;
    private String buttonText = "Convert";
    private ButtonCallback buttonCallback;
    private ButtonCallbackComponents buttonCallbackComponents;

    public SplashToolBuilder(JPedalSplash splash) {
        this.splash = splash;
    }

    public SplashToolBuilder setTitleText(String titleText) {
        this.titleText = titleText;
        return this;
    }

    public SplashToolBuilder setInputTitleText(String inputTitleText) {
        this.inputTitleText = inputTitleText;
        return this;
    }

    public SplashToolBuilder setInputFilter(FileFilterer inputFilter) {
        this.inputFilter = inputFilter;
        return this;
    }

    public SplashToolBuilder setInputType(int inputType) {
        this.inputType = inputType;
        return this;
    }

    public SplashToolBuilder setEnableOutput(boolean enableOutput) {
        this.enableOutput = enableOutput;
        return this;
    }

    public SplashToolBuilder setOutputTitleText(String outputTitleText) {
        this.enableOutput = true;
        this.outputTitleText = outputTitleText;
        return this;
    }

    public SplashToolBuilder setEnableSelection(boolean enableSelection) {
        this.enableSelection = enableSelection;
        return this;
    }

    public SplashToolBuilder setComboTitleText(String comboTitleText) {
        this.enableSelection = true;
        this.comboTitleText = comboTitleText;
        return this;
    }

    public SplashToolBuilder setComboItems(List<String> comboItems) {
        this.enableSelection = true;
        this.comboItems = new ArrayList<String>(comboItems);
        return this;
    }

    public SplashToolBuilder addComboItem(String comboItem) {
        this.enableSelection = true;
        this.comboItems.add(comboItem);
        return this;
    }

    public SplashToolBuilder setFullSizeCombo(boolean fullSizeCombo) {
        this.enableSelection = true;
        this.fullSizeCombo = fullSizeCombo;
        return this;
    }

    public SplashToolBuilder setButtonText(String buttonText) {
        this.buttonText = buttonText;
        return this;
    }

    public SplashToolBuilder setButtonCallback(ButtonCallback buttonCallback) {
        this.buttonCallback = buttonCallback;
        return this;
    }

    public SplashToolBuilder setButtonCallback(ButtonCallbackComponents buttonCallbackComponents) {
        this.buttonCallbackComponents = buttonCallbackComponents;
        return this;
    }

    public JPanel build() {
        JComboBox<String> comboBox;
        JLabel comboTitle;
        JButton outputFileSelector;
        JTextField outputFile;
        JLabel outputTitle;
        JPanel basePanel = new JPanel();
        basePanel.setSize(JPedalSplash.PANEL_SIZE);
        JLabel frameTitle = new JLabel(this.titleText);
        JLabel inputTitle = new JLabel(this.inputTitleText);
        JTextField inputFile = new JTextField();
        JButton inputFileSelector = new JButton("Browse...");
        JButton button = new JButton(this.buttonText);
        JButton backButton = new JButton("Back");
        JFileChooser fileChooser = new JFileChooser();
        basePanel.setLayout(new GridBagLayout());
        frameTitle.setFont(frameTitle.getFont().deriveFont(16.0f).deriveFont(1));
        inputFile.setBorder(new LineBorder(Color.BLACK, 1));
        inputFile.setEditable(false);
        if (this.enableOutput) {
            outputTitle = new JLabel(this.outputTitleText);
            outputFile = new JTextField();
            outputFile.setBorder(new LineBorder(Color.BLACK, 1));
            outputFile.setEditable(false);
            outputFileSelector = new JButton("Browse...");
            outputFileSelector.addActionListener(e2 -> {
                fileChooser.cancelSelection();
                fileChooser.setFileSelectionMode(1);
                fileChooser.setFileFilter(null);
                int result = fileChooser.showSaveDialog(basePanel);
                basePanel.setEnabled(false);
                if (result == 0) {
                    outputFile.setText(fileChooser.getSelectedFile().getAbsolutePath());
                    String input = inputFile.getText();
                    if (input != null && !input.isEmpty()) {
                        button.setEnabled(true);
                    }
                } else {
                    outputFile.setText(null);
                }
            });
        } else {
            outputTitle = null;
            outputFile = null;
            outputFileSelector = null;
        }
        inputFileSelector.addActionListener(e2 -> {
            fileChooser.cancelSelection();
            fileChooser.setFileSelectionMode(this.inputType);
            fileChooser.setFileFilter(this.inputFilter);
            int result = fileChooser.showOpenDialog(basePanel);
            button.setEnabled(false);
            if (result == 0) {
                inputFile.setText(fileChooser.getSelectedFile().getAbsolutePath());
                if (!this.enableOutput || outputFile.getText() != null && !outputFile.getText().isEmpty()) {
                    button.setEnabled(true);
                }
            } else {
                inputFile.setText(null);
            }
        });
        if (this.enableSelection) {
            assert (this.comboTitleText != null);
            assert (this.comboItems != null && !this.comboItems.isEmpty());
            comboTitle = new JLabel(this.comboTitleText);
            comboTitle.setHorizontalAlignment(this.fullSizeCombo ? 2 : 4);
            comboBox = new JComboBox<String>();
            this.comboItems.forEach(comboBox::addItem);
            comboBox.setSelectedIndex(0);
        } else {
            comboTitle = null;
            comboBox = null;
        }
        button.setEnabled(false);
        if (this.buttonCallback != null) {
            button.addActionListener(e2 -> this.buttonCallback.apply(inputFile.getText(), this.enableOutput ? outputFile.getText() : null, (String)(this.enableSelection ? comboBox.getSelectedItem() : null)));
        } else if (this.buttonCallbackComponents != null) {
            button.addActionListener(e2 -> this.buttonCallbackComponents.apply(basePanel, inputFile, outputFile, comboBox));
        }
        backButton.addActionListener(e2 -> this.splash.setupHome());
        this.buildPanel(basePanel, frameTitle, inputTitle, inputFile, inputFileSelector, outputTitle, outputFile, outputFileSelector, comboTitle, comboBox, backButton, button);
        return basePanel;
    }

    private void buildPanel(JPanel basePanel, JLabel frameTitle, JLabel inputTitle, JTextField inputFile, JButton inputFileSelector, JLabel outputTitle, JTextField outputFile, JButton outputFileSelector, JLabel comboTitle, JComboBox<String> comboBox, JButton backButton, JButton button) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        basePanel.add((Component)frameTitle, constraints);
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        ++constraints.gridy;
        basePanel.add((Component)inputTitle, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        basePanel.add((Component)inputFile, constraints);
        constraints.gridx = 3;
        constraints.gridwidth = 1;
        basePanel.add((Component)inputFileSelector, constraints);
        if (this.enableOutput) {
            constraints.gridx = 0;
            ++constraints.gridy;
            basePanel.add((Component)outputTitle, constraints);
            ++constraints.gridy;
            constraints.gridwidth = 3;
            basePanel.add((Component)outputFile, constraints);
            constraints.gridx = 3;
            constraints.gridwidth = 1;
            basePanel.add((Component)outputFileSelector, constraints);
        }
        if (this.enableSelection) {
            if (this.fullSizeCombo) {
                constraints.gridx = 0;
                constraints.gridwidth = 1;
                ++constraints.gridy;
                basePanel.add((Component)comboTitle, constraints);
                constraints.weightx = 1.0;
                constraints.gridwidth = 3;
                ++constraints.gridy;
            } else {
                constraints.gridx = 2;
                ++constraints.gridy;
                basePanel.add((Component)comboTitle, constraints);
                constraints.gridx = 3;
            }
            basePanel.add(comboBox, constraints);
        }
        constraints.gridx = 0;
        ++constraints.gridy;
        basePanel.add((Component)backButton, constraints);
        constraints.gridx = 3;
        basePanel.add((Component)button, constraints);
    }

    @FunctionalInterface
    public static interface ButtonCallbackComponents {
        public void apply(JPanel var1, JTextField var2, JTextField var3, JComboBox<String> var4);
    }

    @FunctionalInterface
    public static interface ButtonCallback {
        public void apply(String var1, String var2, String var3);
    }
}

