/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.splash;

import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jpedal.examples.JPedal;
import org.jpedal.examples.PdfUtilities;
import org.jpedal.examples.splash.SplashToolBuilder;
import org.jpedal.examples.text.ExtractStructuredText;
import org.jpedal.examples.text.ExtractTextInRectangle;
import org.jpedal.examples.text.configuration.ExtractStructuredTextProperties;
import org.jpedal.examples.text.configuration.OutputModes;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.utils.LogWriter;

public class JPedalSplash
extends JPanel {
    static final Font FONT = new Font("SansSerif", 1, 13);
    static final Font MONO_FONT = new Font("Monospaced", 0, 12);
    private static final Color BUTTON_COLOR = new Color(230, 230, 230);
    static final Dimension PANEL_SIZE = new Dimension(700, 450);
    private final JFrame parentFrame;

    public JPedalSplash(JFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.setSize(PANEL_SIZE);
        this.setPreferredSize(PANEL_SIZE);
        this.setLayout(null);
        this.setupHome();
    }

    void setupHome() {
        this.removeAll();
        JPanel container = new JPanel();
        container.setLayout(new GridLayout(0, 2, 10, 10));
        container.setBorder(new EmptyBorder(10, 10, 10, 1));
        Arrays.asList(JPedalSplash.makeHelpWindowButton("Launch Viewer", "The JPedal PDF Viewer.", event -> {
            this.parentFrame.dispose();
            JPedal.doAction(JPedal.Action.VIEW, new String[0]);
        }), JPedalSplash.makeHelpWindowButton("Launch Inspector", "PDF Inspector and Debugger.", event -> {
            this.parentFrame.dispose();
            JPedal.doAction(JPedal.Action.INSPECT, new String[0]);
        }), JPedalSplash.makeHelpWindowButton("PDF to Image", "Convert PDFs to images.", e2 -> this.setupConversion()), JPedalSplash.makeHelpWindowButton("Print PDF", "Send a PDF to a printer.", e2 -> this.setupPrint()), JPedalSplash.makeHelpWindowButton("Extract Text", "Extract structured and unstructured text from a PDF.", e2 -> this.setupTextExtraction()), JPedalSplash.makeHelpWindowButton("Extract Images", "Extract images from a PDF.", e2 -> this.setupImageExtraction()), JPedalSplash.makeHelpWindowButton("Extract Metadata", "Extract various metadata from a PDF.", e2 -> this.setupExtractMetadata()), JPedalSplash.makeHelpWindowButton("About", "Information about this software.", e2 -> this.setupAbout())).forEach(container::add);
        JScrollPane scrollPane = new JScrollPane(container, 22, 31);
        scrollPane.setSize(PANEL_SIZE);
        scrollPane.setPreferredSize(PANEL_SIZE);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add(scrollPane);
        this.revalidate();
        this.repaint();
    }

    private void setupConversion() {
        this.removeAll();
        this.add(new SplashToolBuilder(this).setTitleText("Convert PDF to Image").setInputFilter(new FileFilterer(new String[]{"pdf"}, "PDF Files (*.pdf)")).setEnableOutput(true).setComboTitleText("Image Format").setComboItems(Arrays.stream(SupportedFormats.getSupportedImageEncoders()).map(item -> item[0]).collect(Collectors.toList())).setButtonText("Convert").setButtonCallback((input, output, comboValue) -> {
            try {
                JPedal.doAction(JPedal.Action.CONVERT, new String[]{input, output, comboValue});
                JOptionPane.showMessageDialog(this.parentFrame, "Conversion completed");
            }
            catch (Exception ex) {
                LogWriter.writeLog("[EXCEPTION] " + ex.getMessage());
                JOptionPane.showMessageDialog(this.parentFrame, "Conversion threw exception:\n " + ex.getMessage());
            }
        }).build());
        this.revalidate();
        this.repaint();
    }

    private void setupPrint() {
        this.removeAll();
        this.add(new SplashToolBuilder(this).setTitleText("Print PDF").setInputTitleText("Input File").setInputFilter(new FileFilterer(new String[]{"pdf"}, "PDF Files (*.pdf)")).setInputType(0).setComboTitleText("Printer").setComboItems(Arrays.stream(PrintStatus.getAvailablePrinters(null)).collect(Collectors.toList())).setFullSizeCombo(true).setButtonText("Print").setButtonCallback((input, output, comboValue) -> {
            Box container = Box.createVerticalBox();
            container.setSize(300, 100);
            container.add(JPedalSplash.centreAlign(new JLabel("Printing...")));
            JProgressBar progress = new JProgressBar();
            progress.setIndeterminate(true);
            container.add(progress);
            JDialog printDialog = new JOptionPane(container, -1).createDialog(this.parentFrame, "Printing");
            printDialog.setModal(false);
            printDialog.setVisible(true);
            Thread printThread = new Thread(() -> {
                try {
                    JPedal.doAction(JPedal.Action.PRINT, new String[]{input, comboValue});
                }
                catch (Exception ex) {
                    LogWriter.writeLog("[EXCEPTION] " + ex.getMessage());
                    JOptionPane.showMessageDialog(this.parentFrame, "Failed to print, exception:\n " + ex.getMessage());
                }
                finally {
                    SwingUtilities.invokeLater(printDialog::dispose);
                }
            });
            printThread.start();
        }).build());
        this.revalidate();
        this.repaint();
    }

    private void setupTextExtraction() {
        this.removeAll();
        this.add(new SplashToolBuilder(this).setTitleText("Extract Text from a PDF").setInputFilter(new FileFilterer(new String[]{"pdf"}, "PDF Files (*.pdf)")).setEnableOutput(true).setComboTitleText("Image Format").setComboItems(Arrays.asList("Unstructured Text (Plain Text)", "Unstructured Text (XML)", "Structured Text (HTML)", "Structured Text (XML)")).setButtonText("Extract").setButtonCallback((input, output, comboValue) -> {
            try {
                switch (comboValue) {
                    case "Unstructured Text (Plain Text)": {
                        ExtractTextInRectangle.writeAllTextToDir(input, null, output + '/', -1, ExtractTextInRectangle.OUTPUT_FORMAT.TXT, false);
                        break;
                    }
                    case "Unstructured Text (XML)": {
                        ExtractTextInRectangle.writeAllTextToDir(input, null, output + '/', -1, ExtractTextInRectangle.OUTPUT_FORMAT.XML, false);
                        break;
                    }
                    case "Structured Text (HTML)": 
                    case "Structured Text (XML)": {
                        ExtractStructuredTextProperties properties = new ExtractStructuredTextProperties();
                        properties.setFileOutputMode("Structured Text (HTML)".equals(comboValue) ? OutputModes.HTML : OutputModes.XML);
                        ExtractStructuredText.writeAllStructuredTextOutlinesToDir(input, null, output + '/', null, properties);
                    }
                }
                JOptionPane.showMessageDialog(this.parentFrame, "Extraction completed");
            }
            catch (Exception ex) {
                LogWriter.writeLog("[EXCEPTION] " + ex.getMessage());
                JOptionPane.showMessageDialog(this.parentFrame, "Conversion threw exception:\n " + ex.getMessage());
            }
        }).build());
        this.revalidate();
        this.repaint();
    }

    private void setupImageExtraction() {
        this.removeAll();
        this.add(new SplashToolBuilder(this).setTitleText("Extract Images From PDF").setInputFilter(new FileFilterer(new String[]{"pdf"}, "PDF Files (*.pdf)")).setEnableOutput(true).setComboTitleText("Image Format").setComboItems(Arrays.stream(SupportedFormats.getSupportedImageEncoders()).map(item -> item[0]).collect(Collectors.toList())).setButtonText("Extract").setButtonCallback((input, output, comboValue) -> {
            try {
                JPedal.doAction(JPedal.Action.EXTRACTIMAGES, new String[]{input, output, comboValue});
                JOptionPane.showMessageDialog(this.parentFrame, "Extraction completed");
            }
            catch (Exception ex) {
                LogWriter.writeLog("[EXCEPTION] " + ex.getMessage());
                JOptionPane.showMessageDialog(this.parentFrame, "Extraction threw exception:\n " + ex.getMessage());
            }
        }).build());
        this.revalidate();
        this.repaint();
    }

    private void setupExtractMetadata() {
        this.removeAll();
        this.add(new SplashToolBuilder(this).setTitleText("Extract PDF Metadata").setInputTitleText("Input File").setInputFilter(new FileFilterer(new String[]{"pdf"}, "PDF Files (*.pdf)")).setInputType(0).setComboTitleText("Metadata Type").setComboItems(Arrays.asList("Fields", "XML", "Page Sizes", "Outline", "Fonts", "XObjects", "Page Count")).setButtonText("Extract").setButtonCallback((input, output, comboValue) -> {
            PdfUtilities utilities = new PdfUtilities(input);
            try {
                String text;
                utilities.openPDFFile();
                switch (comboValue) {
                    case "Fields": {
                        text = JPedal.getMetadataFields(utilities).toString();
                        break;
                    }
                    case "XML": {
                        text = utilities.getDocumentPropertyFieldsInXML();
                        break;
                    }
                    case "Page Sizes": {
                        text = Arrays.toString(JPedal.getPageSizes(utilities));
                        break;
                    }
                    case "Outline": {
                        text = Arrays.toString(Objects.requireNonNull(JPedal.getOutline(input)));
                        break;
                    }
                    case "Fonts": {
                        text = JPedal.getFonts(utilities).toString();
                        break;
                    }
                    case "XObjects": {
                        text = JPedal.getXObjects(utilities).toString();
                        break;
                    }
                    case "Page Count": {
                        text = String.format("Page count: %s", utilities.getPageCount());
                        break;
                    }
                    default: {
                        text = "";
                    }
                }
                JScrollPane textScroll = new JScrollPane(JPedalSplash.makeSelectableText(text, null, true), 20, 31);
                textScroll.setPreferredSize(new Dimension(400, 300));
                JDialog metadataDialog = new JOptionPane(textScroll, -1).createDialog(this.parentFrame, "Metadata");
                metadataDialog.setModal(false);
                metadataDialog.setVisible(true);
            }
            catch (Exception ex) {
                LogWriter.writeLog("[EXCEPTION] " + ex.getMessage());
                JOptionPane.showMessageDialog(this.parentFrame, "Extraction threw exception:\n " + ex.getMessage());
            }
            finally {
                utilities.closePDFfile();
            }
        }).build());
        this.revalidate();
        this.repaint();
    }

    private void setupAbout() {
        this.removeAll();
        Box panel = Box.createVerticalBox();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setSize(JPedalSplash.PANEL_SIZE.width, 0);
        panel.add(JPedalSplash.leftAlign(JPedalSplash.getStyledLabel(new JLabel(String.format("<html><h1>JPedal - %s</h1></html", JPedal.getVersion())))));
        Arrays.stream("Features:\n\tPDF Viewer\n\tPDF Inspector\n\tConvert Pages to Images\n\tExtract Text\n\tExtract Embedded Images\n\tExtract Metadata\n\tPrint PDF\n\nHomepage: https://www.idrsolutions.com/jpedal\nJavadoc: https://files.idrsolutions.com/maven/site/jpedal/apidocs/".replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").split("\n")).map(part -> {
            JLabel label = new JLabel();
            if (part.contains("https://")) {
                label.setText(String.format("<html>&nbsp;%s</html>", part));
                String http = part.substring(part.indexOf("https://"));
                label.addMouseListener(new TextLink(panel, label, http));
            } else {
                label.setText(String.format("<html>%s</html>", part));
            }
            return JPedalSplash.leftAlign(JPedalSplash.getStyledLabel(label));
        }).forEach(panel::add);
        panel.add(JPedalSplash.getStyledLabel(new JLabel("<html></html>")));
        panel.add(JPedalSplash.leftAlign(JPedalSplash.getStyledLabel(new JLabel("<html><h2>Available commandline arguments:</h2></html>"))));
        panel.add(JPedalSplash.makeSelectableText(Arrays.stream(JPedal.Action.values()).map(action -> String.format("    %s", action.exampleUsage())).collect(Collectors.joining("\n")), new Dimension(JPedalSplash.PANEL_SIZE.width - 100, 180), true));
        JScrollPane scrolledComponent = new JScrollPane(panel, 20, 31);
        scrolledComponent.setSize(PANEL_SIZE);
        scrolledComponent.getVerticalScrollBar().setUnitIncrement(16);
        this.add(scrolledComponent);
        JButton backButton = new JButton();
        backButton.addActionListener(e2 -> this.setupHome());
        backButton.setText("Back");
        JPanel hostPanel = new JPanel(new BorderLayout());
        hostPanel.setSize(PANEL_SIZE);
        hostPanel.setPreferredSize(PANEL_SIZE);
        hostPanel.add((Component)scrolledComponent, "Center");
        hostPanel.add((Component)JPedalSplash.leftAlign(backButton), "South");
        this.add(hostPanel);
        this.revalidate();
        this.repaint();
    }

    private static JButton makeHelpWindowButton(String title, String description, ActionListener clickAction) {
        JButton button = new JButton();
        button.setBackground(BUTTON_COLOR);
        button.setPreferredSize(new Dimension(300, 125));
        Box box = Box.createVerticalBox();
        box.setAlignmentY(-1.0f);
        box.add(JPedalSplash.getStyledLabel(new JLabel(String.format("<html><h1>%s</h1></html>", title))));
        box.add(JPedalSplash.getStyledLabel(new JLabel(String.format("<html><p>%s</p></html>", description))));
        button.add(box);
        button.addActionListener(clickAction);
        return button;
    }

    private static JTextArea makeSelectableText(String text, Dimension size, boolean wrap) {
        JTextArea selectable = new JTextArea(text);
        selectable.setEditable(false);
        if (size != null) {
            selectable.setSize(size);
            selectable.setPreferredSize(size);
        }
        selectable.setCursor(Cursor.getPredefinedCursor(2));
        selectable.setLineWrap(wrap);
        selectable.setFont(MONO_FONT);
        return selectable;
    }

    private static JComponent leftAlign(JComponent component) {
        Box container = Box.createHorizontalBox();
        container.add(component);
        container.add(Box.createHorizontalGlue());
        return container;
    }

    private static JComponent centreAlign(JComponent component) {
        Box container = Box.createHorizontalBox();
        container.add(Box.createHorizontalGlue());
        container.add(component);
        container.add(Box.createHorizontalGlue());
        return container;
    }

    static JLabel getStyledLabel(JLabel label) {
        label.setFont(FONT);
        return label;
    }

    private static class TextLink
    extends MouseAdapter {
        final JComponent parent;
        final JLabel label;
        final String http;

        TextLink(JComponent parent, JLabel label, String http) {
            this.parent = parent;
            this.label = label;
            this.http = http;
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            this.parent.setCursor(new Cursor(12));
            String labelStr = this.label.getText();
            labelStr = labelStr.replaceAll("https://", "<u>https://");
            labelStr = labelStr.replaceAll("</html>", "</u></html>");
            this.label.setText(labelStr);
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            this.parent.setCursor(new Cursor(0));
            String labelStr = this.label.getText();
            labelStr = labelStr.replaceAll("<u>", "");
            labelStr = labelStr.replaceAll("</u>", "");
            this.label.setText(labelStr);
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            try {
                Desktop.getDesktop().browse(new URI(this.http));
            }
            catch (IOException | URISyntaxException e1) {
                System.out.println("Exception: " + e1.getMessage());
            }
        }
    }
}

