/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class ExtractClippedImages
extends BaseImageExtraction {
    private static int outputCount;
    private static float[] outputSizes;
    private static String[] outputDirectories;
    private static final Color backgroundColor;

    public ExtractClippedImages(String fileName) {
        super(fileName);
        this.init();
    }

    public ExtractClippedImages(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    public BufferedImage getClippedImage(int page, int imageNumber) throws PdfException {
        return this.getClippedImage(page, this.getImageName(page, imageNumber));
    }

    private BufferedImage getClippedImage(int page, String image_name) throws PdfException {
        this.selectPage(page);
        return this.decode_pdf.getObjectStore().loadStoredImage("CLIP_" + image_name);
    }

    public static void writeAllClippedImagesToDirs(String inputDir, String password, String outDir, String imageType, String[] subDirs, ErrorTracker errorTracker) throws PdfException {
        ExtractClippedImages extract;
        if (SupportedFormats.hasEncoderSupportForImageFormat(imageType)) {
            extract = new ExtractClippedImages(inputDir);
            if (password != null) {
                extract.setPassword(password);
            }
            if (errorTracker != null) {
                extract.decode_pdf.addExternalHandler(extract, 31);
            }
        } else {
            throw new RuntimeException("Unknown image format - " + imageType);
        }
        extract.setup(outDir, imageType, subDirs);
        extract.processFiles(inputDir);
        extract.closePDFfile();
    }

    public static void writeAllClippedImagesToDirs(String inputDir, String password, String outDir, String imageType, String[] subDirs) throws PdfException {
        ExtractClippedImages.writeAllClippedImagesToDirs(inputDir, password, outDir, imageType, subDirs, null);
    }

    public static void writeAllClippedImagesToDirs(String inputDir, String outDir, String imageType, String[] subDirs) throws PdfException {
        ExtractClippedImages.writeAllClippedImagesToDirs(inputDir, null, outDir, imageType, subDirs, null);
    }

    private void setup(String outDir, String imageType, String[] subDirs) throws PdfException {
        if (!outDir.endsWith(separator)) {
            outDir = outDir + separator;
        }
        this.imageType = imageType;
        outputCount = subDirs.length / 2;
        outputSizes = new float[outputCount];
        outputDirectories = new String[outputCount];
        for (int i2 = 0; i2 < outputCount; ++i2) {
            try {
                ExtractClippedImages.outputSizes[i2] = Float.parseFloat(subDirs[i2 * 2]);
            }
            catch (Exception e2) {
                throw new PdfException("Exception " + e2 + " reading integer " + subDirs[i2 * 2], e2);
            }
            try {
                File dir;
                ExtractClippedImages.outputDirectories[i2] = outDir + subDirs[1 + i2 * 2];
                if (!outputDirectories[i2].endsWith("\\") && !outputDirectories[i2].endsWith("/")) {
                    int n2 = i2;
                    outputDirectories[n2] = outputDirectories[n2] + separator;
                }
                if ((dir = new File(outputDirectories[i2])).exists()) continue;
                dir.mkdirs();
                continue;
            }
            catch (Exception e3) {
                throw new PdfException("Exception " + e3 + " with directory " + subDirs[4 + i2 * 2], e3);
            }
        }
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        if (this.openPDFFile()) {
            boolean start = true;
            int end = this.getPageCount();
            try {
                for (int page = 1; page < end + 1; ++page) {
                    int i2;
                    LogWriter.writeLog("Decoding Page " + page);
                    int image_count = this.getImageCount(page);
                    if (image_count > 0) {
                        LogWriter.writeLog("page " + page + "contains " + image_count + " images");
                    } else {
                        LogWriter.writeLog("No bitmapped images on page " + page);
                    }
                    LogWriter.writeLog("Writing out " + image_count + " images");
                    float[] x1 = new float[image_count];
                    float[] y1 = new float[image_count];
                    float[] w2 = new float[image_count];
                    float[] h2 = new float[image_count];
                    String[] image_name = new String[image_count];
                    BufferedImage[] image = new BufferedImage[image_count];
                    for (i2 = 0; i2 < image_count; ++i2) {
                        image_name[i2] = this.getImageName(page, i2);
                        x1[i2] = this.pdf_images.getImageXCoord(i2);
                        y1[i2] = this.pdf_images.getImageYCoord(i2);
                        w2[i2] = this.pdf_images.getImageWidth(i2);
                        h2[i2] = this.pdf_images.getImageHeight(i2);
                        image[i2] = this.getClippedImage(page, image_name[i2]);
                    }
                    for (i2 = 0; i2 < image_count; ++i2) {
                        if (image[i2] == null) continue;
                        this.generateVersions(file_name, page, "<PAGELOCATION x1=\"" + x1[i2] + "\" y1=\"" + (y1[i2] + h2[i2]) + "\" x2=\"" + (x1[i2] + w2[i2]) + "\" y2=\"" + y1[i2] + "\" />\n", image[i2], i2);
                    }
                    this.decode_pdf.flushObjectValues(true);
                }
            }
            catch (Exception e2) {
                this.decode_pdf.closePdfFile();
                LogWriter.writeLog(e2);
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void generateVersions(String file_name, int page, String s2, BufferedImage bufferedImage, int i2) {
        for (int versions = 0; versions < outputCount; ++versions) {
            try {
                BufferedImage image_to_save = bufferedImage;
                if (image_to_save == null) continue;
                int index = file_name.lastIndexOf(92);
                if (index == -1) {
                    index = file_name.lastIndexOf(47);
                }
                if (index == -1) {
                    index = 0;
                }
                String nameToUse = file_name.substring(index, file_name.length() - 4);
                String outputName = outputDirectories[versions] + nameToUse + '_' + page + '_' + i2;
                float scaling = 1.0f;
                int newHeight = image_to_save.getHeight();
                if (outputSizes[versions] > 0.0f) {
                    scaling = outputSizes[versions] / (float)newHeight;
                    if (scaling > 1.0f) {
                        scaling = 1.0f;
                    } else {
                        Image scaledImage = image_to_save.getScaledInstance(-1, (int)outputSizes[versions], 4);
                        image_to_save = new BufferedImage((int)((float)image_to_save.getWidth() * scaling), (int)outputSizes[versions], 2);
                        Graphics2D g2 = image_to_save.createGraphics();
                        g2.drawImage(scaledImage, 0, 0, null);
                    }
                }
                if (this.imageType.startsWith("jp") && !"jp2".equalsIgnoreCase(this.imageType)) {
                    int iw = image_to_save.getWidth();
                    int ih = image_to_save.getHeight();
                    BufferedImage background = new BufferedImage(iw, ih, 1);
                    Graphics2D g2 = (Graphics2D)background.getGraphics();
                    g2.setPaint(backgroundColor);
                    g2.fillRect(0, 0, iw, ih);
                    g2.drawImage((Image)image_to_save, 0, 0, null);
                    image_to_save = background;
                }
                if (image_to_save.getType() == 0) {
                    image_to_save = ColorSpaceConvertor.convertToARGB(image_to_save);
                }
                try {
                    JDeli.write(image_to_save, this.imageType, new File(outputName + '.' + this.imageType));
                }
                catch (IOException ex) {
                    LogWriter.writeLog("Exception in writing image " + ex);
                }
                try (OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outputName + ".xml"), StandardCharsets.UTF_8);){
                    output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    output_stream.write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                    output_stream.write("(x1,y1 is top left corner)\n");
                    output_stream.write("(origin is bottom left corner)  -->\n");
                    output_stream.write("\n\n<META>\n");
                    output_stream.write(s2);
                    output_stream.write("<FILE>" + file_name + "</FILE>\n");
                    output_stream.write("<ORIGINALHEIGHT>" + newHeight + "</ORIGINALHEIGHT>\n");
                    output_stream.write("<SCALEDHEIGHT>" + image_to_save.getHeight() + "</SCALEDHEIGHT>\n");
                    output_stream.write("<SCALING>" + scaling + "</SCALING>\n");
                    output_stream.write("</META>\n");
                }
                catch (IOException e2) {
                    LogWriter.writeLog(e2);
                }
                continue;
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception " + ee + " in extracting images");
            }
        }
    }

    public static void main(String[] args) {
        String[] subDirs = ExtractClippedImages.validateInputValues(args);
        try {
            ExtractClippedImages.writeAllClippedImagesToDirs(args[0], args[1], args[2], subDirs);
        }
        catch (PdfException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String[] validateInputValues(String[] args) throws RuntimeException {
        String[] subDirs;
        String inputDir;
        if (args.length >= 5 && args.length % 2 == 1) {
            LogWriter.writeLog("Values read");
            LogWriter.writeLog("inputDir=" + args[0]);
            LogWriter.writeLog("type=" + args[1]);
            LogWriter.writeLog("Directory and height pair values" + args[3] + " <> " + args[4] + '<');
            inputDir = args[0];
            outputCount = args.length - 3;
            subDirs = new String[outputCount];
            for (int i2 = 0; i2 < outputCount; ++i2) {
                LogWriter.writeLog(args[i2 + 3]);
                if (i2 % 2 == 0 && !args[i2 + 3].matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+")) {
                    throw new RuntimeException("Invalid value: " + args[i2 + 3]);
                }
                subDirs[i2] = args[i2 + 3];
            }
        } else {
            if ((args.length - 3) % 2 == 1) {
                throw new RuntimeException("Value/Directory pairs invalid");
            }
            System.out.println("Requires");
            System.out.println("inputDir processedDir imageOutputType");
            System.out.println("height Directory (as many pairs as you like)");
            throw new RuntimeException("Not enough parameters passed to software");
        }
        File pdf_file = new File(inputDir);
        if (!pdf_file.exists()) {
            throw new RuntimeException("Directory " + inputDir + " not found");
        }
        return subDirs;
    }

    @Override
    void init() {
        this.type = BaseImageExtraction.ExtractTypes.CLIPPED_IMAGES;
        super.init();
    }

    public int getImageCount(int page) throws PdfException {
        this.selectPage(page);
        return this.pdf_images.getImageCount();
    }

    private String getImageName(int page, int imageNumber) throws PdfException {
        this.selectPage(page);
        return this.pdf_images.getImageName(imageNumber);
    }

    static {
        backgroundColor = Color.WHITE;
    }
}

