/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.tiff.options.TiffCompressionFormat;
import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import javax.print.attribute.standard.PageRanges;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.fonts.FontMappings;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.StringUtils;

public class ConvertPagesToImages
extends BaseImageExtraction {
    private float pageScaling = 1.33f;
    private final String[] ocr = new String[]{"TeleForm"};
    public static int maxPageCount = -1;
    private int[] dimensions;
    private int[][] range;
    private Iterator<Integer> pages;

    public static void writeAllPagesAsImagesToDir(String inputDir, String outDir, String format, float pageScaling) throws PdfException {
        ConvertPagesToImages.writeAllPagesAsImagesToDir(inputDir, outDir, format, pageScaling, null, null);
    }

    public static void writeAllPagesAsImagesToDir(String inputDir, String outDir, String format, float pageScaling, String password) throws PdfException {
        ConvertPagesToImages.writeAllPagesAsImagesToDir(inputDir, outDir, format, pageScaling, password, null);
    }

    public static void writeAllPagesAsImagesToDir(String inputDir, String outDir, String format, float pageScaling, String password, ErrorTracker errorTracker) throws PdfException {
        ConvertPagesToImages convert;
        if (SupportedFormats.hasEncoderSupportForImageFormat(format)) {
            convert = new ConvertPagesToImages(inputDir);
            if (password != null) {
                convert.setPassword(password);
            }
            if (errorTracker != null) {
                convert.decode_pdf.addExternalHandler(errorTracker, 31);
            }
        } else {
            throw new RuntimeException("Unknown image format - " + format);
        }
        convert.setup(format, outDir, pageScaling);
        convert.processFiles(inputDir);
        convert.closePDFfile();
    }

    public static void writeAllPagesAsImagesToDir(String inputDir, String outDir, String format, int[] dimensions) throws PdfException {
        if (!SupportedFormats.hasEncoderSupportForImageFormat(format)) {
            throw new RuntimeException("Unknown image format - " + format);
        }
        ConvertPagesToImages convert = new ConvertPagesToImages(inputDir);
        convert.setFitToSize(dimensions);
        convert.setup(format, outDir, 1.0f);
        convert.processFiles(inputDir);
        convert.closePDFfile();
    }

    public static void writeAllPagesAsImagesToDir(String inputDir, String outDir, String format, String pageRange, float pageScaling) throws PdfException {
        if (!SupportedFormats.hasEncoderSupportForImageFormat(format)) {
            throw new RuntimeException("Unknown image format - " + format);
        }
        ConvertPagesToImages convert = new ConvertPagesToImages(inputDir);
        convert.setPageRange(new PageRanges(pageRange));
        convert.setup(format, outDir, pageScaling);
        convert.processFiles(inputDir);
        convert.closePDFfile();
    }

    public void setPageScaling(float pageScaling) {
        this.pageScaling = pageScaling;
        this.decode_pdf.setExtractionMode(0, pageScaling);
    }

    public void setFitToSize(int[] dimensions) {
        if (dimensions == null || dimensions.length != 2) {
            throw new RuntimeException("Invalid value for dimensions - expected int[]{width, height}");
        }
        this.dimensions = dimensions;
    }

    public void setPageRange(PageRanges r2) {
        if (r2 != null) {
            this.range = r2.getMembers();
        }
    }

    @Override
    public boolean openPDFFile() throws PdfException, RuntimeException {
        boolean open = super.openPDFFile();
        int count = this.getPageCount();
        if (this.range != null) {
            ArrayList rangeList = new ArrayList();
            for (int[] r2 : this.range) {
                int start = r2[0];
                int end = r2[1];
                if (start > count) {
                    throw new RuntimeException("Page range: " + start + '-' + end + " exceeds the number of pages: " + count);
                }
                if (end > count) {
                    System.err.print("Page range end: " + end + " exceeds the number of pages: " + count + '.');
                    System.err.println("    Only pages requested that are within the page count have been processed.");
                    end = count;
                }
                IntStream.range(start, end + 1).forEach(rangeList::add);
            }
            this.pages = rangeList.iterator();
        } else {
            this.pages = null;
        }
        return open;
    }

    private void setup(String format, String outDir, float pageScaling) throws RuntimeException {
        if (!outDir.endsWith(separator)) {
            outDir = outDir + separator;
        }
        this.imageType = format;
        this.output_dir = outDir;
        this.pageScaling = pageScaling;
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
    }

    @Override
    void processFiles(String inputDir) throws PdfException, RuntimeException {
        File pdf_file = new File(inputDir);
        if (!pdf_file.exists()) {
            throw new RuntimeException("File " + pdf_file + " not found");
        }
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
        if (inputDir.toLowerCase().endsWith(".pdf")) {
            try {
                this.decodeFile(inputDir);
            }
            catch (Exception e2) {
                throw new RuntimeException("ConvertPagesToImages " + e2 + " in pdf code in " + inputDir);
            }
        }
        String[] files = null;
        if (!inputDir.endsWith(separator)) {
            inputDir = inputDir + separator;
        }
        try {
            File inputFiles = new File(inputDir);
            if (!inputFiles.isDirectory()) {
                throw new RuntimeException(inputDir + " is not a pdf or a directory.");
            }
            files = inputFiles.list();
        }
        catch (Exception ee) {
            throw new PdfException("Exception trying to access file " + ee.getMessage(), ee);
        }
        if (files != null) {
            for (String file : files) {
                if (!file.toLowerCase().endsWith(".pdf")) continue;
                try {
                    this.decodeFile(inputDir + file);
                }
                catch (Exception e1) {
                    System.err.println("ConvertPagesToImages " + e1 + " in pdf code in " + inputDir);
                }
            }
        }
    }

    public ConvertPagesToImages(String fileName) {
        super(fileName);
        this.init();
    }

    public ConvertPagesToImages(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        String name = "demo";
        int pointer = file_name.lastIndexOf(separator);
        if (pointer == -1) {
            pointer = file_name.lastIndexOf(47);
        }
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        } else if (file_name.toLowerCase().endsWith(".pdf")) {
            name = file_name.substring(0, file_name.length() - 4);
        }
        if (name.startsWith(".")) {
            return;
        }
        if (this.output_dir == null) {
            this.output_dir = this.user_dir + "thumbnails" + separator;
        }
        this.decode_pdf.setExtractionMode(0, this.pageScaling);
        this.fileName = file_name;
        if (this.openPDFFile()) {
            String separation;
            File output_path = new File(this.output_dir);
            if (!output_path.exists()) {
                output_path.mkdirs();
            }
            if ((separation = System.getProperty("org.jpedal.separation")) != null) {
                Object[] sepValues = new Object[]{7, "", Boolean.FALSE};
                if ("all".equals(separation)) {
                    sepValues = new Object[]{2, "image_and_shapes", Boolean.FALSE, 18, "image_without_shapes", Boolean.FALSE, 1, "text_and_shapes", Boolean.TRUE, 7, "all", Boolean.FALSE, 17, "text_without_shapes", Boolean.TRUE};
                }
                int sepCount = sepValues.length;
                for (int seps = 0; seps < sepCount; seps += 3) {
                    this.decode_pdf.setRenderMode((Integer)sepValues[seps]);
                    this.extractPagesAsImages(file_name, this.output_dir, name + '_' + sepValues[seps + 1], (Boolean)sepValues[seps + 2]);
                }
            } else {
                this.extractPagesAsImages(file_name, this.output_dir, name, false);
            }
        }
        this.closePDFfile();
    }

    public void extractPagesAsImages(String file_name, String output_dir, String name, boolean isTransparent) {
        File output_path = new File(output_dir);
        if (!output_path.exists()) {
            output_path.mkdirs();
        }
        String multiPageFlag = System.getProperty("org.jpedal.multipage_tiff");
        boolean isSingleOutputFile = "true".equalsIgnoreCase(multiPageFlag);
        String tiffFlag = System.getProperty("org.jpedal.compress_tiff");
        boolean compressTiffs = "true".equalsIgnoreCase(tiffFlag);
        this.setJPEGCompression();
        if (this.pages == null) {
            boolean start = true;
            int end = this.getPageCount();
            if (end > 10 && maxPageCount > 0) {
                end = maxPageCount;
            }
            ArrayList range = new ArrayList();
            IntStream.range(1, end + 1).forEach(range::add);
            this.pages = range.iterator();
        }
        try {
            this.pages.forEachRemaining(page -> {
                try {
                    this.getPage(output_dir, name, isTransparent, isSingleOutputFile, compressTiffs, page + 1, (int)page);
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            });
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception " + e2.getMessage() + " with thumbnails on File=" + file_name);
        }
    }

    private void getPage(String output_dir, String name, boolean isTransparent, boolean isSingleOutputFile, boolean compressTiffs, int end, int page) throws Exception {
        Iterator<Integer> colorspacesUsed;
        boolean isGrayOnly;
        StringBuilder pageAsString = new StringBuilder(String.valueOf(page));
        String maxPageSize = String.valueOf(end);
        int padding = maxPageSize.length() - pageAsString.length();
        for (int ii = 0; ii < padding; ++ii) {
            pageAsString.insert(0, '0');
        }
        String image_name = isSingleOutputFile ? name : name + "_page_" + pageAsString;
        PdfFileInformation currentFileInformation = this.decode_pdf.getFileInformationData();
        String[] values = currentFileInformation.getFieldValues();
        String[] fields = PdfFileInformation.getFieldNames();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (!"Creator".equals(fields[i2])) continue;
            for (String anOcr : this.ocr) {
                if (!values[i2].equals(anOcr)) continue;
                this.decode_pdf.setRenderMode(2);
            }
        }
        BufferedImage image_to_save = this.getPageAsImage(page, isTransparent);
        if (isTransparent && image_to_save != null && this.imageType.toLowerCase().startsWith("jp")) {
            image_to_save = ConvertPagesToImages.saveJPEGwithoutTransparency(image_to_save);
        }
        boolean bl2 = isGrayOnly = (colorspacesUsed = this.decode_pdf.getPageInfo(1)) != null;
        while (colorspacesUsed != null && colorspacesUsed.hasNext()) {
            int nextID = colorspacesUsed.next();
            if (nextID == 1568372915 || nextID == 391471749) continue;
            isGrayOnly = false;
        }
        if (isGrayOnly && image_to_save != null) {
            BufferedImage image_to_save2 = new BufferedImage(image_to_save.getWidth(), image_to_save.getHeight(), 10);
            image_to_save2.getGraphics().drawImage(image_to_save, 0, 0, null);
            image_to_save = image_to_save2;
        }
        if (image_to_save != null) {
            String imageFormat;
            String maxDimensionAsString = System.getProperty("maxDimension");
            int maxDimension = -1;
            if (maxDimensionAsString != null) {
                maxDimension = Integer.parseInt(maxDimensionAsString);
            }
            if (maxDimension != -1) {
                image_to_save = ConvertPagesToImages.resizeImage(image_to_save, maxDimension, this.imageType);
            }
            if ((imageFormat = System.getProperty("org.jpedal.imageType")) != null) {
                image_to_save = ConvertPagesToImages.convertImage(image_to_save, imageFormat);
            }
            if (this.imageType.toLowerCase().startsWith("tif")) {
                ConvertPagesToImages.saveTiff(output_dir, isSingleOutputFile, compressTiffs, page, image_name, image_to_save);
            } else {
                this.saveImage(this.imageType, false, false, page, image_to_save, output_dir + image_name + '.' + this.imageType.toLowerCase());
            }
        }
        this.decode_pdf.flushObjectValues(true);
    }

    private static BufferedImage resizeImage(BufferedImage image_to_save, int maxDimension, String imageType) {
        Image scaledImage;
        int newWidth = image_to_save.getWidth();
        int newHeight = image_to_save.getHeight();
        if (newWidth > maxDimension || newHeight > maxDimension) {
            if (newWidth > newHeight) {
                newWidth = maxDimension;
                scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
            } else {
                newHeight = maxDimension;
                scaledImage = image_to_save.getScaledInstance(-1, newHeight, 4);
            }
        } else {
            scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
        }
        image_to_save = imageType.toLowerCase().startsWith("jp") ? new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 1) : new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
        Graphics2D g2 = image_to_save.createGraphics();
        g2.drawImage(scaledImage, 0, 0, null);
        return image_to_save;
    }

    private static BufferedImage convertImage(BufferedImage image_to_save, String imageFormat) {
        if (ConvertPagesToImages.isNumber(imageFormat)) {
            int iFormat = Integer.parseInt(imageFormat);
            if (iFormat > -1 && iFormat < 14) {
                BufferedImage tempImage = new BufferedImage(image_to_save.getWidth(), image_to_save.getHeight(), iFormat);
                Graphics2D g2 = tempImage.createGraphics();
                g2.drawImage(image_to_save, null, null);
                image_to_save = tempImage;
            } else {
                System.err.println("Image Type is not valid. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
            }
        } else {
            System.err.println("Image Type provided is not an Integer. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
        }
        return image_to_save;
    }

    private static void saveTiff(String output_dir, boolean isSingleOutputFile, boolean compressTiffs, int page, String image_name, BufferedImage image_to_save) throws IOException {
        boolean isFirstPage = page == 1;
        TiffEncoder tiffEncoder = new TiffEncoder();
        if (System.getProperty("image.tiff.compression") == null) {
            if (compressTiffs) {
                tiffEncoder.getEncoderOptions().setCompressionFormat(TiffCompressionFormat.DEFLATE);
            } else {
                tiffEncoder.getEncoderOptions().setCompressionFormat(TiffCompressionFormat.NONE);
            }
        }
        if (isSingleOutputFile) {
            String outputFileName = output_dir + image_name + ".tif";
            File file = new File(outputFileName);
            if (isFirstPage && file.exists()) {
                file.delete();
                file.createNewFile();
            }
            tiffEncoder.append(image_to_save, outputFileName);
        } else {
            String outputFileName = output_dir + image_name + ".tif";
            File file = new File(outputFileName);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            tiffEncoder.write(image_to_save, bos);
            bos.flush();
            bos.close();
        }
    }

    private static BufferedImage saveJPEGwithoutTransparency(BufferedImage image_to_save) {
        BufferedImage rawVersion = image_to_save;
        int w2 = rawVersion.getWidth();
        int h2 = rawVersion.getHeight();
        image_to_save = new BufferedImage(w2, h2, 1);
        Graphics2D g2 = image_to_save.createGraphics();
        g2.setPaint(Color.WHITE);
        g2.fillRect(0, 0, w2, h2);
        g2.drawImage((Image)rawVersion, 0, 0, null);
        return image_to_save;
    }

    public static void main(String[] args) {
        boolean failed;
        System.out.println("Simple demo to extract images from a page");
        int count = args.length;
        boolean bl2 = failed = count < 2 || count > 5;
        if (failed) {
            System.out.println("wrong arguments entered");
            System.out.println("2-5 values expected - 1. file \n 2. output location for images\n 3. output image type (png, tiff, jpeg) (optional)\n 4. Scaling (optional) \n 5. Page Range (optional)");
            StringBuilder arguments = new StringBuilder();
            for (String arg : args) {
                arguments.append(arg).append('\n');
            }
            System.out.println("you entered:\n" + arguments + "as the arguments");
        } else {
            try {
                switch (count) {
                    case 2: {
                        ConvertPagesToImages.writeAllPagesAsImagesToDir(args[0], args[1], "png", 1.33f);
                        break;
                    }
                    case 4: {
                        ConvertPagesToImages.writeAllPagesAsImagesToDir(args[0], args[1], args[2], Float.parseFloat(args[3]));
                        break;
                    }
                    case 5: {
                        ConvertPagesToImages.writeAllPagesAsImagesToDir(args[0], args[1], args[2], args[4], Float.parseFloat(args[3]));
                        break;
                    }
                    default: {
                        String s2 = args[2].toLowerCase();
                        if (SupportedFormats.hasEncoderSupportForImageFormat(s2)) {
                            ConvertPagesToImages.writeAllPagesAsImagesToDir(args[0], args[1], s2, 1.33f);
                            break;
                        }
                        if (StringUtils.isNumber(s2)) {
                            ConvertPagesToImages.writeAllPagesAsImagesToDir(args[0], args[1], "png", Float.parseFloat(s2));
                            break;
                        }
                        System.out.println("Optional value provided does not match expected type.\n Value should be either output image type (png, tiff, jpeg) or Scaling (scaling as a float e.g. 1.0)");
                        break;
                    }
                }
            }
            catch (PdfException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    private static boolean isNumber(String value) {
        boolean isNumber = true;
        int charCount = value.length();
        for (int i2 = 0; i2 < charCount; ++i2) {
            char c2 = value.charAt(i2);
            if (!(c2 < '0' | c2 > '9')) continue;
            isNumber = false;
            i2 = charCount;
        }
        return isNumber;
    }

    @Override
    void init() {
        FontMappings.setFontReplacements();
        this.type = BaseImageExtraction.ExtractTypes.RASTERIZED_PAGE;
        super.init();
        this.decode_pdf.setExtractionMode(0, this.pageScaling);
    }

    public BufferedImage getPageAsImage(int page, boolean isBackgroundTransparent) throws PdfException {
        this.checkFileOpened();
        if (this.dimensions != null) {
            this.decode_pdf.setExtractionMode(0, this.getScalingForPage(page));
        }
        if (!isBackgroundTransparent) {
            return this.decode_pdf.getPageAsImage(page);
        }
        return this.decode_pdf.getPageAsTransparentImage(page);
    }

    private float getScalingForPage(int pageIndex) {
        float prefHeight;
        float prefWidth;
        PdfPageData pageData = this.decode_pdf.getPdfPageData();
        if (pageData.getRotation(pageIndex) == 90 || pageData.getRotation(pageIndex) == 270) {
            prefWidth = this.dimensions[1];
            prefHeight = this.dimensions[0];
        } else {
            prefWidth = this.dimensions[0];
            prefHeight = this.dimensions[1];
        }
        float crw = pageData.getCropBoxWidth2D(pageIndex);
        float crh = pageData.getCropBoxHeight2D(pageIndex);
        float dScaleW = prefWidth / crw;
        float dScaleH = prefHeight / crh;
        if (dScaleH < dScaleW) {
            dScaleW = dScaleH;
        }
        return dScaleW;
    }

    public BufferedImage getPageAsImage(int page) throws PdfException {
        return this.getPageAsImage(page, false);
    }

    public Iterator<Integer> getPageRange() {
        if (this.range != null) {
            return this.pages;
        }
        return IntStream.range(1, this.getPageCount() + 1).iterator();
    }
}

