/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.PdfDecoderServer;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public final class ConvertPagesToHiResImages
extends BaseImageExtraction {
    public static void main(String[] args) {
        if (args != null && args.length > 1) {
            try {
                if (args.length == 2) {
                    ConvertPagesToHiResImages.writeAllPagesAsHiResImagesToDir(args[0], args[1], "png");
                }
                ConvertPagesToHiResImages.writeAllPagesAsHiResImagesToDir(args[0], args[1], args[2]);
            }
            catch (PdfException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        } else if (args == null) {
            System.out.println("null arguments entered");
        } else {
            System.out.println("wrong arguments entered");
            StringBuilder arguments = new StringBuilder();
            for (String arg : args) {
                arguments.append(arg).append('\n');
            }
            System.out.println("you entered:\n" + arguments + "as the arguments");
        }
    }

    public static void writeAllPagesAsHiResImagesToDir(String inputDir, String outputDir, String format) throws PdfException {
        HashMap<Integer, Object> mapValues = new HashMap<Integer, Object>();
        mapValues.put(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING, 2);
        mapValues.put(JPedalSettings.EXTRACT_AT_PAGE_SIZE, new String[]{"2000", "1600"});
        mapValues.put(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE, Boolean.TRUE);
        ConvertPagesToHiResImages.writeAllPagesAsHiResImagesToDir(inputDir, outputDir, format, mapValues);
    }

    public static void writeAllPagesAsHiResImagesToDir(String inputDir, String outputDir, String format, Map<Integer, Object> mapValues) throws PdfException {
        if (!SupportedFormats.hasEncoderSupportForImageFormat(format)) {
            throw new RuntimeException("Unknown image format - " + format);
        }
        PdfDecoderServer.modifyJPedalParameters(mapValues);
        ConvertPagesToHiResImages convert = new ConvertPagesToHiResImages(inputDir);
        convert.setup(format, outputDir);
        convert.processFiles(inputDir);
        convert.closePDFfile();
    }

    public ConvertPagesToHiResImages(String fileName) {
        super(fileName);
        this.init();
    }

    public ConvertPagesToHiResImages(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    @Override
    void decodeFile(String pdfFile) throws PdfException {
        if (this.openPDFFile()) {
            String separation = System.getProperty("org.jpedal.separation");
            if (separation != null) {
                Object[] sepValues = new Object[]{7, "", Boolean.FALSE};
                if ("all".equals(separation)) {
                    sepValues = new Object[]{2, "image_and_shapes", Boolean.FALSE, 18, "image_without_shapes", Boolean.FALSE, 1, "text_and_shapes", Boolean.TRUE, 7, "all", Boolean.FALSE, 17, "text_without_shapes", Boolean.TRUE};
                }
                int sepCount = sepValues.length;
                for (int seps = 0; seps < sepCount; seps += 3) {
                    this.decode_pdf.setRenderMode((Integer)sepValues[seps]);
                    this.extractPagesAsImages(this.output_dir, this.imageType, "_" + sepValues[seps + 1], (Boolean)sepValues[seps + 2]);
                }
            } else {
                this.extractPagesAsImages(this.output_dir, this.imageType, "", false);
            }
        }
    }

    private void extractPagesAsImages(String outputPath, String fileType, String prefix, boolean isTransparent) throws PdfException {
        File output_path = new File(this.output_dir);
        if (!output_path.exists()) {
            output_path.mkdirs();
        }
        boolean start = true;
        int end = this.getPageCount();
        String multiPageFlag = System.getProperty("org.jpedal.multipage_tiff");
        boolean isSingleOutputFile = "true".equalsIgnoreCase(multiPageFlag);
        String tiffFlag = System.getProperty("org.jpedal.compress_tiff");
        boolean compressTiffs = "true".equalsIgnoreCase(tiffFlag);
        this.setJPEGCompression();
        for (int pageNo = 1; pageNo < end + 1; ++pageNo) {
            boolean isGrayOnly;
            BufferedImage imageToSave = this.getPageAsHiResImage(pageNo, isTransparent, null);
            this.decode_pdf.flushObjectValues(true);
            if ("jpg".equals(fileType)) {
                imageToSave = ColorSpaceConvertor.convertToRGB(imageToSave);
            }
            String outputFileName = isSingleOutputFile ? outputPath + "allPages" + prefix + '.' + fileType : outputPath + "page" + ConvertPagesToHiResImages.getPageName(end, pageNo) + prefix + '.' + fileType;
            Iterator<Integer> colorspacesUsed = this.decode_pdf.getPageInfo(1);
            boolean bl2 = isGrayOnly = colorspacesUsed != null;
            while (colorspacesUsed != null && colorspacesUsed.hasNext()) {
                int nextID = colorspacesUsed.next();
                if (nextID == 1568372915 || nextID == 391471749) continue;
                isGrayOnly = false;
            }
            if (isGrayOnly) {
                BufferedImage image_to_save2 = new BufferedImage(imageToSave.getWidth(), imageToSave.getHeight(), 10);
                image_to_save2.getGraphics().drawImage(imageToSave, 0, 0, null);
                imageToSave = image_to_save2;
            }
            if (imageToSave == null) continue;
            try {
                this.saveImage(fileType, isSingleOutputFile, compressTiffs, pageNo, imageToSave, outputFileName);
            }
            catch (Exception e2) {
                LogWriter.writeLog("Unable to write out image " + e2.getMessage());
            }
            imageToSave.flush();
        }
    }

    private static StringBuilder getPageName(int end, int pageNo) {
        StringBuilder pageAsString = new StringBuilder(String.valueOf(pageNo));
        String maxPageSize = String.valueOf(end);
        int padding = maxPageSize.length() - pageAsString.length();
        for (int ii = 0; ii < padding; ++ii) {
            pageAsString.insert(0, '0');
        }
        return pageAsString;
    }

    public BufferedImage getPageAsHiResImage(int page, boolean isTransparent, Map<Integer, Object> options) throws PdfException {
        return this.decode_pdf.getPageAsHiRes(page, options, isTransparent);
    }

    private void setup(String format, String outputDir) {
        if (!outputDir.endsWith(separator)) {
            outputDir = outputDir + separator;
        }
        this.imageType = format;
        this.output_dir = outputDir;
    }

    @Override
    void init() {
        FontMappings.setFontReplacements();
        this.type = BaseImageExtraction.ExtractTypes.RASTERIZED_PAGE;
        super.init();
    }
}

