/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.jpeg.JpegEncoder;
import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.tiff.options.TiffCompressionFormat;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.objects.PdfImageData;
import org.jpedal.utils.LogWriter;

abstract class BaseImageExtraction {
    private byte[] byteArray;
    private boolean isOpen;
    private int lastPage = -1;
    PdfImageData pdf_images;
    String output_dir;
    private float JPEGcompression = -1.0f;
    String imageType = "png";
    String name = "image";
    ExtractTypes type = ExtractTypes.IMAGES;
    String user_dir = System.getProperty("user.dir");
    PdfDecoderInt decode_pdf;
    static final String separator = System.getProperty("file.separator");
    private String password;
    String fileName;

    void decodeFile(String rootDir) throws PdfException {
        throw new UnsupportedOperationException("decodeFile Not supported yet.");
    }

    BaseImageExtraction(String fileName) {
        this.fileName = fileName;
    }

    BaseImageExtraction(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    void init() {
        this.decode_pdf = new PdfDecoderServer(false);
        FontMappings.setFontReplacements();
        switch (this.type) {
            case IMAGES: {
                String opiFlag = System.getProperty("org.jpedal.opi");
                if (opiFlag == null) {
                    this.decode_pdf.setExtractionMode(1030);
                    break;
                }
                this.decode_pdf.setExtractionMode(1286);
                break;
            }
            case CLIPPED_IMAGES: {
                this.decode_pdf.setExtractionMode(36, 1.0f);
                break;
            }
        }
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
    }

    void selectPage(int page) throws PdfException {
        if (page != this.lastPage) {
            this.decode_pdf.flushObjectValues(true);
            try {
                this.decode_pdf.decodePage(page);
            }
            catch (Exception ex) {
                throw new PdfException(ex.getMessage(), ex);
            }
            this.pdf_images = this.decode_pdf.getPdfImageData();
            this.lastPage = page;
        }
    }

    public int getPageCount() {
        return this.decode_pdf.getPageCount();
    }

    void checkFileOpened() {
        if (!this.isOpen) {
            throw new RuntimeException("PDF file needs to be opened with openPDFFile() method first");
        }
    }

    public boolean openPDFFile() throws PdfException {
        int pointer;
        this.isOpen = false;
        this.lastPage = -1;
        if (this.fileName != null && (pointer = this.fileName.lastIndexOf(separator)) != -1) {
            this.name = this.fileName.substring(pointer + 1, this.fileName.length() - 4);
        }
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            } else {
                return false;
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied()) {
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
            }
        }
        catch (Exception e2) {
            throw new PdfException(e2.getMessage(), e2);
        }
        this.isOpen = true;
        return true;
    }

    public void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
    }

    void processFiles(String rootDir) throws PdfException {
        if (rootDir.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(rootDir);
        } else {
            File testDir;
            if (!rootDir.endsWith("\\") && !rootDir.endsWith("/")) {
                rootDir = rootDir + separator;
            }
            if (!(testDir = new File(rootDir)).isDirectory()) {
                throw new PdfException("No input directory " + rootDir);
            }
            String[] files = null;
            try {
                File inputFiles = new File(rootDir);
                if (!inputFiles.isDirectory()) {
                    System.err.println(rootDir + " is not a directory. Exiting program");
                } else {
                    files = inputFiles.list();
                }
            }
            catch (Exception ee) {
                throw new PdfException("Exception trying to access file " + ee.getMessage(), ee);
            }
            if (files != null) {
                for (String file : files) {
                    if (!file.toLowerCase().endsWith(".pdf")) continue;
                    this.fileName = rootDir + file;
                    this.decodeFile(rootDir + file);
                }
            }
        }
    }

    void saveImage(String fileType, boolean isSingleOutputFile, boolean compressTiffs, int pageNo, BufferedImage imageToSave, String outputFileName) throws Exception {
        if (isSingleOutputFile && fileType.startsWith("tif")) {
            TiffEncoder tiffEncoder = new TiffEncoder();
            if (compressTiffs) {
                tiffEncoder.getEncoderOptions().setCompressionFormat(TiffCompressionFormat.DEFLATE);
            }
            File file = new File(outputFileName);
            if (pageNo == 1 && file.exists()) {
                file.delete();
                file.createNewFile();
            }
            tiffEncoder.append(imageToSave, outputFileName);
        } else if (this.JPEGcompression >= 0.0f && this.JPEGcompression <= 100.0f && fileType.startsWith("jpg")) {
            JpegEncoder jpegEncoder = new JpegEncoder();
            jpegEncoder.getEncoderOptions().setQuality((int)this.JPEGcompression);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFileName));
            jpegEncoder.write(imageToSave, bos);
            bos.flush();
            bos.close();
        } else {
            JDeli.write(imageToSave, fileType, new File(outputFileName));
        }
    }

    void setJPEGCompression() {
        String rawJPEGComp = System.getProperty("org.jpedal.compression_jpeg");
        if (rawJPEGComp != null) {
            try {
                this.JPEGcompression = Float.parseFloat(rawJPEGComp) * 100.0f;
            }
            catch (Exception e2) {
                LogWriter.writeLog(e2);
            }
            if (this.JPEGcompression < 0.0f || this.JPEGcompression > 100.0f) {
                throw new RuntimeException("Invalid value for JPEG compression - input value must be between 0 and 1");
            }
        }
    }

    static enum ExtractTypes {
        IMAGES,
        CLIPPED_IMAGES,
        RASTERIZED_PAGE;

    }
}

