/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.io.DefaultErrorTracker;

public final class ExampleErrorTracker {
    private final Viewer myViewer = new Viewer();

    public static void main(String[] args) {
        new ExampleErrorTracker();
    }

    public ExampleErrorTracker() {
        this.myViewer.setupViewer();
        PdfDecoder decode_pdf = (PdfDecoder)this.myViewer.getPdfDecoder();
        decode_pdf.addExternalHandler(new UserErrorTracker(), 31);
        String file = System.getenv("PDF_DATA") != null ? System.getenv("PDF_DATA") + "test_data/Hand_Test/awjune2003.pdf" : "/PDFdata/test_data/Hand_Test/awjune2003.pdf";
        this.myViewer.executeCommand(ViewerCommands.OPENFILE, new File(file));
    }

    private class UserErrorTracker
    extends DefaultErrorTracker {
        long timeAtStart;
        boolean userFailedPage;

        UserErrorTracker() {
        }

        @Override
        public String getPageFailureMessage() {
            if (this.userFailedPage) {
                return "Timed out on page";
            }
            return super.getPageFailureMessage();
        }

        @Override
        public boolean ispageSuccessful() {
            return !this.userFailedPage && super.ispageSuccessful();
        }

        @Override
        public boolean checkForExitRequest(int dataPointer, int streamSize) {
            long timeElapsed = System.currentTimeMillis() - this.timeAtStart;
            System.out.println("Mill-Seconds elapsed=" + timeElapsed);
            if (timeElapsed > 1500L) {
                this.userFailedPage = true;
                return true;
            }
            return false;
        }

        @Override
        public void finishedPageDecoding(int rawPage) {
            System.out.println("----Completed page " + rawPage);
        }

        @Override
        public void startedPageDecoding(int rawPage) {
            System.out.println("----Started page " + rawPage);
            this.timeAtStart = System.currentTimeMillis();
        }
    }
}

