/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.ImageObject;
import org.jpedal.utils.LogWriter;

public class ExampleAnnotationHandler
implements AnnotationHandler {
    @Override
    public void handleAnnotations(PdfDecoderInt decode_pdf, Map<FormObject, String> objs, int p2) {
        PdfArrayIterator annotListForPage = decode_pdf.getFormRenderer().getAnnotsOnPage(p2);
        if (annotListForPage != null && annotListForPage.getTokenCount() > 0) {
            int i2 = 0;
            int count = annotListForPage.getTokenCount();
            int[] type = new int[count];
            Color[] colors = new Color[count];
            Object[] obj = new Object[count];
            while (annotListForPage.hasMoreTokens()) {
                Object[] rawObj;
                int mX = decode_pdf.getPdfPageData().getMediaBoxX(p2);
                int mY = decode_pdf.getPdfPageData().getMediaBoxY(p2);
                String annotKey = annotListForPage.getNextValueAsString(true);
                for (Object aRawObj : rawObj = decode_pdf.getFormRenderer().getFormComponents(annotKey, ReturnValues.FORMOBJECTS_FROM_NAME, -1)) {
                    FormObject annotObj;
                    int subtype;
                    if (aRawObj == null || (subtype = (annotObj = (FormObject)aRawObj).getNameAsConstant(1147962727)) != 473513531) continue;
                    objs.put(annotObj, "x");
                    Color col = Color.BLUE;
                    Rectangle location = annotObj.getBoundingRectangle();
                    type[i2] = 3;
                    ImageObject imgObject = new ImageObject();
                    imgObject.x = location.x + mX;
                    imgObject.y = location.y + mY;
                    imgObject.image = ExampleAnnotationHandler.createUniqueImage(String.valueOf(i2 + 1), col);
                    obj[i2] = imgObject;
                    ++i2;
                }
            }
            try {
                decode_pdf.drawAdditionalObjectsOverPage(p2, type, colors, obj);
            }
            catch (PdfException e2) {
                LogWriter.writeLog(e2);
            }
        }
    }

    @Override
    public void checkLinks(Map<FormObject, String> objs, boolean mouseClicked, PdfObjectReader pdfObjectReader, int x2, int y2, SwingGUI currentGUI, Values commonValues) {
        Iterator<FormObject> objKeys = objs.keySet().iterator();
        FormObject annotObj = null;
        while (objKeys.hasNext() && !(annotObj = objKeys.next()).getBoundingRectangle().contains(x2, y2)) {
            annotObj = null;
        }
        if (annotObj != null) {
            System.out.println("clicked on=" + mouseClicked + " obj=" + annotObj + ' ' + annotObj.getObjectRefAsString() + ' ' + annotObj.getBoundingRectangle());
            if (!mouseClicked) {
                return;
            }
            PdfObject EFobj = null;
            PdfObject FSobj = annotObj.getDictionary(5667);
            if (FSobj != null) {
                EFobj = FSobj.getDictionary(5398);
            }
            JFileChooser chooser = new JFileChooser(commonValues.getInputDir());
            chooser.setFileSelectionMode(0);
            int state = chooser.showSaveDialog(currentGUI.getFrame());
            if (state == 0) {
                File fileTarget = chooser.getSelectedFile();
                if (EFobj != null) {
                    pdfObjectReader.checkResolved(EFobj);
                    PdfObject Fobj = EFobj.getDictionary(22);
                    String nameOnDisk = Fobj.getCachedStreamFile(pdfObjectReader.getObjectReader());
                    System.out.println("file=" + nameOnDisk);
                    if (nameOnDisk != null) {
                        ObjectStore.copy(nameOnDisk, fileTarget.toString());
                    } else {
                        byte[] fileData = Fobj.getDecodedStream();
                        if (fileData != null) {
                            try {
                                ObjectStore.writeToFile(fileTarget.getAbsolutePath(), fileData);
                            }
                            catch (IOException e2) {
                                LogWriter.writeLog(e2);
                            }
                        }
                    }
                }
            }
        }
    }

    private static BufferedImage createUniqueImage(String text, Color col) {
        BufferedImage img = new BufferedImage(16, 16, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setColor(col);
        g2.fill(new Rectangle(0, 0, 16, 16));
        g2.setColor(Color.BLACK);
        g2.draw(new Rectangle(0, 0, 15, 15));
        g2.setColor(Color.white);
        g2.drawString(text, 2, 12);
        return img;
    }
}

