/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.acroform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class ExtractEmbeddedFiles {
    private byte[] byteArray;
    private PdfDecoderInt decode_pdf;
    private static final String separator = System.getProperty("file.separator");
    private String password;
    private String fileName;

    public static void main(String[] args) {
        if (args != null && args.length > 1) {
            try {
                ExtractEmbeddedFiles.extractAllFilesFromPdf(args[0], args[1]);
            }
            catch (PdfException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        } else {
            System.out.println("wrong arguments entered");
            if (args != null && args.length != 0) {
                StringBuilder arguments = new StringBuilder();
                for (String arg : args) {
                    arguments.append(arg).append('\n');
                }
                System.out.println("you entered:\n" + arguments + "as the arguments");
            } else {
                System.out.println("no arguments were provided");
            }
        }
    }

    public ExtractEmbeddedFiles(String fileName) {
        this.fileName = fileName;
        this.init();
    }

    public ExtractEmbeddedFiles(byte[] byteArray) {
        this.byteArray = byteArray;
        this.init();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void init() {
        FontMappings.setFontReplacements();
        this.decode_pdf = new PdfDecoderServer(false);
    }

    private boolean openPDFFile() throws PdfException {
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            } else {
                return false;
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() || !this.decode_pdf.isExtractionAllowed()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
            }
        }
        catch (Exception e2) {
            throw new PdfException(e2.getMessage(), e2);
        }
        return true;
    }

    private void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
    }

    private boolean containsFilesAttachments() {
        Object[] tempForms = this.decode_pdf.getFormRenderer().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        if (tempForms != null) {
            FormObject[] formArray;
            for (FormObject form : formArray = (FormObject[])Arrays.copyOf(tempForms, tempForms.length, FormObject[].class)) {
                if (form.getNameAsConstant(1147962727) != -1113876231) continue;
                return true;
            }
        }
        return false;
    }

    private void extractFileAttachments(String outputDirectory) {
        if (!outputDirectory.endsWith(separator)) {
            outputDirectory = outputDirectory + separator;
        }
        outputDirectory = outputDirectory + this.decode_pdf.getFileName().substring(this.decode_pdf.getFileName().lastIndexOf(separator) + 1, this.decode_pdf.getFileName().lastIndexOf(46)) + separator;
        Object[] tempForms = this.decode_pdf.getFormRenderer().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        PdfObjectReader reader = this.decode_pdf.getIO();
        if (tempForms != null) {
            FormObject[] formArray = (FormObject[])Arrays.copyOf(tempForms, tempForms.length, FormObject[].class);
            ArrayList<FormObject> fileAttachments = new ArrayList<FormObject>();
            for (FormObject form : formArray) {
                if (form.getNameAsConstant(1147962727) != -1113876231) continue;
                fileAttachments.add(form);
            }
            if (!fileAttachments.isEmpty()) {
                for (int i2 = 0; i2 != fileAttachments.size(); ++i2) {
                    int pathEnd;
                    String filename;
                    byte[] filenameBytes;
                    PdfObject fs = ((FormObject)fileAttachments.get(i2)).getDictionary(5667);
                    reader.checkResolved(fs);
                    byte[] desc = fs.getTextStreamValueAsByte(339034931);
                    if (desc == null) {
                        fs.setTextStreamValue(339034931, ((FormObject)fileAttachments.get(i2)).getTextStreamValueAsByte(1216184967));
                    }
                    if ((filenameBytes = fs.getTextStreamValueAsByte(9494)) == null) {
                        filenameBytes = fs.getTextStreamValueAsByte(22);
                    }
                    if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                        filename = filename.substring(pathEnd + 1);
                    }
                    File outputFile = new File(outputDirectory + filename);
                    try {
                        PdfObject efObj = fs.getDictionary(5398);
                        reader.checkResolved(efObj);
                        PdfObject fileObj = efObj.getDictionary(22);
                        reader.checkResolved(fileObj);
                        byte[] stream = fileObj.getDecodedStream();
                        if (!outputFile.exists()) {
                            boolean created;
                            if (!outputFile.getParentFile().exists()) {
                                outputFile.getParentFile().mkdirs();
                            }
                            if (!(created = outputFile.createNewFile())) {
                                throw new IOException("Unable to create file " + outputFile.getAbsolutePath());
                            }
                        }
                        ObjectStore.writeToFile(outputDirectory + filename, stream);
                        continue;
                    }
                    catch (IOException e2) {
                        LogWriter.writeLog(e2);
                    }
                }
            }
        }
    }

    private boolean containsEmbeddedFiles() {
        PdfObjectReader reader = this.decode_pdf.getIO();
        return reader != null && reader.getNamesLookup() != null && reader.getNamesLookup().getEmbeddedFiles() != null;
    }

    private void extractEmbeddedFiles(String outputDirectory) {
        if (!outputDirectory.endsWith(separator)) {
            outputDirectory = outputDirectory + separator;
        }
        outputDirectory = outputDirectory + this.decode_pdf.getFileName().substring(this.decode_pdf.getFileName().lastIndexOf(separator) + 1, this.decode_pdf.getFileName().lastIndexOf(46)) + separator;
        PdfObjectReader reader = this.decode_pdf.getIO();
        if (reader != null && reader.getNamesLookup() != null) {
            Object[] files = reader.getNamesLookup().getEmbeddedFiles();
            if (reader.getNamesLookup().getEmbeddedFiles() != null) {
                for (int i2 = 1; i2 < files.length; i2 += 2) {
                    int pathEnd;
                    String filename;
                    byte[] filenameBytes = ((PdfObject)files[i2]).getTextStreamValueAsByte(9494);
                    if (filenameBytes == null) {
                        filenameBytes = ((PdfObject)files[i2]).getTextStreamValueAsByte(22);
                    }
                    if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                        filename = filename.substring(pathEnd + 1);
                    }
                    File outputFile = new File(outputDirectory + filename);
                    try {
                        PdfObject efObj = ((PdfObject)files[i2]).getDictionary(5398);
                        reader.checkResolved(efObj);
                        PdfObject fileObj = efObj.getDictionary(22);
                        reader.checkResolved(fileObj);
                        byte[] stream = fileObj.getDecodedStream();
                        if (!outputFile.exists()) {
                            boolean created;
                            if (!outputFile.getParentFile().exists()) {
                                outputFile.getParentFile().mkdirs();
                            }
                            if (!(created = outputFile.createNewFile())) {
                                throw new IOException("Unable to create file " + outputFile.getAbsolutePath());
                            }
                        }
                        ObjectStore.writeToFile(outputDirectory + filename, stream);
                        continue;
                    }
                    catch (IOException e2) {
                        LogWriter.writeLog(e2);
                    }
                }
            }
        }
    }

    private static void extractAllFilesFromPdf(String inputDir, String outputDir) throws PdfException {
        File[] files;
        File input = new File(inputDir);
        if (input.exists() && (files = input.isDirectory() ? input.listFiles(pathname -> !pathname.isDirectory()) : new File[]{input}) != null) {
            for (File filename : files) {
                ExtractEmbeddedFiles extract = new ExtractEmbeddedFiles(filename.getAbsolutePath());
                if (extract.openPDFFile()) {
                    if (extract.containsEmbeddedFiles()) {
                        extract.extractEmbeddedFiles(outputDir);
                    }
                    if (extract.containsFilesAttachments()) {
                        extract.extractFileAttachments(outputDir);
                    }
                }
                extract.closePDFfile();
            }
        }
    }

    public void showEmbeddedFilesDetails() {
        Object[] files = this.decode_pdf.getIO().getNamesLookup().getEmbeddedFiles();
        for (int i2 = 0; i2 != files.length; i2 += 2) {
            PdfObject pObj = (PdfObject)files[i2 + 1];
            ExtractEmbeddedFiles.showFileDetails(pObj, this.decode_pdf.getIO());
        }
    }

    public void showFileAttachmentDetails() {
        Object[] tempForms = this.decode_pdf.getFormRenderer().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        if (tempForms != null) {
            FormObject[] formArray = (FormObject[])Arrays.copyOf(tempForms, tempForms.length, FormObject[].class);
            ArrayList<FormObject> fileAttachments = new ArrayList<FormObject>();
            for (FormObject form : formArray) {
                if (form.getNameAsConstant(1147962727) != -1113876231) continue;
                fileAttachments.add(form);
            }
            if (!fileAttachments.isEmpty()) {
                for (int i2 = 0; i2 != fileAttachments.size(); ++i2) {
                    PdfObject pObj = ((FormObject)fileAttachments.get(i2)).getDictionary(5667);
                    ExtractEmbeddedFiles.showFileDetails(pObj, this.decode_pdf.getIO());
                }
            }
        }
    }

    private static void showFileDetails(PdfObject pObj, PdfObjectReader reader) {
        int pathEnd;
        String filename;
        reader.checkResolved(pObj);
        byte[] filenameBytes = pObj.getTextStreamValueAsByte(9494);
        if (filenameBytes == null) {
            filenameBytes = pObj.getTextStreamValueAsByte(22);
        }
        if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
            filename = filename.substring(pathEnd + 1);
        }
        System.out.println("Name : " + filename);
        System.out.println("Ref : " + pObj.getObjectRefAsString());
        filenameBytes = pObj.getTextStreamValueAsByte(22);
        filename = StringUtils.getTextString(filenameBytes, false);
        System.out.println("F : " + filename);
        System.out.println("TYPE : " + PdfDictionary.showAsConstant(pObj.getNameAsConstant(608780341)));
        if (pObj.getDictionary(5398) != null) {
            System.out.println("EF : " + pObj.getDictionary(5398).getObjectRefAsString());
        } else {
            System.out.println("EF : ");
        }
        filenameBytes = pObj.getTextStreamValueAsByte(9494);
        filename = StringUtils.getTextString(filenameBytes, false);
        System.out.println("UF : " + filename);
        byte[] descBytes = pObj.getTextStreamValueAsByte(339034931);
        if (descBytes != null) {
            System.out.println("Desc : " + StringUtils.getTextString(descBytes, false));
        } else {
            System.out.println("Desc : ");
        }
        if (pObj.getDictionary(944061782) != null) {
            System.out.println("Thumb : " + pObj.getDictionary(944061782).getObjectRefAsString());
        } else {
            System.out.println("Thumb : ");
        }
        System.out.println();
    }
}

