/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jpedal.examples.PdfUtilities;
import org.jpedal.examples.images.ConvertPagesToImages;
import org.jpedal.examples.images.ExtractClippedImages;
import org.jpedal.examples.images.ExtractImages;
import org.jpedal.examples.printing.PrintPdfPages;
import org.jpedal.examples.splash.JPedalSplash;
import org.jpedal.examples.text.ExtractOutline;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.CopyOutline;
import org.jpedal.exception.PdfException;
import org.jpedal.render.output.json.Json;
import org.jpedal.render.output.json.JsonObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JPedal {
    private static final String version;
    public static final String JPEDAL_TITLE;
    public static final String JPEDAL_INFO = "Features:\n\tPDF Viewer\n\tPDF Inspector\n\tConvert Pages to Images\n\tExtract Text\n\tExtract Embedded Images\n\tExtract Metadata\n\tPrint PDF\n\nHomepage: https://www.idrsolutions.com/jpedal\nJavadoc: https://files.idrsolutions.com/maven/site/jpedal/apidocs/";

    private JPedal() {
    }

    public static String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JPedal.showHelp();
        } else {
            String actionName = args[0];
            if (actionName.startsWith("--")) {
                JPedal.doAction(actionName.substring(2), JPedal.removeFirstValue(args));
            } else {
                System.out.println("Not a recognised command. Supported Actions (prefixed by --) are: " + Arrays.toString((Object[])Action.values()));
            }
        }
    }

    private static void doAction(String actionAsString, String[] args) {
        Action action;
        try {
            action = Action.valueOf(actionAsString.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            action = null;
        }
        if (action == null) {
            System.out.println("JPedal action '" + actionAsString + "' not recognised. Available actions are: " + Arrays.toString((Object[])Action.values()));
        } else {
            JPedal.doAction(action, args);
        }
    }

    public static void doAction(Action action, String[] args) {
        if (action == null) {
            System.out.println("JPedal action must not be null. Available actions are: " + Arrays.toString((Object[])Action.values()));
        } else {
            switch (action) {
                case VIEW: 
                case INSPECT: {
                    if (args.length > 1) {
                        if (StringUtils.isNumber(args[1])) {
                            System.setProperty("org.jpedal.page", args[1]);
                        } else {
                            LogWriter.writeLog("Second input must be a number.");
                        }
                    }
                    if (action == Action.INSPECT) {
                        Viewer.debug(args);
                        break;
                    }
                    Viewer.main(args);
                    break;
                }
                case CONVERT: {
                    ConvertPagesToImages.main(args);
                    break;
                }
                case HELP: {
                    JPedal.showHelp();
                    break;
                }
                case PRINT: {
                    PrintPdfPages.main(args);
                    break;
                }
                case EXTRACTIMAGES: {
                    ExtractImages.main(args);
                    break;
                }
                case EXTRACTCLIPPEDIMAGES: {
                    ExtractClippedImages.main(args);
                    break;
                }
                case METADATA: {
                    JPedal.getMetaData(args);
                    break;
                }
                case COPYOUTLINE: {
                    CopyOutline.main(args);
                }
            }
        }
    }

    private static void getMetaData(String[] args) {
        if (args != null && args.length > 0) {
            try {
                String file = args[0];
                PdfUtilities utilities = new PdfUtilities(file);
                utilities.openPDFFile();
                String[] dataTypes = args.length > 1 ? JPedal.removeDuplicateValues(JPedal.removeFirstValue(args)) : new String[]{"fields", "xml", "pagesizes", "outline", "fonts", "pagecount"};
                JsonObject result = Json.object();
                block20: for (String dataType : dataTypes) {
                    switch (dataType.toLowerCase()) {
                        case "fields": {
                            result.add("Fields", JPedal.getMetadataFields(utilities));
                            continue block20;
                        }
                        case "xml": {
                            result.add("XML", JPedal.getXML(utilities));
                            continue block20;
                        }
                        case "pagesizes": {
                            result.add("PageSizes", JPedal.getPageSizes(utilities));
                            continue block20;
                        }
                        case "outline": {
                            result.add("Outline", JPedal.getOutline(file));
                            continue block20;
                        }
                        case "fonts": {
                            result.add("FontsPerPage", JPedal.getFonts(utilities));
                            continue block20;
                        }
                        case "xobjects": {
                            result.add("XObjectsPerPage", JPedal.getXObjects(utilities));
                            continue block20;
                        }
                        case "pagecount": {
                            result.add("PageCount", utilities.getPageCount());
                        }
                    }
                }
                utilities.closePDFfile();
                System.out.println(result);
            }
            catch (PdfException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        } else {
            System.out.println("--metadata should have at least one input the first should be the filename of a PDF to open.");
        }
    }

    public static JsonObject getFonts(PdfUtilities utilities) {
        JsonObject result = Json.object();
        for (int i2 = 1; i2 <= utilities.getPageCount(); ++i2) {
            ArrayList<JsonObject> fonts = new ArrayList<JsonObject>();
            String fontList = utilities.getFontDataForPage(i2);
            StringTokenizer tokenizer = new StringTokenizer(fontList, "\n");
            while (tokenizer.hasMoreTokens()) {
                JsonObject font = Json.object();
                String fontString = tokenizer.nextToken().replaceAll("\\s+", " ");
                String[] fontData = fontString.split(" ");
                font.add("font_id", fontData[0]);
                font.add("font_name", fontData[1]);
                font.add("font_type", fontData[2]);
                if (fontData.length > 3) {
                    font.add("font_embedded", "embedded".equalsIgnoreCase(fontData[3]));
                }
                fonts.add(font);
            }
            result.add(Integer.toString(i2), fonts.toArray(new JsonObject[0]));
        }
        return result;
    }

    public static JsonObject getXObjects(PdfUtilities utilities) {
        JsonObject result = Json.object();
        for (int i2 = 1; i2 <= utilities.getPageCount(); ++i2) {
            ArrayList<JsonObject> XObjects = new ArrayList<JsonObject>();
            String XObjectsList = utilities.getXObjectsForPage(i2);
            StringTokenizer tokenizer = new StringTokenizer(XObjectsList, "\n");
            while (tokenizer.hasMoreTokens()) {
                JsonObject xobject = Json.object();
                String xobjectString = tokenizer.nextToken().replaceAll("\\s+", " ");
                String[] fontData = xobjectString.split(" ");
                xobject.add("font_id", xobjectString);
                xobject.add("width", fontData[1]);
                xobject.add("height", fontData[2]);
                XObjects.add(xobject);
            }
            result.add(Integer.toString(i2), XObjects.toArray(new JsonObject[0]));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject[] getOutline(String file) {
        ExtractOutline extracter = new ExtractOutline(file);
        try {
            NodeList children;
            extracter.openPDFFile();
            Document doc = extracter.getPDFTextOutline();
            if (doc.hasChildNodes() && (children = doc.getChildNodes()).getLength() > 0) {
                JsonObject[] jsonObjectArray = JPedal.getNodeListAsJsonArray(children);
                return jsonObjectArray;
            }
        }
        catch (PdfException e2) {
            LogWriter.writeLog(e2);
        }
        finally {
            extracter.closePDFfile();
        }
        return null;
    }

    static JsonObject[] getNodeListAsJsonArray(NodeList list) {
        ArrayList<JsonObject> jsonNodes = new ArrayList<JsonObject>();
        for (int idx = 0; idx < list.getLength(); ++idx) {
            jsonNodes.add(JPedal.convertNodeToJson(list.item(idx)));
        }
        return jsonNodes.toArray(new JsonObject[0]);
    }

    private static JsonObject convertNodeToJson(Node node) {
        JsonObject jsonNode = Json.object();
        if (node.getNodeType() == 1) {
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                if (children.getLength() > 0) {
                    JsonObject[] jsonChildren = JPedal.getNodeListAsJsonArray(children);
                    jsonNode.add(node.getNodeName(), jsonChildren);
                }
            } else if (node.hasAttributes()) {
                NamedNodeMap attributes = node.getAttributes();
                for (int index = 0; index < attributes.getLength(); ++index) {
                    Node att = attributes.item(index);
                    jsonNode.add(att.getNodeName(), att.getTextContent());
                }
            }
        }
        return jsonNode;
    }

    public static JsonObject[] getPageSizes(PdfUtilities utilities) {
        JsonObject[] pages = new JsonObject[utilities.getPageCount()];
        for (int i2 = 1; i2 <= pages.length; ++i2) {
            pages[i2 - 1] = Json.object();
            pages[i2 - 1].add("PageNumber", i2);
            float[] mediaBoxValues = utilities.getPageDimensions(i2, PdfUtilities.PageUnits.Pixels, PdfUtilities.PageSizeType.MediaBox);
            pages[i2 - 1].add("Rotation", (int)mediaBoxValues[4]);
            pages[i2 - 1].add("MediaBox", new float[]{mediaBoxValues[0], mediaBoxValues[1], mediaBoxValues[2], mediaBoxValues[3]});
            float[] cropBoxValues = utilities.getPageDimensions(i2, PdfUtilities.PageUnits.Pixels, PdfUtilities.PageSizeType.CropBox);
            pages[i2 - 1].add("CropBox", new float[]{cropBoxValues[0], cropBoxValues[1], cropBoxValues[2], cropBoxValues[3]});
            float[] realValuesPixels = utilities.getPageDimensions(i2, PdfUtilities.PageUnits.Pixels, PdfUtilities.PageSizeType.CropBox);
            float[] realValuesCMs = utilities.getPageDimensions(i2, PdfUtilities.PageUnits.Centimetres, PdfUtilities.PageSizeType.CropBox);
            float[] realValuesInches = utilities.getPageDimensions(i2, PdfUtilities.PageUnits.Inches, PdfUtilities.PageSizeType.CropBox);
            JsonObject realSize = Json.object();
            realSize.add("Pixels", Arrays.copyOf(realValuesPixels, 4));
            realSize.add("Centimeters", Arrays.copyOf(realValuesCMs, 4));
            realSize.add("Inches", Arrays.copyOf(realValuesInches, 4));
            pages[i2 - 1].add("VisiblePageSizes", realSize);
        }
        return pages;
    }

    public static JsonObject getXML(PdfUtilities utilities) {
        JsonObject result = Json.object();
        result.add("data", utilities.getDocumentPropertyFieldsInXML());
        return result;
    }

    public static JsonObject getMetadataFields(PdfUtilities utilities) {
        JsonObject result = Json.object();
        Map<String, String> fields = utilities.getDocumentPropertyStringValuesAsMap();
        Set<String> keys = fields.keySet();
        for (String key : keys) {
            result.add(key, fields.get(key));
        }
        return result;
    }

    private static String[] removeDuplicateValues(String[] inputValues) {
        int length = inputValues.length;
        if (length <= 1) {
            return inputValues;
        }
        int newLength = 0;
        String[] result = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            if (inputValues[i2] == null) continue;
            for (int j2 = i2 + 1; j2 < length; ++j2) {
                if (!inputValues[i2].equals(inputValues[j2])) continue;
                inputValues[j2] = null;
            }
            result[newLength] = inputValues[i2];
            ++newLength;
        }
        return Arrays.copyOf(result, newLength);
    }

    private static String[] removeFirstValue(String[] inputValues) {
        int newArraySize = inputValues.length - 1;
        String[] outputValues = new String[newArraySize];
        System.arraycopy(inputValues, 1, outputValues, 0, newArraySize);
        return outputValues;
    }

    private static void showHelp() {
        if (System.console() != null || GraphicsEnvironment.isHeadless()) {
            Action[] actions;
            StringBuilder infoString = new StringBuilder().append(JPEDAL_TITLE).append("\n\n").append(JPEDAL_INFO).append("\n\n").append("Available Commands: \n");
            for (Action a10 : actions = Action.values()) {
                infoString.append('\t').append(a10.exampleUsage()).append('\n');
            }
            System.out.print(infoString);
        } else if (!GraphicsEnvironment.isHeadless()) {
            JPedal.showHelpWindow();
        }
    }

    private static void showHelpWindow() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        JFrame jf = new JFrame(JPEDAL_TITLE);
        jf.setDefaultCloseOperation(3);
        jf.setIconImage(new ImageIcon(Objects.requireNonNull(JPedal.class.getResource("/org/jpedal/examples/viewer/res/icon.png"))).getImage());
        ImageIcon logo = new ImageIcon(Objects.requireNonNull(JPedal.class.getResource("/org/jpedal/examples/viewer/res/logo.png")));
        JLabel idrLogo = new JLabel(logo);
        idrLogo.setBorder(new EmptyBorder(10, 10, 10, 10));
        jf.getContentPane().add((Component)idrLogo, "North");
        jf.getContentPane().add((Component)new JPedalSplash(jf), "Center");
        jf.pack();
        jf.setVisible(true);
        jf.setLocationRelativeTo(null);
        jf.setResizable(false);
    }

    static {
        Properties props = new Properties();
        try (InputStream is = JPedal.class.getResourceAsStream("/version.num");){
            if (is != null) {
                try {
                    props.load(is);
                }
                catch (IOException ex) {
                    LogWriter.writeLog("Exception: " + ex.getMessage());
                }
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        String versionSet = props.getProperty("release");
        version = versionSet != null ? versionSet : "@VERSION@";
        JPEDAL_TITLE = String.format("JPedal - Java PDF Library - %s", version);
    }

    public static enum Action {
        VIEW,
        CONVERT,
        HELP,
        PRINT,
        EXTRACTIMAGES,
        EXTRACTCLIPPEDIMAGES,
        METADATA,
        INSPECT,
        COPYOUTLINE;


        public String exampleUsage() {
            switch (this) {
                case VIEW: {
                    return "--view file.pdf [pageNumber]";
                }
                case INSPECT: {
                    return "--inspect file.pdf";
                }
                case CONVERT: {
                    return "--convert inputDir outputDir [outputFormat] [scalingAsFloat] [pageRange]";
                }
                case HELP: {
                    return "--help";
                }
                case PRINT: {
                    return "--print file.pdf printerName [pageNumber]";
                }
                case EXTRACTIMAGES: {
                    return "--extractImages file.pdf outputDir outputFormat";
                }
                case EXTRACTCLIPPEDIMAGES: {
                    return "--extractClippedImages file.pdf outputDir outputFormat (outputHeight subDirectory)...";
                }
                case METADATA: {
                    return "--metadata file.pdf [typeOfData]...";
                }
                case COPYOUTLINE: {
                    return "--copyoutline oldfile.pdf newfile.pdf";
                }
            }
            return "";
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

