/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.Border;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.display.swing.MultiDisplay;
import org.jpedal.display.swing.SwingHelper;
import org.jpedal.display.swing.SwingMultiPageDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

class SwingMultiPageViewer {
    private final Map<Integer, String> pagesDrawn = new HashMap<Integer, String>();
    private final SwingMultiPageDecoder multiPageDecoder;
    private final MultiDisplayOptions multiDisplayOptions;
    private Point corner;
    private Point bottom;
    private Point topPivot;
    private Point cursor;
    private Point topPeak;
    private boolean splitTop;

    SwingMultiPageViewer(MultiDisplayOptions multiDisplayOptions, SwingMultiPageDecoder multiPageDecoder) {
        this.multiDisplayOptions = multiDisplayOptions;
        this.multiPageDecoder = multiPageDecoder;
    }

    public void drawPage(MultiDisplay aThis, AffineTransform viewScaling, AffineTransform displayScaling, Graphics2D g2, int displayView) {
        if (!aThis.isAccelerated()) {
            aThis.calcVisibleArea(aThis.topH, aThis.topW);
        }
        g2.transform(displayScaling);
        boolean canDrawAccelerated = aThis.useAcceleration && !aThis.overRideAcceleration && (aThis.ignoreScalingForAcceleration || aThis.scaling < 2.0f) && aThis.testAcceleratedRendering();
        int[] xReached = this.multiDisplayOptions.getxReached();
        if (canDrawAccelerated) {
            Graphics2D gBB = (Graphics2D)aThis.backBuffer.getGraphics();
            if (aThis.screenNeedsRedrawing) {
                gBB.setColor(aThis.pdf.getBackground());
                gBB.fill(new Rectangle(0, 0, aThis.backBuffer.getWidth(), aThis.backBuffer.getHeight()));
                aThis.screenNeedsRedrawing = false;
            }
            if (aThis.isInitialised && xReached != null) {
                gBB.transform(displayScaling);
                aThis.setDisplacementOnG2(gBB);
                this.drawOtherPages(aThis, aThis.rawAf, viewScaling, gBB, aThis.scaling, true, displayView);
            }
            gBB.dispose();
            if (aThis.backBuffer != null) {
                AffineTransform affBefore = g2.getTransform();
                g2.setTransform(aThis.rawAf);
                g2.setClip(aThis.rawClip);
                g2.setTransform(aThis.rawAf);
                g2.drawImage(aThis.backBuffer, aThis.insetW, aThis.insetH, aThis.pdf);
                g2.setTransform(affBefore);
            }
        } else {
            aThis.accleratedPagesAlreadyDrawn.clear();
            this.drawOtherPages(aThis, aThis.rawAf, viewScaling, g2, aThis.scaling, false, displayView);
        }
    }

    private void translateToPagePosition(Graphics2D g2, MultiDisplay aThis, int pageNo, float scaling, double cropX, double cropY, double pageW, double pageH, int displayView) {
        int[] xReached = this.multiDisplayOptions.getxReached();
        int[] yReached = this.multiDisplayOptions.getyReached();
        double x2 = (double)((float)xReached[pageNo] / scaling) - cropX;
        double y2 = -cropY - (double)((float)yReached[pageNo] / scaling);
        if (displayView == 2 || displayView == 3) {
            y2 -= pageH;
            if (displayView == 2) {
                x2 = aThis.pdf.getDisplayRotation() == 0 || aThis.pdf.getDisplayRotation() == 180 ? (x2 += ((double)aThis.currentOffset.getWidestPageNR() - pageW) / 2.0) : (x2 += ((double)aThis.currentOffset.getWidestPageR() - pageW) / 2.0);
            }
        }
        g2.translate(x2, y2);
    }

    private static void rotateToPagePosition(Graphics2D g2, int cumalativeRotation, float scaling, double cropX, double cropY, double width, double height) {
        AffineTransform aff = g2.getTransform();
        double x2 = aff.getTranslateX() / (double)scaling;
        double y2 = aff.getTranslateY() / (double)scaling;
        if (cumalativeRotation != 0) {
            g2.translate(-x2, -y2);
        }
        switch (cumalativeRotation) {
            case 180: {
                g2.rotate(Math.PI);
                g2.translate(-x2 - width, -y2 - height);
                g2.translate(-2.0 * cropX, -2.0 * cropY);
                break;
            }
            case 270: {
                g2.rotate(1.5707963267948966);
                g2.translate(y2 + width - height, -x2 - width);
                g2.translate(0.0, -2.0 * cropX);
                break;
            }
            case 90: {
                g2.rotate(-1.5707963267948966);
                g2.translate(-y2 - width, x2);
                g2.translate(-2.0 * cropY, 0.0);
                break;
            }
        }
    }

    private static void rotateToPagePositionForContinuous(Graphics2D g2, int cumalativeRotation, double width, double height, double cropX, double cropY) {
        switch (cumalativeRotation) {
            case 180: {
                g2.translate(cropX, cropY);
                g2.rotate(Math.PI);
                g2.translate(-width, -height);
                g2.translate(-cropX, -cropY);
                break;
            }
            case 270: {
                g2.translate(cropX, cropY);
                g2.rotate(1.5707963267948966);
                g2.translate(0.0, -width);
                g2.translate(-cropY, -cropX);
                break;
            }
            case 90: {
                g2.translate(cropX, cropY);
                g2.rotate(-1.5707963267948966);
                g2.translate(-height, 0.0);
                g2.translate(-cropY, -cropX);
                break;
            }
        }
    }

    private void drawOtherPages(MultiDisplay aThis, AffineTransform original, AffineTransform viewScaling, Graphics2D g2, float scaling, boolean isAccelerated, int displayView) {
        int endPage;
        int pageCount = aThis.pageData.getPageCount();
        int startPage = this.multiDisplayOptions.getStartViewPage();
        if (startPage > (endPage = this.multiDisplayOptions.getEndViewPage())) {
            return;
        }
        if (displayView != 2 && pageCount == 2) {
            ++endPage;
        }
        AffineTransform old = g2.getTransform();
        Shape oldClip = g2.getClip();
        int[] pageW = this.multiDisplayOptions.getPageW();
        int[] pageH = this.multiDisplayOptions.getPageH();
        for (int j2 = startPage; j2 < endPage + 1 && j2 <= pageCount; ++j2) {
            if (isAccelerated && aThis.accleratedPagesAlreadyDrawn.get(j2) != null) continue;
            DynamicVectorRenderer otherPage = aThis.multiPageDecoder.getCurrentPageView(j2);
            int cumalativeRotation = aThis.displayRotation + aThis.pageData.getRotation(j2);
            if (cumalativeRotation >= 360) {
                cumalativeRotation -= 360;
            }
            float dx = (float)aThis.pageData.getScaledCropBoxX(j2) / scaling;
            float dy = (float)aThis.pageData.getScaledCropBoxY(j2) / scaling;
            if (cumalativeRotation == 90 || cumalativeRotation == 270) {
                float temp = dx;
                dx = dy;
                dy = temp;
            }
            if (otherPage == null) continue;
            g2.setTransform(original);
            if (!isAccelerated) {
                g2.setClip(aThis.pdf.getVisibleRect());
            }
            g2.setTransform(old);
            double[] cropRect = new double[]{dx, dy, (float)pageW[j2] / scaling, (float)pageH[j2] / scaling};
            this.transformOtherPage(aThis, g2, j2, cropRect, scaling, displayView, cumalativeRotation);
            double[] rect = SwingMultiPageViewer.getOtherPageCropRectangle(aThis, this.multiDisplayOptions, j2, scaling, cumalativeRotation);
            g2.clip(new Rectangle2D.Double(rect[0], rect[1], rect[2], rect[3]));
            otherPage.setG2(g2);
            SwingMultiPageViewer.drawOtherPage(otherPage, aThis, viewScaling, j2);
            if (aThis.pdf.isOpen()) {
                g2.scale(1.0, -1.0);
                g2.translate(rect[0], -(rect[3] + rect[1]));
                SwingHelper.scaleDisplay(g2, 0, 0, (int)rect[2], (int)rect[3]);
            }
            this.pagesDrawn.put(j2, "x");
            if (isAccelerated) {
                aThis.accleratedPagesAlreadyDrawn.put(j2, "x");
            }
            g2.setTransform(old);
            g2.setClip(oldClip);
        }
    }

    private void transformOtherPage(MultiDisplay aThis, Graphics2D g2, int page, double[] rect, float scaling, int displayView, int cumalativeRotation) {
        this.translateToPagePosition(g2, aThis, page, scaling, rect[0], rect[1], rect[2], rect[3], displayView);
        switch (displayView) {
            case 2: 
            case 3: {
                SwingMultiPageViewer.rotateToPagePositionForContinuous(g2, cumalativeRotation, rect[2], rect[3], rect[0], rect[1]);
                break;
            }
            default: {
                SwingMultiPageViewer.rotateToPagePosition(g2, cumalativeRotation, scaling, rect[0], rect[1], rect[2], rect[3]);
            }
        }
        aThis.multiPageDecoder.getCurrentPageView(page).setScaling(scaling);
    }

    private static double[] getOtherPageCropRectangle(MultiDisplay aThis, MultiDisplayOptions multiDisplayOptions, int page, float scaling, int cumalativeRotation) {
        int[] pageW = multiDisplayOptions.getPageW();
        int[] pageH = multiDisplayOptions.getPageH();
        double[] rectangle = new double[]{(float)aThis.pageData.getScaledCropBoxX(page) / scaling, (float)aThis.pageData.getScaledCropBoxY(page) / scaling, (float)pageW[page] / scaling, (float)pageH[page] / scaling};
        if (cumalativeRotation == 90 || cumalativeRotation == 270) {
            double tmp = rectangle[2];
            rectangle[2] = rectangle[3];
            rectangle[3] = tmp;
        }
        return rectangle;
    }

    private static void drawOtherPage(DynamicVectorRenderer otherPage, MultiDisplay aThis, AffineTransform viewScaling, int page) {
        if (aThis.areas != null) {
            int[][] rectParams = (int[][])aThis.areas.get(page);
            if (rectParams != null) {
                Rectangle[] rects = new Rectangle[rectParams.length];
                for (int k2 = 0; k2 < rects.length; ++k2) {
                    rects[k2] = new Rectangle(rectParams[k2][0], rectParams[k2][1], rectParams[k2][2], rectParams[k2][3]);
                }
                otherPage.paint(rects, viewScaling, null);
            } else {
                otherPage.paint(null, viewScaling, null);
            }
        } else {
            otherPage.paint(null, viewScaling, null);
        }
    }

    public void drawBorder(int displayView, Graphics2D g2, int pageCount, MultiDisplay aThis) {
        Border myBorder = aThis.pdf.getPDFBorder();
        int startPage = this.multiDisplayOptions.getStartViewPage();
        int endPage = this.multiDisplayOptions.getEndViewPage();
        if (startPage == 0) {
            return;
        }
        if (displayView == 2 || displayView == 3) {
            startPage = 1;
            endPage = pageCount;
        }
        if (aThis.rawAf != null) {
            g2.setTransform(aThis.rawAf);
        }
        g2.setClip(aThis.rawClip);
        if (displayView != 4 && startPage > 1) {
            --startPage;
            if (pageCount == 2) {
                ++endPage;
            }
        }
        int displacementPage = 1;
        if (displayView != 2) {
            --displacementPage;
        }
        int[] xReached = this.multiDisplayOptions.getxReached();
        int[] yReached = this.multiDisplayOptions.getyReached();
        int[] pageW = this.multiDisplayOptions.getPageW();
        int[] pageH = this.multiDisplayOptions.getPageH();
        g2.translate(-xReached[displacementPage] + aThis.insetW, -yReached[displacementPage] + aThis.insetH);
        for (int i2 = startPage; i2 < endPage + 1 && i2 != xReached.length; ++i2) {
            AffineTransform aff = SwingMultiPageViewer.getAffineTransform(displayView, g2, pageCount, aThis, pageW, i2);
            if (this.pagesDrawn.get(i2) == null && aThis.accleratedPagesAlreadyDrawn.get(i2) == null) {
                try {
                    BufferedImage facingDragTempLeftImg = this.multiPageDecoder.getfacingDragTempLeftImg();
                    BufferedImage facingDragTempRightImg = this.multiPageDecoder.getfacingDragTempRightImg();
                    if (displayView == 4 && this.multiDisplayOptions.isTurnoverOn() && facingDragTempLeftImg != null) {
                        this.drawFacingTurnover(g2, aThis, xReached, yReached, pageW, pageH, i2, facingDragTempLeftImg, facingDragTempRightImg);
                    } else {
                        g2.setPaint(aThis.options.getNonDrawnPageColor());
                        g2.fillRect(xReached[i2], yReached[i2], pageW[i2], pageH[i2]);
                    }
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
            if (aThis.pdf.getPages().isBorderPresent() && pageW[i2] > 0 && pageH[i2] > 0 && myBorder != null) {
                if (displayView != 4 || !this.multiDisplayOptions.isTurnoverOn() || aThis.pdf.getPdfPageData().hasMultipleSizes() || pageCount == 2) {
                    myBorder.paintBorder(aThis.pdf, g2, xReached[i2] - myBorder.getBorderInsets((Component)aThis.pdf).left, yReached[i2] - myBorder.getBorderInsets((Component)aThis.pdf).bottom, pageW[i2] + myBorder.getBorderInsets((Component)aThis.pdf).left + myBorder.getBorderInsets((Component)aThis.pdf).right, pageH[i2] + myBorder.getBorderInsets((Component)aThis.pdf).bottom + myBorder.getBorderInsets((Component)aThis.pdf).top);
                } else if (this.multiDisplayOptions.isTurnoverOn()) {
                    this.drawTurnOver(g2, aThis, myBorder, pageW, pageH, i2);
                }
            }
            if (aff == null) continue;
            g2.setTransform(aff);
        }
    }

    private static AffineTransform getAffineTransform(int displayView, Graphics2D g2, int pageCount, MultiDisplay aThis, int[] pageW, int i2) {
        AffineTransform aff = null;
        if (displayView == 2) {
            aff = SwingMultiPageViewer.setContinuousBorder(g2, aThis, pageW, i2);
        } else if ((displayView == 3 || displayView == 4) && pageCount > 1) {
            aff = g2.getTransform();
        }
        return aff;
    }

    private void drawFacingTurnover(Graphics2D g2, MultiDisplay aThis, int[] xReached, int[] yReached, int[] pageW, int[] pageH, int i2, BufferedImage facingDragTempLeftImg, BufferedImage facingDragTempRightImg) {
        if (this.multiPageDecoder.getFacingDragTempRightNo() == i2) {
            g2.drawImage(facingDragTempRightImg, xReached[i2], yReached[i2], pageW[i2], pageH[i2], null);
        } else if (this.multiPageDecoder.getFacingDragTempLeftNo() == i2) {
            g2.drawImage(facingDragTempLeftImg, xReached[i2], yReached[i2], pageW[i2], pageH[i2], null);
        } else {
            g2.setPaint(aThis.options.getNonDrawnPageColor());
            g2.fillRect(xReached[i2], yReached[i2], pageW[i2], pageH[i2]);
        }
    }

    private void drawTurnOver(Graphics2D g2, MultiDisplay aThis, Border myBorder, int[] pageW, int[] pageH, int i2) {
        int width = pageW[i2] * 2;
        int leftPage = this.multiDisplayOptions.isSeparateCover() ? i2 / 2 * 2 : i2 - (1 - (i2 & 1));
        if (leftPage == 0) {
            leftPage = 1;
            width = pageW[leftPage];
        }
        if (i2 == aThis.pdf.getPageCount() && (this.multiDisplayOptions.isSeparateCover() ? (i2 & 1) != 1 : (i2 & 1) != 0)) {
            width = pageW[i2];
        }
        if (leftPage == i2) {
            myBorder.paintBorder(aThis.pdf, g2, this.multiDisplayOptions.getxReached(leftPage) - myBorder.getBorderInsets((Component)aThis.pdf).left, this.multiDisplayOptions.getyReached(leftPage) - myBorder.getBorderInsets((Component)aThis.pdf).bottom, width + myBorder.getBorderInsets((Component)aThis.pdf).left + myBorder.getBorderInsets((Component)aThis.pdf).right, pageH[leftPage] + myBorder.getBorderInsets((Component)aThis.pdf).bottom + myBorder.getBorderInsets((Component)aThis.pdf).top);
        }
        g2.setPaint(Color.BLACK);
        g2.drawLine(this.multiDisplayOptions.getxReached(leftPage) + pageW[leftPage], this.multiDisplayOptions.getyReached(leftPage), this.multiDisplayOptions.getxReached(leftPage) + pageW[leftPage], this.multiDisplayOptions.getyReached(leftPage) + pageH[leftPage] - 1);
    }

    private static AffineTransform setContinuousBorder(Graphics2D g2, MultiDisplay aThis, int[] pageW, int i2) {
        AffineTransform aff = g2.getTransform();
        int diff = aThis.displayRotation == 0 || aThis.displayRotation == 180 ? (int)(((float)aThis.currentOffset.getWidestPageNR() * aThis.scaling - (float)pageW[i2]) / 2.0f) : (int)(((float)aThis.currentOffset.getWidestPageR() * aThis.scaling - (float)pageW[i2]) / 2.0f);
        g2.translate(diff, 0);
        return aff;
    }

    private static boolean doesUnderPageExist(MultiDisplay aThis, Graphics2D g2, MultiDisplayOptions multiDisplayOptions, float pageW, float pageH, boolean dragLeft, boolean dragTop, Point corner) {
        boolean underPageExists;
        if (dragLeft) {
            if (dragTop) {
                g2.translate(corner.x, corner.y);
            } else {
                g2.translate((double)corner.x, (float)corner.y - pageH);
            }
            underPageExists = aThis.pageNumber - 2 > 0;
        } else {
            if (dragTop) {
                g2.translate((float)corner.x - pageW, (double)corner.y);
            } else {
                g2.translate((float)corner.x - pageW, (float)corner.y - pageH);
            }
            int forwardUnderPage = aThis.pageNumber + 2;
            if (multiDisplayOptions.isSeparateCover() ? forwardUnderPage % 2 == 0 : forwardUnderPage % 2 == 1) {
                ++forwardUnderPage;
            }
            underPageExists = forwardUnderPage <= aThis.pdf.getPageCount();
        }
        return underPageExists;
    }

    private boolean drawUnderPage(MultiDisplay aThis, Graphics2D g2, SwingGUI gui, float pageW, float pageH, boolean dragLeft, boolean dragTop, Point corner, Point bottom, Point topPivot, boolean splitTop, Rectangle clip, AffineTransform none) {
        boolean underPageExists = SwingMultiPageViewer.doesUnderPageExist(aThis, g2, this.multiDisplayOptions, pageW, pageH, dragLeft, dragTop, corner);
        if (underPageExists) {
            SwingMultiPageViewer.drawCachedVersionOfPage(g2, (int)pageW, (int)pageH, dragLeft, this.multiPageDecoder, 0, 3);
        } else {
            this.fillBlankOut(g2, aThis.pdf.getBackground(), dragLeft, dragTop, splitTop, none, clip);
            if (aThis.pdf.useNewGraphicsMode() && aThis.pdf.getPages().isBorderPresent() && gui != null) {
                double length = Math.hypot(bottom.getX() - topPivot.getX(), bottom.getY() - topPivot.getY());
                AffineTransform at2 = new AffineTransform();
                at2.translate(topPivot.getX(), topPivot.getY());
                if (dragLeft) {
                    at2.rotate(-Math.atan2(bottom.getX() - topPivot.getX(), bottom.getY() - topPivot.getY()));
                    if (!dragTop) {
                        at2.rotate(Math.PI);
                        at2.translate(0.0, -length);
                    }
                } else {
                    at2.rotate(-Math.atan2(bottom.getX() - topPivot.getX(), bottom.getY() - topPivot.getY()));
                    if (dragTop) {
                        at2.rotate(Math.PI);
                        at2.translate(0.0, -length);
                    }
                }
                g2.setTransform(at2);
                g2.setPaint(new GradientPaint(0.0f, 0.0f, gui.getGlowInnerColor(), gui.getGlowThickness(), 0.0f, gui.getGlowOuterColor()));
                g2.fillRect(0, 0, gui.getGlowThickness(), (int)length);
                this.drawCornerGlow(gui, aThis, g2, dragLeft, dragTop, splitTop);
            }
        }
        return underPageExists;
    }

    private void fillBlankOut(Graphics2D g2, Color background, boolean dragLeft, boolean dragTop, boolean splitTop, AffineTransform none, Rectangle clip) {
        float clipBase;
        float clipTop;
        float clipEdge = dragLeft ? 0.0f : (float)clip.getWidth();
        if (dragTop) {
            clipTop = 0.0f;
            clipBase = (float)clip.getHeight();
        } else {
            clipTop = (float)clip.getHeight();
            clipBase = 0.0f;
        }
        GeneralPath blankOut = new GeneralPath();
        blankOut.moveTo(this.topPivot.x, this.topPivot.y);
        blankOut.lineTo(this.bottom.x, this.bottom.y);
        blankOut.lineTo(this.bottom.x, clipTop);
        blankOut.lineTo(clipEdge, clipTop);
        if (splitTop) {
            blankOut.lineTo(clipEdge, clipBase);
            blankOut.lineTo(this.topPivot.x, clipBase);
        } else {
            blankOut.lineTo(clipEdge, this.topPivot.y);
        }
        blankOut.closePath();
        g2.setTransform(none);
        g2.setClip(clip);
        g2.clip(blankOut);
        g2.setPaint(background);
        g2.fill(blankOut);
    }

    private void drawCornerGlow(SwingGUI gui, MultiDisplay aThis, Graphics2D g2, boolean dragLeft, boolean dragTop, boolean splitTop) {
        double yGlowGap;
        double prop;
        double xGlowGap;
        if (dragLeft) {
            xGlowGap = -gui.getGlowThickness();
            prop = (Math.atan2(this.bottom.getX() - this.topPivot.getX(), this.bottom.getY() - this.topPivot.getY()) / Math.PI - 0.5) * -2.0;
        } else {
            xGlowGap = gui.getGlowThickness();
            prop = (-Math.atan2(this.bottom.getX() - this.topPivot.getX(), this.bottom.getY() - this.topPivot.getY()) / Math.PI - 0.5) * -2.0;
        }
        if (dragTop) {
            prop = -prop;
            yGlowGap = -gui.getGlowThickness();
            if (prop < 0.0) {
                prop = 1.0;
            }
        } else {
            yGlowGap = gui.getGlowThickness();
        }
        Point a10 = new Point((int)(this.topPivot.getX() + xGlowGap), (int)this.topPivot.getY());
        Point b2 = new Point((int)((double)((int)this.topPivot.getX()) + prop * xGlowGap), (int)(this.topPivot.getY() + (1.0 - prop) * yGlowGap));
        SwingMultiPageViewer.paintCornerGlow(g2, 1.0f, this.topPivot, a10, b2, aThis.pdf);
        if (splitTop) {
            SwingMultiPageViewer.paintCornerGlow(g2, 1.0f, this.topPivot, new Point((int)this.topPivot.getX(), (int)(this.topPivot.getY() - yGlowGap)), a10, aThis.pdf);
        }
        b2.x = (int)(this.bottom.getX() + ((double)b2.x - this.topPivot.getX()));
        b2.y = (int)(this.bottom.getY() + ((double)b2.y - this.topPivot.getY()));
        a10.x = (int)this.bottom.getX();
        a10.y = (int)(this.bottom.getY() + yGlowGap);
        SwingMultiPageViewer.paintCornerGlow(g2, 1.0f, this.bottom, a10, b2, aThis.pdf);
    }

    private static void drawCachedVersionOfPage(Graphics2D g2, int pageW, int pageH, boolean dragLeft, SwingMultiPageDecoder multiPageDecoder, int i2, int i22) {
        try {
            BufferedImage[] facingDragCachedImages = multiPageDecoder.getFacingDragImages();
            if (dragLeft && facingDragCachedImages[i2] != null) {
                g2.drawImage(facingDragCachedImages[i2], 0, 0, pageW - 1, pageH - 1, null);
            } else if (!dragLeft && facingDragCachedImages[i22] != null) {
                g2.drawImage(facingDragCachedImages[i22], 0, 0, pageW - 1, pageH - 1, null);
            } else {
                g2.setPaint(Color.WHITE);
                g2.fillRect(0, 0, pageW, pageH);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    private static void paintCornerGlow(Graphics2D g2, float opacity, Point corner, Point a10, Point b2, PdfDecoderInt pdf) {
        if (opacity <= 0.0f) {
            return;
        }
        AffineTransform oldTransform = g2.getTransform();
        Shape oldClip = g2.getClip();
        SwingGUI gui = (SwingGUI)pdf.getExternalHandler(11);
        GeneralPath clip = new GeneralPath();
        clip.moveTo((float)corner.getX(), (float)corner.getY());
        clip.lineTo((float)a10.getX(), (float)a10.getY());
        clip.lineTo((float)b2.getX(), (float)b2.getY());
        clip.closePath();
        g2.setTransform(new AffineTransform());
        g2.setClip(pdf.getVisibleRect());
        g2.clip(clip);
        if (gui != null) {
            Color innerC = gui.getGlowInnerColor();
            innerC = new Color(innerC.getRed(), innerC.getGreen(), innerC.getBlue(), (int)(opacity * (float)innerC.getAlpha()));
            g2.setPaint(new GradientPaint((float)corner.getX(), (float)corner.getY(), innerC, (float)((a10.getX() + b2.getX()) / 2.0), (float)((a10.getY() + b2.getY()) / 2.0), gui.getGlowOuterColor()));
        }
        g2.fill(clip);
        g2.setTransform(oldTransform);
        g2.setClip(oldClip);
    }

    private void setFacingCornerPoint(boolean dragLeft, boolean dragTop, Rectangle visibleRect, float pageW, float pageH, MultiDisplay aThis) {
        this.corner = new Point();
        this.corner.x = dragLeft ? (int)(visibleRect.getWidth() / 2.0 - (double)pageW) : (int)(visibleRect.getWidth() / 2.0 + (double)pageW);
        this.corner.y = aThis.pdf.getInsetH();
        if (!dragTop) {
            this.corner.y = (int)((float)this.corner.y + pageH);
        }
    }

    private void setFacingBottomPoint(Point mid, boolean dragLeft, boolean keptAttached, double shift, double gradient) {
        this.bottom = new Point();
        this.bottom.x = dragLeft ? (int)((double)this.corner.x + ((double)mid.x + 1.0 / gradient * (double)(-mid.y))) : (int)((double)this.corner.x - ((double)mid.x + 1.0 / gradient * (double)mid.y));
        this.bottom.y = this.corner.y;
        if (keptAttached) {
            this.bottom.x = this.corner.x + (int)shift;
        }
    }

    private void setFacingTopPivotAndPeak(boolean dragLeft, boolean dragTop, float pageW, float pageH, Point mid, double gradient) {
        int edgeH;
        this.topPivot = new Point();
        this.topPeak = new Point();
        if (dragLeft) {
            if ((float)this.bottom.x > (float)this.corner.x + pageW) {
                this.bottom.x = (int)((float)this.corner.x + pageW);
            }
            edgeH = (int)((double)this.corner.y - ((double)mid.y + -gradient * (double)mid.x));
        } else {
            if ((float)this.bottom.x < (float)this.corner.x - pageW) {
                this.bottom.x = (int)((float)this.corner.x - pageW);
            }
            edgeH = (int)((double)this.corner.y - ((double)mid.y + gradient * (double)mid.x));
        }
        boolean bl2 = dragTop ? (float)edgeH > (float)this.corner.y + pageH : (this.splitTop = (float)edgeH < (float)this.corner.y - pageH);
        if (this.splitTop) {
            if (dragTop) {
                this.topPivot.y = (int)((float)this.corner.y + pageH);
                this.topPivot.x = (int)((double)this.corner.x + -1.0 / gradient * (double)((float)this.corner.y + pageH - (float)edgeH));
            } else {
                this.topPivot.y = (int)((float)this.corner.y - pageH);
                this.topPivot.x = (int)((double)this.corner.x + -1.0 / gradient * (double)((float)this.corner.y - pageH - (float)edgeH));
            }
            double newGradient = (double)(this.bottom.x - this.cursor.x) / (double)(this.bottom.y - this.cursor.y);
            double scaler = (double)(this.corner.x - this.topPivot.x) / Math.hypot(this.bottom.x - this.cursor.x, this.bottom.y - this.cursor.y);
            if (dragLeft) {
                this.topPeak.y = (int)((double)this.topPivot.y + 1.0 / newGradient * (double)(this.bottom.x - this.cursor.x) * scaler);
                this.topPeak.x = (int)((double)this.topPivot.x + newGradient * (double)(this.bottom.y - this.cursor.y) * scaler);
            } else {
                this.topPeak.y = (int)((double)this.topPivot.y - 1.0 / newGradient * (double)(this.bottom.x - this.cursor.x) * scaler);
                this.topPeak.x = (int)((double)this.topPivot.x - newGradient * (double)(this.bottom.y - this.cursor.y) * scaler);
            }
        } else {
            this.topPivot.y = edgeH;
            this.topPivot.x = this.corner.x;
            this.topPeak.y = edgeH;
            this.topPeak.x = this.corner.x;
        }
    }

    private boolean setFacingDragPoints(DisplayOffsets offsets, Rectangle visibleRect, MultiDisplay aThis) {
        float pageW = this.multiDisplayOptions.getPageW(1);
        float pageH = this.multiDisplayOptions.getPageH(1);
        boolean dragLeft = offsets.getDragLeft();
        boolean dragTop = offsets.getDragTop();
        this.setFacingCornerPoint(dragLeft, dragTop, visibleRect, pageW, pageH, aThis);
        this.cursor = aThis.pdf.getUserOffsets(999);
        if ((dragLeft ? this.cursor.x < this.corner.x : this.cursor.x > this.corner.x) && (dragTop ? this.cursor.y < this.corner.y : this.cursor.y > this.corner.y)) {
            return false;
        }
        if (!dragTop && this.cursor.y >= this.corner.y - 2) {
            this.cursor.y = this.corner.y - 3;
        }
        if (dragTop && this.cursor.y <= this.corner.y + 2) {
            this.cursor.y = this.corner.y + 3;
        }
        if (dragLeft && this.cursor.x <= this.corner.x) {
            this.cursor.x = this.corner.x + 1;
        }
        if (!dragLeft && this.cursor.x > this.corner.x) {
            this.cursor.x = this.corner.x;
        }
        boolean keptAttached = false;
        double shift = dragLeft ? (double)pageW : (double)(-pageW);
        int dist = (int)Math.hypot((double)this.cursor.x - ((double)this.corner.x + shift), this.cursor.y - this.corner.y);
        if ((float)dist > pageW) {
            this.cursor.x = (int)((double)this.cursor.x - ((double)this.corner.x + shift));
            this.cursor.y -= this.corner.y;
            this.cursor.x = (int)((float)this.cursor.x * (pageW / (float)dist));
            this.cursor.y = (int)((float)this.cursor.y * (pageW / (float)dist));
            this.cursor.x = (int)((double)this.cursor.x + ((double)this.corner.x + shift));
            this.cursor.y += this.corner.y;
            keptAttached = true;
        }
        Point mid = new Point();
        mid.x = dragLeft ? (this.cursor.x - this.corner.x) / 2 : (this.corner.x - this.cursor.x) / 2;
        mid.y = (this.corner.y - this.cursor.y) / 2;
        if (this.corner.y - this.cursor.y == 0) {
            ++this.cursor.y;
        }
        double gradient = (float)(this.corner.x - this.cursor.x) / (float)(this.corner.y - this.cursor.y);
        this.setFacingBottomPoint(mid, dragLeft, keptAttached, shift, gradient);
        this.setFacingTopPivotAndPeak(dragLeft, dragTop, pageW, pageH, mid, gradient);
        return true;
    }

    public void drawFacingDrag(Graphics2D g2, Rectangle visibleRect, MultiDisplay aThis) {
        double widthFactor;
        double angleFactor;
        boolean underPageExists;
        AffineTransform none;
        GeneralPath underPage;
        GeneralPath backPage;
        boolean dragTop;
        boolean dragLeft;
        float pageH;
        float pageW;
        block8: {
            SwingGUI gui;
            block9: {
                DisplayOffsets offsets = (DisplayOffsets)aThis.pdf.getExternalHandler(37);
                gui = (SwingGUI)aThis.pdf.getExternalHandler(11);
                pageW = this.multiDisplayOptions.getPageW(1);
                pageH = this.multiDisplayOptions.getPageH(1);
                dragLeft = offsets.getDragLeft();
                dragTop = offsets.getDragTop();
                if (!this.setFacingDragPoints(offsets, visibleRect, aThis)) {
                    return;
                }
                backPage = new GeneralPath();
                backPage.moveTo(this.cursor.x, this.cursor.y);
                backPage.lineTo(this.bottom.x, this.bottom.y);
                backPage.lineTo(this.topPivot.x, this.topPivot.y);
                backPage.lineTo(this.topPeak.x, this.topPeak.y);
                backPage.closePath();
                underPage = new GeneralPath();
                underPage.moveTo(this.topPivot.x, this.topPivot.y);
                underPage.lineTo(this.corner.x, this.topPivot.y);
                underPage.lineTo(this.corner.x, this.corner.y);
                underPage.lineTo(this.bottom.x, this.bottom.y);
                underPage.closePath();
                none = g2.getTransform();
                g2.setTransform(none);
                g2.setClip(visibleRect);
                g2.clip(underPage);
                underPageExists = this.drawUnderPage(aThis, g2, gui, pageW, pageH, dragLeft, dragTop, this.corner, this.bottom, this.topPivot, this.splitTop, visibleRect, none);
                g2.setTransform(none);
                g2.setClip(visibleRect);
                g2.setPaint(Color.BLACK);
                if (underPageExists) {
                    g2.draw(underPage);
                }
                this.drawFacingDragBackPage(g2, dragLeft, dragTop, pageW, pageH, backPage);
                angleFactor = Math.atan2(this.topPivot.y - this.bottom.y, this.topPivot.x - this.bottom.x) / Math.PI + 0.5;
                if (dragTop) {
                    angleFactor = 1.0 - angleFactor;
                }
                if (dragLeft) {
                    angleFactor = -angleFactor;
                }
                if ((widthFactor = 0.5 - Math.hypot(this.cursor.x - this.bottom.x, this.cursor.y - this.bottom.y) / (double)(2.0f * pageW)) < 0.0) {
                    widthFactor = 0.0;
                }
                if (!aThis.pdf.useNewGraphicsMode() || !aThis.pdf.getPages().isBorderPresent()) break block8;
                if (dragLeft && aThis.pageNumber == aThis.pdf.getPageCount() && (!this.multiDisplayOptions.isSeparateCover() ? (aThis.pageNumber & 1) != 0 : (aThis.pageNumber & 1) != 1)) break block9;
                if (dragLeft || aThis.pageCount == 2 || aThis.pageNumber != 1) break block8;
            }
            this.adjustGlowForFacingDrag(g2, angleFactor + widthFactor, gui, none, visibleRect, dragLeft, dragTop, aThis);
        }
        g2.setPaint(Color.BLACK);
        g2.setTransform(none);
        g2.setClip(visibleRect);
        g2.draw(backPage);
        this.drawFacingDragShadows(g2, angleFactor + widthFactor, none, visibleRect, underPageExists, dragLeft, dragTop, pageW + pageH, backPage, underPage);
    }

    private void drawFacingDragBackPage(Graphics2D g2, boolean dragLeft, boolean dragTop, float pageW, float pageH, GeneralPath backPage) {
        g2.clip(backPage);
        g2.translate(this.cursor.x, this.cursor.y);
        if (dragLeft) {
            g2.rotate(Math.atan2(this.cursor.y - this.bottom.y, this.cursor.x - this.bottom.x));
            if (dragTop) {
                g2.translate(-pageW, 0.0);
            } else {
                g2.translate(-pageW, -pageH);
            }
        } else {
            g2.rotate(Math.atan2(this.cursor.y - this.bottom.y, this.cursor.x - this.bottom.x) + Math.PI);
            if (!dragTop) {
                g2.translate(0.0, -pageH);
            }
        }
        SwingMultiPageViewer.drawCachedVersionOfPage(g2, (int)pageW, (int)pageH, dragLeft, this.multiPageDecoder, 1, 2);
    }

    private void drawFacingDragShadows(Graphics2D g2, double angleWidthFactor, AffineTransform none, Rectangle visibleRect, boolean underPageExists, boolean dragLeft, boolean dragTop, float combinedPageWH, GeneralPath backPage, GeneralPath underPage) {
        g2.clip(backPage);
        g2.setPaint(new GradientPaint((float)(angleWidthFactor * 300.0), 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, (float)angleWidthFactor * 0.4f + 0.4f)));
        g2.translate(this.bottom.x, this.bottom.y);
        if (dragLeft ^ dragTop) {
            g2.rotate(Math.atan2(this.topPivot.y - this.bottom.y, this.topPivot.x - this.bottom.x) + 1.5707963267948966);
            g2.fillRect(0, (int)(-combinedPageWH), (int)(angleWidthFactor * 300.0), (int)combinedPageWH);
        } else {
            g2.rotate(Math.atan2(this.topPivot.y - this.bottom.y, this.topPivot.x - this.bottom.x) + -1.5707963267948966);
            g2.fillRect(0, 0, (int)(angleWidthFactor * 300.0), (int)combinedPageWH);
        }
        if (underPageExists) {
            g2.setTransform(none);
            g2.setClip(visibleRect);
            g2.clip(underPage);
            g2.setPaint(new GradientPaint((float)(angleWidthFactor * 150.0), 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, (float)angleWidthFactor * 0.36f + 0.24f)));
            g2.translate(this.bottom.x, this.bottom.y);
            if (dragLeft ^ dragTop) {
                g2.rotate(Math.atan2(this.topPivot.y - this.bottom.y, this.topPivot.x - this.bottom.x) + -1.5707963267948966);
                g2.fillRect(0, 0, (int)(angleWidthFactor * 150.0), (int)combinedPageWH);
            } else {
                g2.rotate(Math.atan2(this.topPivot.y - this.bottom.y, this.topPivot.x - this.bottom.x) + 1.5707963267948966);
                g2.fillRect(0, (int)(-combinedPageWH), (int)(angleWidthFactor * 150.0), (int)combinedPageWH);
            }
        }
    }

    private void adjustGlowForFacingDrag(Graphics2D g2, double angleWidthFactor, SwingGUI gui, AffineTransform none, Rectangle visibleRect, boolean dragLeft, boolean dragTop, MultiDisplay aThis) {
        float transparency = 20.0f * (float)(0.05 - angleWidthFactor);
        if (gui != null && transparency > 0.0f) {
            double prop;
            double xGlowGap;
            Color innerC = gui.getGlowInnerColor();
            innerC = new Color(innerC.getRed(), innerC.getGreen(), innerC.getBlue(), (int)(transparency * (float)innerC.getAlpha()));
            Color outerC = gui.getGlowOuterColor();
            g2.setTransform(none);
            g2.setClip(visibleRect);
            double length = Math.hypot(this.cursor.getX() - this.topPeak.getX(), this.cursor.getY() - this.topPeak.getY());
            AffineTransform at2 = new AffineTransform();
            at2.translate(this.topPeak.getX(), this.topPeak.getY());
            at2.rotate(-Math.atan2(this.cursor.getX() - this.topPeak.getX(), this.cursor.getY() - this.topPeak.getY()));
            if (dragLeft == dragTop) {
                at2.translate(-gui.getGlowThickness(), 0.0);
            }
            g2.setTransform(at2);
            if (dragLeft ^ dragTop) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, innerC, gui.getGlowThickness(), 0.0f, outerC));
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, outerC, gui.getGlowThickness(), 0.0f, innerC));
            }
            g2.fillRect(0, 0, gui.getGlowThickness(), (int)length);
            if (dragLeft) {
                xGlowGap = -gui.getGlowThickness();
                prop = (Math.atan2(this.topPeak.getX() - this.topPivot.getX(), this.topPeak.getY() - this.topPivot.getY()) / Math.PI - 0.5) * 2.0;
            } else {
                xGlowGap = gui.getGlowThickness();
                prop = (-Math.atan2(this.topPeak.getX() - this.topPivot.getX(), this.topPeak.getY() - this.topPivot.getY()) / Math.PI - 0.5) * 2.0;
            }
            double yGlowGap = dragTop ? (double)(-gui.getGlowThickness()) : (double)gui.getGlowThickness();
            Point a10 = new Point((int)(this.topPeak.getX() + prop * xGlowGap), (int)(this.topPeak.getY() - (1.0 - prop) * yGlowGap));
            Point b2 = new Point((int)((double)((int)this.topPeak.getX()) - (1.0 - prop) * xGlowGap), (int)(this.topPeak.getY() - prop * yGlowGap));
            SwingMultiPageViewer.paintCornerGlow(g2, transparency, this.topPeak, a10, b2, aThis.pdf);
            length = Math.hypot(this.cursor.getX() - this.bottom.getX(), this.cursor.getY() - this.bottom.getY());
            at2 = new AffineTransform();
            at2.translate(this.bottom.getX(), this.bottom.getY());
            at2.rotate(-Math.atan2(this.cursor.getX() - this.bottom.getX(), this.cursor.getY() - this.bottom.getY()));
            if (dragLeft ^ dragTop) {
                at2.translate(-gui.getGlowThickness(), 0.0);
            }
            g2.setTransform(at2);
            if (dragLeft ^ dragTop) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, outerC, gui.getGlowThickness(), 0.0f, innerC));
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, innerC, gui.getGlowThickness(), 0.0f, outerC));
            }
            g2.fillRect(0, 0, gui.getGlowThickness(), (int)length);
            a10.x = this.cursor.x + (this.topPeak.x - a10.x);
            a10.y = this.cursor.y + (this.topPeak.y - a10.y);
            b2.x = this.cursor.x + (b2.x - this.topPeak.x);
            b2.y = this.cursor.y + (b2.y - this.topPeak.y);
            SwingMultiPageViewer.paintCornerGlow(g2, transparency, this.cursor, a10, b2, aThis.pdf);
            length = Math.hypot(this.topPeak.getX() - this.topPivot.getX(), this.topPeak.getY() - this.topPivot.getY());
            at2 = new AffineTransform();
            if (dragLeft ^ dragTop) {
                at2.translate(this.topPivot.getX(), this.topPivot.getY());
                at2.rotate(-Math.atan2(this.topPeak.getX() - this.topPivot.getX(), this.topPeak.getY() - this.topPivot.getY()));
            } else {
                at2.translate(this.topPeak.getX(), this.topPeak.getY());
                at2.rotate(-Math.atan2(this.topPivot.getX() - this.topPeak.getX(), this.topPivot.getY() - this.topPeak.getY()));
            }
            g2.setTransform(at2);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, innerC, gui.getGlowThickness(), 0.0f, outerC));
            g2.fillRect(0, 0, gui.getGlowThickness(), (int)length);
        }
    }
}

