/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.swing;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;
import org.jpedal.FileAccess;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.display.swing.MultiDisplay;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.SwingDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

class SwingMultiPageDecoder {
    private final Semaphore semaphore = new Semaphore(1);
    private final SwingGUI gui;
    private Thread worker;
    private final Map<Integer, DynamicVectorRenderer> currentPageViews = new HashMap<Integer, DynamicVectorRenderer>();
    private final FileAccess fileAccess;
    private final PdfObjectReader currentPdfFile;
    private final AcroRenderer formRenderer;
    private int displayView;
    private Map<Integer, DynamicVectorRenderer> cachedPageViews = new WeakHashMap<Integer, DynamicVectorRenderer>();
    private final MultiDisplay display;
    private RenderChangeListener customRenderChangeListener;
    private final BufferedImage[] facingDragCachedImages = new BufferedImage[4];
    private BufferedImage facingDragTempLeftImg;
    private BufferedImage facingDragTempRightImg;
    private int facingDragTempLeftNo;
    private int facingDragTempRightNo;
    private final MultiDisplayOptions multiDisplayOptions;
    private final PdfDecoderInt pdf;
    private final PdfPageData pageData;
    private final DecoderOptions options;
    private final DisplayOffsets offsets;

    SwingMultiPageDecoder(PdfDecoderInt pdf, PdfPageData pageData, MultiDisplay display, MultiDisplayOptions multiDisplayOptions, DynamicVectorRenderer currentDisplay, int pageNumber, FileAccess fileAccess, PdfObjectReader io, AcroRenderer formRenderer, DecoderOptions options) {
        this.gui = pdf.getExternalHandler() == null ? null : (SwingGUI)pdf.getExternalHandler().getExternalHandler(11);
        this.pdf = pdf;
        this.pageData = pageData;
        this.display = display;
        this.multiDisplayOptions = multiDisplayOptions;
        this.fileAccess = fileAccess;
        this.currentPdfFile = io;
        this.formRenderer = formRenderer;
        this.options = options;
        this.offsets = (DisplayOffsets)pdf.getExternalHandler(37);
        if (currentDisplay != null) {
            this.currentPageViews.put(pageNumber, currentDisplay);
        }
    }

    private void setFacingPages(int oldPageNumber) {
        int lp = this.multiDisplayOptions.isSeparateCover() ? oldPageNumber / 2 * 2 : oldPageNumber - (1 - (oldPageNumber & 1));
        if (this.offsets.getDragLeft()) {
            this.facingDragTempLeftImg = this.facingDragCachedImages[0];
            this.facingDragTempLeftNo = lp - 2;
            this.facingDragTempRightImg = this.facingDragCachedImages[1];
            this.facingDragTempRightNo = lp - 1;
        } else {
            this.facingDragTempLeftImg = this.facingDragCachedImages[2];
            this.facingDragTempLeftNo = lp + 2;
            this.facingDragTempRightImg = this.facingDragCachedImages[3];
            this.facingDragTempRightNo = lp + 3;
        }
    }

    private void repaint() {
        Runnable getTextFieldText = this.pdf::repaint;
        SwingUtilities.invokeLater(getTextFieldText);
    }

    private DynamicVectorRenderer getNewDisplay(int pageNumber) {
        return new SwingDisplay(pageNumber, this.pdf.getObjectStore(), false);
    }

    public void decodeOtherPages(int pageNumber, int displayView) {
        this.displayView = displayView;
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        int oldPN = this.multiDisplayOptions.getPageNumber();
        this.multiDisplayOptions.setPageNumber(pageNumber);
        if (displayView == 4 && this.multiDisplayOptions.isTurnoverOn()) {
            this.setFacingPages(oldPN);
        }
        this.facingDragCachedImages[0] = null;
        this.facingDragCachedImages[1] = null;
        this.facingDragCachedImages[2] = null;
        this.facingDragCachedImages[3] = null;
        this.calcDisplayedRange();
        while (this.multiDisplayOptions.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        if (!(this.worker != null && this.worker.getState() != Thread.State.NEW && this.worker.getState() != Thread.State.TERMINATED || this.worker != null && this.multiDisplayOptions.isRunning())) {
            this.startDecodingThread();
        }
    }

    private void startDecodingThread() {
        this.worker = new Thread(() -> {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException ex) {
                LogWriter.writeLog("Exception: " + ex.getMessage());
            }
            try {
                this.decodeOtherPages();
                this.multiDisplayOptions.setRunning(false);
                if (this.customRenderChangeListener != null) {
                    this.customRenderChangeListener.renderingWorkerFinished();
                }
            }
            catch (Exception e2) {
                this.multiDisplayOptions.setRunning(false);
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
            catch (Error err) {
                this.multiDisplayOptions.setRunning(false);
                LogWriter.writeLog("Error: " + err.getMessage());
            }
            finally {
                this.semaphore.release();
            }
        });
        this.worker.setDaemon(true);
        this.multiDisplayOptions.setRunning(true);
        this.worker.start();
    }

    private void decodeOtherPages() {
        int pageCount = this.pageData.getPageCount();
        this.multiDisplayOptions.setIsGeneratingOtherPages(true);
        int page = this.multiDisplayOptions.getStartViewPage();
        int originalStart = this.multiDisplayOptions.getStartViewPage();
        int originalEnd = this.multiDisplayOptions.getEndViewPage() + 1;
        int firstFacing = 1;
        int lastFacing = 1;
        if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4) {
            firstFacing = originalStart - 2;
            lastFacing = firstFacing + 6;
            if (firstFacing < 1) {
                firstFacing = 1;
            }
            if (lastFacing > pageCount + 1) {
                lastFacing = pageCount + 1;
            }
        }
        int facingCount = lastFacing - firstFacing;
        this.resetPageCaches(this.multiDisplayOptions.getStartViewPage(), this.multiDisplayOptions.getEndViewPage() + 1);
        while (this.multiDisplayOptions.isIsGeneratingOtherPages()) {
            if (originalStart != this.multiDisplayOptions.getStartViewPage() && originalEnd != this.multiDisplayOptions.getEndViewPage()) {
                page = this.multiDisplayOptions.getStartViewPage();
                originalEnd = this.multiDisplayOptions.getEndViewPage() + 1;
                if (page == 0) {
                    // empty if block
                }
                originalStart = ++page;
                if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4) {
                    firstFacing = originalStart - 2;
                    lastFacing = firstFacing + 6;
                    if (firstFacing < 1) {
                        firstFacing = 1;
                    }
                    if (lastFacing > pageCount + 1) {
                        lastFacing = pageCount + 1;
                    }
                    facingCount = lastFacing - firstFacing;
                }
                this.resetPageCaches(originalStart, originalEnd);
            }
            if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4 && facingCount == 0 || (!this.multiDisplayOptions.isTurnoverOn() || this.displayView != 4) && page == originalEnd || originalStart > originalEnd) break;
            if (page > 0 && page < this.pdf.getPageCount() + 1) {
                this.decodeMorePages(page);
            }
            if (this.displayView == 4 && this.multiDisplayOptions.isTurnoverOn()) {
                this.storeThumbnailForTurnover(page);
            }
            --facingCount;
            if (!this.multiDisplayOptions.isTurnoverOn() || this.displayView != 4 || ++page != lastFacing) continue;
            page = firstFacing;
        }
    }

    private void storeThumbnailForTurnover(int page) {
        int ref;
        int leftPage = this.multiDisplayOptions.getPageNumber();
        if (this.multiDisplayOptions.isSeparateCover() && (leftPage & 1) == 1) {
            --leftPage;
        }
        if (!this.multiDisplayOptions.isSeparateCover() && (leftPage & 1) == 0) {
            --leftPage;
        }
        if ((ref = page - leftPage + 2) <= 1 || ref >= 4) {
            if (ref > 1) {
                ref -= 2;
            }
            int[] pageW = this.multiDisplayOptions.getPageW();
            int[] pageH = this.multiDisplayOptions.getPageH();
            if (ref < 4 && ref > -1 && this.facingDragCachedImages[ref] == null) {
                this.facingDragCachedImages[ref] = SwingMultiPageDecoder.createPageTurnImage(pageW[page], pageH[page], page, this.display.getDisplayRotation(), this.pdf);
            }
        }
    }

    private static BufferedImage createPageTurnImage(int width, int height, int page, int displayRotation, PdfDecoderInt pdf) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D pg = (Graphics2D)image.getGraphics();
        pg.rotate((double)displayRotation * Math.PI / 180.0);
        try {
            switch (displayRotation) {
                case 90: {
                    pg.translate(0, -width);
                    pg.drawImage(pdf.getPageAsImage(page), 0, 0, height + 1, width + 1, null);
                    break;
                }
                case 180: {
                    pg.translate(-width, -height);
                    pg.drawImage(pdf.getPageAsImage(page), 0, 0, width + 1, height + 1, null);
                    break;
                }
                case 270: {
                    pg.translate(-height, 0);
                    pg.drawImage(pdf.getPageAsImage(page), 0, 0, height + 1, width + 1, null);
                    break;
                }
                default: {
                    pg.drawImage(pdf.getPageAsImage(page), 0, 0, width + 1, height + 1, null);
                    break;
                }
            }
        }
        catch (PdfException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return image;
    }

    private void decodeMorePages(int page) {
        if (this.currentPageViews.get(page) == null) {
            this.decodePage(page);
        }
        this.repaint();
    }

    private void decodePage(int page) {
        Integer key;
        DynamicVectorRenderer currentView;
        AcroRenderer formRenderer = this.pdf.getFormRenderer();
        String currentPageOffset = this.pdf.getIO().getReferenceforPage(page);
        if ((currentPageOffset != null || formRenderer.isXFA() && formRenderer.useXFA()) && (currentView = this.currentPageViews.get(key = Integer.valueOf(page))) == null && this.multiDisplayOptions.isIsGeneratingOtherPages()) {
            this.display.forceRedraw();
            this.getPageView(currentPageOffset, page);
        }
    }

    private void getPageView(String currentPageOffset, int pageNumber) {
        TextLines textLines;
        PageObject pdfObject = new PageObject(currentPageOffset);
        pdfObject.setPageNumber(pageNumber);
        this.currentPdfFile.readObject(pdfObject);
        PdfObject Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
        DynamicVectorRenderer currentDisplay = this.getNewDisplay(pageNumber);
        int val = 0;
        if (this.pdf.getDisplayView() == 2 && this.pdf.getDisplayView() == 3) {
            val = 1;
        }
        PdfStreamDecoder current = this.formRenderer.getStreamDecoder(this.currentPdfFile, this.fileAccess.getRes().getPdfLayerList(), true);
        if (this.pdf.isForm()) {
            this.formRenderer.createDisplayComponentsForPage(pageNumber, current);
        }
        current.setParameters(true, true, 7, val, false);
        current.setXMLExtraction(this.pdf.isXMLExtraction());
        this.pdf.getExternalHandler().addHandlers(current);
        current.setObjectValue(-9, this.fileAccess.getFilename());
        current.setObjectValue(-8, this.pdf.getObjectStore());
        current.setObjectValue(-18, this.pageData);
        current.setIntValue(-10, pageNumber);
        current.setRenderer(currentDisplay);
        currentDisplay.init(this.pageData.getMediaBoxWidth(pageNumber), this.pageData.getMediaBoxHeight(pageNumber), this.options.getPageColor());
        RenderUtils.setDisplayOptions(currentDisplay, this.options);
        this.fileAccess.getRes().setupResources(current, false, Resources, pageNumber, this.currentPdfFile);
        current.decodePageContent(pdfObject);
        if (this.displayView == 2 || this.displayView == 3 || this.displayView == 4) {
            this.formRenderer.createDisplayComponentsForPage(pageNumber, current);
            if (this.pdf.getSpecialMode() != -1 && this.pdf.getSpecialMode() != 1 && pageNumber != this.pdf.getPageCount()) {
                this.formRenderer.createDisplayComponentsForPage(pageNumber + 1, current);
            }
        }
        if ((textLines = this.pdf.getTextLines()) != null) {
            Vector_Rectangle_Int vr = (Vector_Rectangle_Int)current.getObjectValue(-21);
            vr.trim();
            int[][] pageTextAreas = vr.get();
            Vector_Int vi = (Vector_Int)current.getObjectValue(22);
            vi.trim();
            int[] pageTextDirections = vi.get();
            for (int k2 = 0; k2 != pageTextAreas.length; ++k2) {
                textLines.addToLineAreas(pageTextAreas[k2], pageTextDirections[k2], pageNumber);
            }
        }
        this.currentPageViews.put(pageNumber, currentDisplay);
        this.display.setCurrentDisplay(currentDisplay);
    }

    private void resetPageCaches(int startPage, int endPage) {
        for (Integer o2 : this.cachedPageViews.keySet()) {
            DynamicVectorRenderer obj;
            Integer currentKey = o2;
            int keyValue = currentKey;
            if (keyValue < startPage || keyValue > endPage || (obj = this.cachedPageViews.get(currentKey)) == null) continue;
            this.currentPageViews.put(currentKey, obj);
        }
        Iterator<Integer> keys = this.currentPageViews.keySet().iterator();
        HashMap<Integer, String> keysToTrash = new HashMap<Integer, String>();
        while (keys.hasNext()) {
            int keyValue = keys.next();
            if (keyValue >= startPage && keyValue <= endPage) continue;
            DynamicVectorRenderer obj = this.currentPageViews.get(keyValue);
            if (obj != null) {
                this.cachedPageViews.put(keyValue, obj);
            }
            keysToTrash.put(keyValue, "x");
        }
        for (int keyValue : keysToTrash.keySet()) {
            this.currentPageViews.remove(keyValue);
        }
    }

    private synchronized void calcDisplayedRange() {
        int pageCount = this.pageData.getPageCount();
        if (this.displayView == 1) {
            return;
        }
        this.display.getDisplayedRectangle();
        if (this.displayView == 4) {
            this.multiDisplayOptions.calcDisplayRangeForFacing();
        } else {
            int newPage = this.updatePageDisplayed();
            this.fileAccess.setPageNumber(newPage);
            if (newPage != -1 && this.gui != null) {
                this.gui.setPage(newPage);
            }
        }
        if (this.multiDisplayOptions.getEndViewPage() > pageCount) {
            this.multiDisplayOptions.setEndViewPage(pageCount);
        }
        if (this.displayView != 4) {
            this.display.refreshDisplay();
        }
    }

    public void flushPageCaches() {
        this.currentPageViews.clear();
        this.cachedPageViews.clear();
    }

    public DynamicVectorRenderer getCurrentPageView(int i2) {
        return this.currentPageViews.get(i2);
    }

    public void dispose() {
        this.cachedPageViews = null;
    }

    private int updatePageDisplayed() {
        int lastVisiblePage;
        int rh;
        int ry;
        int[] pageH;
        int[] yReached;
        int pageCount = this.pageData.getPageCount();
        int firstVisiblePage = SwingMultiPageDecoder.findFirstVisiblePage(pageCount, yReached = this.multiDisplayOptions.getyReached(), pageH = this.multiDisplayOptions.getPageH(), ry = this.display.getRy(), rh = this.display.getRh());
        if (firstVisiblePage == -1) {
            firstVisiblePage = 1;
            lastVisiblePage = 1;
        } else {
            lastVisiblePage = SwingMultiPageDecoder.findLastVisiblePage(pageCount, firstVisiblePage, yReached, pageH, ry, rh);
        }
        this.multiDisplayOptions.setStartViewPage(firstVisiblePage);
        this.multiDisplayOptions.setEndViewPage(lastVisiblePage);
        if (this.multiDisplayOptions.getEndViewPage() > pageCount) {
            this.multiDisplayOptions.setEndViewPage(pageCount);
        }
        return SwingMultiPageDecoder.findCurrentPageDisplayed(firstVisiblePage, lastVisiblePage, yReached, pageH, ry, rh);
    }

    private static int findCurrentPageDisplayed(int firstPage, int lastPage, int[] yReached, int[] pageH, int ry, int rh) {
        if (firstPage != lastPage) {
            int firstPageVisible = yReached[firstPage] + pageH[firstPage] - ry;
            int secondPage = firstPage + 1;
            int secondPageVisible = ry + rh - yReached[secondPage];
            return firstPageVisible > secondPageVisible ? firstPage : secondPage;
        }
        return firstPage;
    }

    private static int findFirstVisiblePage(int pageCount, int[] yReached, int[] pageH, int ry, int rh) {
        for (int i2 = 1; i2 <= pageCount; ++i2) {
            int pageTop = yReached[i2];
            int pageBottom = yReached[i2] + pageH[i2];
            int viewBottom = ry + rh;
            if (pageTop > viewBottom || pageBottom < ry) continue;
            return i2;
        }
        return -1;
    }

    private static int findLastVisiblePage(int pageCount, int firstVisiblePage, int[] yReached, int[] pageH, int ry, int rh) {
        int lastVisiblePage = firstVisiblePage;
        for (int i2 = firstVisiblePage; i2 <= pageCount; ++i2) {
            int pageTop = yReached[i2];
            int pageBottom = yReached[i2] + pageH[i2];
            int viewBottom = ry + rh;
            if (pageTop > viewBottom || pageBottom < ry) continue;
            lastVisiblePage = i2;
        }
        return lastVisiblePage;
    }

    public void resetCachedFacingImages() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.facingDragCachedImages[i2] = null;
        }
    }

    public BufferedImage[] getFacingDragImages() {
        return this.facingDragCachedImages;
    }

    public BufferedImage getfacingDragTempLeftImg() {
        return this.facingDragTempLeftImg;
    }

    public BufferedImage getfacingDragTempRightImg() {
        return this.facingDragTempRightImg;
    }

    public int getFacingDragTempLeftNo() {
        return this.facingDragTempLeftNo;
    }

    public int getFacingDragTempRightNo() {
        return this.facingDragTempRightNo;
    }

    public void setCustomRenderChangeListener(RenderChangeListener customRenderChangeListener) {
        this.customRenderChangeListener = customRenderChangeListener;
    }
}

