/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.InvocationTargetException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.display.PageFlowFX;
import org.jpedal.display.PageOffsets;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PageFlowDisplay
extends JFXPanel
implements Display {
    private final PageFlowFX pageFlowFX;
    private boolean isBorderPresent;

    @Override
    public void dispose() {
        this.pageFlowFX.dispose();
    }

    public PageFlowDisplay(final SwingGUI currentGUI, final PdfDecoderInt pdf) {
        this.pageFlowFX = new PageFlowFX(pdf);
        Platform.runLater(() -> this.setScene(new Scene((Parent)this.pageFlowFX)));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                currentGUI.setPage((int)PageFlowDisplay.this.pageFlowFX.getPageNumber().doubleValue());
                if (PageFlowDisplay.this.pageFlowFX.isUpdateMemory()) {
                    currentGUI.showMessageDialog(PageFlowDisplay.this.pageFlowFX.getMemoryMessage());
                }
            }
        });
        this.addMouseWheelListener(e2 -> {
            currentGUI.setPage((int)this.pageFlowFX.getPageNumber().doubleValue());
            if (this.pageFlowFX.isUpdateMemory()) {
                currentGUI.showMessageDialog(this.pageFlowFX.getMemoryMessage());
            }
        });
        this.pageFlowFX.getPageNumber().addListener((observable, oldValue, newValue) -> {
            currentGUI.setPage((int)this.pageFlowFX.getPageNumber().doubleValue());
            if (this.pageFlowFX.isUpdateMemory()) {
                currentGUI.showMessageDialog(this.pageFlowFX.getMemoryMessage());
            }
        });
        this.pageFlowFX.setCursors(currentGUI.getGUICursor().getCursorImageForFX(1), currentGUI.getGUICursor().getCursorImageForFX(2));
        ((Container)((Object)pdf)).removeAll();
        currentGUI.getDisplayPane().getRightComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Dimension size = currentGUI.getDisplayPane().getRightComponent().getSize();
                size.setSize(size.getWidth() - 2.0, size.getHeight());
                ((Component)((Object)pdf)).setSize(size);
            }
        });
        Dimension size = currentGUI.getDisplayPane().getRightComponent().getSize();
        size.setSize(size.getWidth() - 2.0, size.getHeight());
        ((Component)((Object)pdf)).setSize(size);
        ((Container)((Object)pdf)).setLayout(new BorderLayout());
        try {
            ((Container)((Object)pdf)).add("Center", (Component)((Object)this));
        }
        catch (IllegalArgumentException e3) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.PageFlowIllegalArgument") + ' ' + e3);
            if (SwingUtilities.isEventDispatchThread()) {
                currentGUI.setDisplayView(1, 2);
            }
            Runnable doPaintComponent = () -> currentGUI.setDisplayView(1, 2);
            try {
                SwingUtilities.invokeAndWait(doPaintComponent);
            }
            catch (InterruptedException | InvocationTargetException e1) {
                LogWriter.writeLog("Exception: " + e1.getMessage());
            }
        }
    }

    @Override
    public void init(float scaling, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit) {
        this.pageFlowFX.setRotation(displayRotation);
    }

    @Override
    public int[] getPageSize(int a10) {
        int[] pageSize = new int[]{((Component)((Object)this.pageFlowFX.getPdfDecoderInt())).getSize().width, ((Component)((Object)this.pageFlowFX.getPdfDecoderInt())).getSize().height};
        return pageSize;
    }

    @Override
    public void stopGeneratingPage() {
        this.pageFlowFX.stop();
    }

    @Override
    public void setScaling(float scaling) {
        if ((double)this.pageFlowFX.getPdfDecoderInt().getPageNumber() != this.pageFlowFX.getPageNumber().doubleValue()) {
            this.pageFlowFX.goTo(this.pageFlowFX.getPdfDecoderInt().getPageNumber());
        }
    }

    @Override
    public final void decodeOtherPages(int pageCount) {
    }

    @Override
    public void refreshDisplay() {
    }

    @Override
    public int getXCordForPage(int page) {
        return 0;
    }

    @Override
    public int getYCordForPage(int page) {
        return 0;
    }

    @Override
    public void getYCordForPage(int page, float scaling) {
    }

    @Override
    public void flushPageCaches() {
    }

    @Override
    public void setAcceleration(boolean a10) {
    }

    @Override
    public void disableScreen() {
    }

    @Override
    public void drawBorder() {
    }

    @Override
    public void setup(boolean useAcceleration, PageOffsets currentOffset) {
    }

    @Override
    public void setObjectValue(int type, Object newValue) {
    }

    @Override
    public int[] getHighlightedImage() {
        return new int[0];
    }

    @Override
    public void setHighlightedImage(int[] i2) {
    }

    @Override
    public float getOldScaling() {
        return 0.0f;
    }

    @Override
    public boolean getBoolean(Display.BoolValue option) {
        if (LogWriter.isRunningFromIDE) {
            System.err.println("Attempting to fetch unknown boolean in PageFlowDisplay.");
        }
        return false;
    }

    @Override
    public void setBoolean(Display.BoolValue option, boolean value) {
        if (LogWriter.isRunningFromIDE) {
            System.err.println("Attempting to set unknown boolean in PageFlowDisplay.");
        }
    }

    @Override
    public double getIndent() {
        return 0.0;
    }

    @Override
    public int[] getCursorBoxOnScreenAsArray() {
        return null;
    }

    @Override
    public void forceRedraw() {
    }

    @Override
    public void setPageRotation(int displayRotation) {
    }

    @Override
    public void paintPage(Graphics2D g2, AcroRenderer formRenderer, TextLines textLines) {
    }

    @Override
    public void updateCursorBoxOnScreen(int[] newOutlineRectangle, int outlineColor, int pageNumber, int x_size, int y_size) {
    }

    @Override
    public void drawFacing(Rectangle visibleRect) {
    }

    @Override
    public void setBorderPresent(boolean borderPresent) {
        this.isBorderPresent = borderPresent;
    }

    @Override
    public boolean isBorderPresent() {
        return this.isBorderPresent;
    }
}

