/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.swing;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.jpedal.FileAccess;
import org.jpedal.PdfDecoder;
import org.jpedal.display.Display;
import org.jpedal.display.swing.SingleDisplay;
import org.jpedal.display.swing.SwingMultiPageDecoder;
import org.jpedal.display.swing.SwingMultiPageViewer;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;

public class MultiDisplay
extends SingleDisplay {
    final SwingMultiPageDecoder multiPageDecoder;
    private final SwingMultiPageViewer swingViewer;
    final int pageCount;
    Shape rawClip;

    public MultiDisplay(int pageNumber, DynamicVectorRenderer currentDisplay, int displayView, PdfDecoder pdf, DecoderOptions options, FileAccess fileAccess) {
        super(pageNumber, currentDisplay, pdf, options);
        this.displayView = displayView;
        this.multiPageDecoder = new SwingMultiPageDecoder(pdf, this.pageData, this, this.multiDisplayOptions, currentDisplay, pageNumber, fileAccess, pdf.getIO(), pdf.getFormRenderer(), options);
        if (this.customRenderChangeListener != null) {
            this.multiPageDecoder.setCustomRenderChangeListener(this.customRenderChangeListener);
        }
        this.swingViewer = new SwingMultiPageViewer(this.multiDisplayOptions, this.multiPageDecoder);
        this.pageCount = this.pageData.getPageCount();
    }

    @Override
    public void decodeOtherPages(int pageNumber) {
        if (!this.isInitialised) {
            return;
        }
        this.setPageOffsets();
        this.multiPageDecoder.decodeOtherPages(pageNumber, this.displayView);
    }

    @Override
    public void flushPageCaches() {
        this.multiPageDecoder.flushPageCaches();
    }

    @Override
    public void dispose() {
        this.multiPageDecoder.dispose();
        super.dispose();
    }

    @Override
    public final void drawBorder() {
        this.swingViewer.drawBorder(this.displayView, this.g2, this.pageCount, this);
    }

    @Override
    void drawPage(AffineTransform viewScaling, AffineTransform displayScaling) {
        if (displayScaling != null) {
            if ((float)this.displayRotation != this.oldRotation) {
                this.setPageOffsets();
                this.useAcceleration = true;
            }
            this.swingViewer.drawPage(this, viewScaling, displayScaling, this.g2, this.displayView);
            this.oldScaling = this.scaling;
            this.oldRotation = this.displayRotation;
        }
    }

    @Override
    public void drawFacing(Rectangle visibleRect) {
        boolean pageTurnScalingAppropriate;
        SwingGUI swingGUI = (SwingGUI)this.pdf.getExternalHandler().getExternalHandler(11);
        boolean bl2 = pageTurnScalingAppropriate = swingGUI != null && swingGUI.getPageTurnScalingAppropriate();
        if (this.displayView == 4 && this.getBoolean(Display.BoolValue.TURNOVER_ON) && pageTurnScalingAppropriate && !this.pageData.hasMultipleSizes()) {
            this.swingViewer.drawFacingDrag(this.g2, visibleRect, this);
        }
    }

    @Override
    public void init(float scaling, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit) {
        super.init(scaling, displayRotation, pageNumber, currentDisplay, isInit);
        if (this.displayView == 4 && (isInit || this.lastScaling != scaling)) {
            this.multiPageDecoder.resetCachedFacingImages();
            this.pdf.setUserOffsets(0, 0, 995);
        }
    }

    @Override
    protected void initRenderer(TextLines lines, Graphics2D g2) {
        this.rawAf = g2.getTransform();
        this.rawClip = g2.getClip();
        if (lines.hasHighlightAreasUpdated()) {
            this.lastAreasPainted = -2;
        }
        this.areas = lines.getAllHighlights();
        this.g2 = g2;
        this.setPageSize(this.pageNumber, this.scaling);
        g2.translate(this.insetW - this.crx, this.insetH - this.cry);
        this.current2 = g2.getTransform();
        this.currentClip = g2.getClip();
        g2.clip(new Rectangle(this.crx, this.cry, this.crw, this.crh));
    }

    public void setCurrentDisplay(DynamicVectorRenderer pageView) {
        this.currentDisplay = pageView;
    }

    public int getDisplayRotation() {
        return this.displayRotation;
    }

    public int getRy() {
        return this.ry;
    }

    public int getRh() {
        return this.rh;
    }
}

