/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.objects.PdfPageData;

public class PageOffsets {
    private int width;
    private int height;
    private int totalSingleWidth;
    private int gaps;
    private int doubleGaps;
    private int totalSingleHeight;
    private int maxW;
    private int maxH;
    public static final int pageGap = 10;
    private int doublePageWidth;
    private int doublePageHeight;
    private int biggestWidth;
    private int biggestHeight;
    private int widestPageNR;
    private int widestPageR;
    private int widestLeftPage;
    private int widestRightPage;
    private int highestLeftPage;
    private int highestRightPage;
    private int pageH;
    private int pageW;
    private int greatestW;
    private int greatestH;

    public PageOffsets(int pageCount, PdfPageData pageData) {
        this.setValues(pageCount, pageData);
        this.totalSingleWidth -= 10;
        this.totalSingleHeight -= 10;
    }

    private void setValues(int pageCount, PdfPageData pageData) {
        for (int i2 = 1; i2 < pageCount + 1; ++i2) {
            this.pageW = pageData.getCropBoxWidth(i2);
            this.pageH = pageData.getCropBoxHeight(i2);
            int rotation = pageData.getRotation(i2);
            if (rotation == 90 || rotation == 270) {
                int tmp = this.pageW;
                this.pageW = this.pageH;
                this.pageH = tmp;
            }
            if (this.pageW > this.maxW) {
                this.maxW = this.pageW;
            }
            if (this.pageH > this.maxH) {
                this.maxH = this.pageH;
            }
            this.gaps += 10;
            this.totalSingleWidth += this.pageW;
            this.totalSingleHeight += this.pageH;
            this.trackPageSize(i2);
            if ((i2 & 1) == 1) {
                if (this.greatestW < this.pageW) {
                    this.greatestW = this.pageW;
                }
                if (this.greatestH < this.pageH) {
                    this.greatestH = this.pageH;
                }
                this.doubleGaps += 10;
                continue;
            }
            this.greatestW = this.pageW;
            this.greatestH = this.pageH;
        }
        this.doublePageWidth = this.widestLeftPage + this.widestRightPage + 10;
        this.doublePageHeight = this.highestLeftPage + this.highestRightPage + 10;
    }

    private void trackPageSize(int i2) {
        if ((i2 & 1) == 1) {
            if (this.widestRightPage < this.pageW) {
                this.widestRightPage = this.pageW;
            }
            if (this.highestRightPage < this.pageH) {
                this.highestRightPage = this.pageH;
            }
        } else {
            if (this.widestLeftPage < this.pageW) {
                this.widestLeftPage = this.pageW;
            }
            if (this.highestLeftPage < this.pageH) {
                this.highestLeftPage = this.pageH;
            }
        }
        if (this.widestPageNR < this.pageW) {
            this.widestPageNR = this.pageW;
        }
        if (this.widestPageR < this.pageH) {
            this.widestPageR = this.pageH;
        }
        if (this.pageW > this.biggestWidth) {
            this.biggestWidth = this.pageW;
        }
        if (this.pageH > this.biggestHeight) {
            this.biggestHeight = this.pageH;
        }
    }

    public int getMaxH() {
        return this.maxH;
    }

    public int getMaxW() {
        return this.maxW;
    }

    public int getWidestPageR() {
        return this.widestPageR;
    }

    public int getWidestPageNR() {
        return this.widestPageNR;
    }

    public int getGaps() {
        return this.gaps;
    }

    public int getDoubleGaps() {
        return this.doubleGaps;
    }

    public int getDoublePageWidth() {
        return this.doublePageWidth;
    }

    public int getDoublePageHeight() {
        return this.doublePageHeight;
    }

    public int getBiggestWidth() {
        return this.biggestWidth;
    }

    public int getBiggestHeight() {
        return this.biggestHeight;
    }

    public void calculateCombinedPageSizes(int displayView, int pageNumber, int displayRotation, MultiDisplayOptions multiDisplayOptions, PdfPageData pageData, float scaling, int insetW, int insetH) {
        int biggestFacingHeight = 0;
        if (displayView == 4 && multiDisplayOptions.getPageW() != null) {
            int p1;
            if (multiDisplayOptions.isSeparateCover()) {
                p1 = pageNumber;
                if ((p1 & 1) == 1) {
                    --p1;
                }
            } else {
                p1 = pageNumber;
                if ((p1 & 1) == 0) {
                    --p1;
                }
            }
            int p2 = p1 + 1;
            biggestFacingHeight = multiDisplayOptions.getPageH(p1);
            if (p2 < multiDisplayOptions.getPageH().length && biggestFacingHeight < multiDisplayOptions.getPageH(p2)) {
                biggestFacingHeight = multiDisplayOptions.getPageH(p2);
            }
        }
        int gaps = this.gaps;
        switch (displayView) {
            case 4: {
                int firstW = (displayRotation + pageData.getRotation(pageNumber)) % 180 == 90 ? pageData.getCropBoxHeight(pageNumber) : pageData.getCropBoxWidth(pageNumber);
                int pageCount = pageData.getPageCount();
                int secondW = pageNumber + 1 > pageCount || pageNumber == 1 && pageCount != 2 ? firstW : ((displayRotation + pageData.getRotation(pageNumber + 1)) % 180 == 90 ? pageData.getCropBoxHeight(pageNumber + 1) : pageData.getCropBoxWidth(pageNumber + 1));
                int totalW = firstW + secondW;
                this.width = (int)((float)totalW * scaling) + 10;
                this.height = biggestFacingHeight;
                break;
            }
            case 2: {
                if (displayRotation == 90 | displayRotation == 270) {
                    this.width = (int)((float)this.biggestHeight * scaling);
                    this.height = (int)((float)this.totalSingleWidth * scaling) + gaps + insetH;
                    break;
                }
                this.width = (int)((float)this.biggestWidth * scaling);
                this.height = (int)((float)this.totalSingleHeight * scaling) + gaps + insetH;
                break;
            }
            case 3: {
                int[] displaySize = this.getDisplayBounds(pageData, displayRotation, scaling, insetW, insetH, multiDisplayOptions.isSeparateCover());
                this.width = displaySize[0];
                this.height = displaySize[1];
            }
        }
    }

    public int[] getDisplayBounds(PdfPageData pageData, int displayRotation, float scaling, int insetW, int insetH, boolean isSeparateCover) {
        int[] pageSize = new int[2];
        int pageCount = pageData.getPageCount();
        if (pageCount == 2) {
            if (displayRotation == 90 || displayRotation == 270) {
                pageSize[0] = (int)((float)this.getDoublePageHeight() * scaling) + insetW + insetW;
                pageSize[1] = (int)((float)this.getBiggestWidth() * scaling) + this.gaps + insetH + insetH;
            } else {
                pageSize[0] = (int)((float)this.getDoublePageWidth() * scaling) + insetW + insetW;
                pageSize[1] = (int)((float)this.getBiggestHeight() * scaling) + this.gaps + insetH + insetH;
            }
        } else {
            int pageGap = 10;
            int totalHight = insetH + insetH;
            int greatestH = 0;
            int greatestWLeft = 0;
            int greatestWRight = 0;
            for (int i2 = 1; i2 <= pageCount; ++i2) {
                int pageW;
                int pageH;
                boolean isLeftPage = isSeparateCover ? i2 % 2 == 0 : i2 % 2 == 1;
                int pageRotation = pageData.getRotation(i2);
                int totalRotation = displayRotation + pageRotation % 360;
                if (totalRotation == 90 || totalRotation == 270) {
                    pageH = pageData.getScaledCropBoxWidth(i2);
                    pageW = pageData.getScaledCropBoxHeight(i2);
                } else {
                    pageW = pageData.getScaledCropBoxWidth(i2);
                    pageH = pageData.getScaledCropBoxHeight(i2);
                }
                if (isLeftPage) {
                    if (greatestWLeft < pageW) {
                        greatestWLeft = pageW;
                    }
                    greatestH = pageH;
                    if (i2 != pageCount) continue;
                    totalHight += greatestH;
                    continue;
                }
                if (greatestWRight < pageW) {
                    greatestWRight = pageW;
                }
                if (greatestH < pageH) {
                    greatestH = pageH;
                }
                totalHight += greatestH + 10;
            }
            pageSize[0] = insetW + greatestWLeft + 10 + greatestWRight + insetW;
            pageSize[1] = totalHight;
        }
        return pageSize;
    }

    public int getPageWidth() {
        return this.width;
    }

    public int getPageHeight() {
        return this.height;
    }
}

