/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Point;

public class DisplayOffsets {
    private boolean dragLeft;
    private boolean dragTop;
    private int userOffsetX;
    private int userOffsetY;
    private int userPrintOffsetX;
    private int userPrintOffsetY;
    private int facingCursorX = 10000;
    private int facingCursorY = 10000;

    public void setUserOffsets(int x2, int y2, int h2, int mode) {
        switch (mode) {
            case 0: {
                this.userOffsetX = x2;
                this.userOffsetY = y2;
                break;
            }
            case 1: {
                this.userPrintOffsetX = x2;
                this.userPrintOffsetY = -y2;
                break;
            }
            case 995: {
                this.facingCursorX = 0;
                this.facingCursorY = h2;
                this.setDragCorner(mode);
                break;
            }
            case 996: 
            case 997: 
            case 998: 
            case 999: {
                this.facingCursorX = x2;
                this.facingCursorY = y2;
                this.setDragCorner(mode);
                break;
            }
            default: {
                throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
            }
        }
    }

    public Point getUserOffsets(int mode) {
        switch (mode) {
            case 0: {
                return new Point(this.userOffsetX, this.userOffsetY);
            }
            case 1: {
                return new Point(this.userPrintOffsetX, this.userPrintOffsetY);
            }
            case 999: {
                return new Point(this.facingCursorX, this.facingCursorY);
            }
        }
        throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
    }

    public int getUserPrintOffsetX() {
        return this.userPrintOffsetX;
    }

    public int getUserPrintOffsetY() {
        return this.userPrintOffsetY;
    }

    public int getUserOffsetX() {
        return this.userOffsetX;
    }

    public int getUserOffsetY() {
        return this.userOffsetY;
    }

    private void setDragCorner(int a10) {
        this.dragLeft = a10 == 998 || a10 == 996 || a10 == 995;
        this.dragTop = a10 == 996 || a10 == 997;
    }

    public boolean getDragLeft() {
        return this.dragLeft;
    }

    public boolean getDragTop() {
        return this.dragTop;
    }
}

