/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.color.GenericColorSpace;

public class YCBCRColorSpace
extends GenericColorSpace {
    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        int ii = width * height * 3;
        for (int i2 = 0; i2 < ii; i2 += 3) {
            int y2 = ((data[i2] & 0xFF) << 8) + 128;
            int u2 = (data[i2 + 1] & 0xFF) - 128;
            int v2 = (data[i2 + 2] & 0xFF) - 128;
            int r2 = Math.max(0, Math.min(255, y2 + 359 * v2 >> 8));
            int g2 = Math.max(0, Math.min(255, y2 - 88 * u2 - 183 * v2 >> 8));
            int b2 = Math.max(0, Math.min(255, y2 + 454 * u2 >> 8));
            pixels[p2++] = 0xFF000000 | (r2 << 16 | g2 << 8 | b2);
        }
        return image;
    }
}

