/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.Matrix;

public class ShearedTexturePaint
extends TexturePaint
implements PdfPaint {
    private final float[][] callerTransform;

    public ShearedTexturePaint(BufferedImage txtr, Rectangle2D anchor, float[][] callerTransform) {
        super(txtr, anchor);
        this.callerTransform = callerTransform;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        float[][] subForm = Matrix.fromAffine(xform);
        subForm = Matrix.concatenate(subForm, this.callerTransform);
        return super.createContext(cm, deviceBounds, userBounds, Matrix.toAffine(subForm), hints);
    }

    @Override
    public boolean isPattern() {
        return false;
    }

    @Override
    public int getRGB() {
        return 0;
    }

    @Override
    public boolean isTexture() {
        return true;
    }

    @Override
    public void setGlyphMatrix(float[][] gtm) {
    }

    @Override
    public void setGS(GraphicsState gs) {
    }
}

