/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class LabColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private float lastL = -1.0f;
    private float lastA = 65536.0f;
    private float lastBstar;
    private final Map<Integer, Integer> cache = new HashMap<Integer, Integer>();
    private static final float C1 = 0.12841855f;
    private static final float C2 = 0.13793103f;
    private static final float C3 = 0.20689656f;
    private static final float C4 = 0.39215687f;
    private static final float C5 = 128.0f;

    public LabColorSpace(float[] whitepoint, float[] range) {
        this.setType(1847602);
        this.setCIEValues(whitepoint, range, null, null);
    }

    @Override
    public byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        int size = index.length;
        for (int i2 = 0; i2 < size; i2 += 3) {
            float cl = (float)(index[i2] & 0xFF) * 0.39215687f;
            float ca = (float)(index[i2 + 1] & 0xFF) - 128.0f;
            float cb = (float)(index[i2 + 2] & 0xFF) - 128.0f;
            this.convertToRGB(cl, ca, cb);
            index[i2] = (byte)this.r;
            index[i2 + 1] = (byte)this.g;
            index[i2 + 2] = (byte)this.b;
        }
        return index;
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w2, int h2) {
        int imgSize = w2 * h2;
        for (int i2 = 0; i2 < imgSize * 3; i2 += 3) {
            float cl = (float)(data[i2] & 0xFF) * 0.39215687f;
            float ca = (float)(data[i2 + 1] & 0xFF) - 128.0f;
            float cb = (float)(data[i2 + 2] & 0xFF) - 128.0f;
            this.convertToRGB(cl, ca, cb);
            data[i2] = (byte)this.r;
            data[i2 + 1] = (byte)this.g;
            data[i2 + 2] = (byte)this.b;
        }
        return data;
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image;
        try {
            data = this.dataToRGBByteArray(data, width, height);
            image = new BufferedImage(width, height, 1);
            Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, width, height);
            image.setData(raster);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    private void convertToRGB(float l2, float a10, float bstar) {
        if (l2 < 0.0f) {
            l2 = 0.0f;
        } else if (l2 > 100.0f) {
            l2 = 100.0f;
        }
        if (a10 < this.R[0]) {
            a10 = this.R[0];
        } else if (a10 > this.R[1]) {
            a10 = this.R[1];
        }
        if (bstar < this.R[2]) {
            bstar = this.R[2];
        } else if (bstar > this.R[3]) {
            bstar = this.R[3];
        }
        if (this.lastL != l2 || this.lastA != a10 || this.lastBstar != bstar) {
            int indexL = (int)l2;
            int indexA = (int)(a10 - this.R[0]);
            int indexB = (int)(bstar - this.R[2]);
            Integer key = (indexL << 16) + (indexA << 8) + indexB;
            Integer value = this.cache.get(key);
            if (value != null) {
                int raw = value;
                this.r = raw >> 16 & 0xFF;
                this.g = raw >> 8 & 0xFF;
                this.b = raw & 0xFF;
            } else {
                double val1 = ((double)l2 + 16.0) / 116.0;
                double[] vals = new double[]{val1 + (double)a10 / 500.0, val1, val1 - (double)bstar / 200.0};
                float[] out = new float[3];
                for (int j2 = 0; j2 < 3; ++j2) {
                    out[j2] = vals[j2] >= 0.2068965584039688 ? (float)((double)this.W[j2] * vals[j2] * vals[j2] * vals[j2]) : (float)((double)(this.W[j2] * 0.12841855f) * (vals[j2] - 0.13793103396892548));
                    if (!(out[j2] < 0.0f)) continue;
                    out[j2] = 0.0f;
                }
                out = this.cs.toRGB(out);
                this.r = (int)(out[0] * 255.0f);
                this.g = (int)(out[1] * 255.0f);
                this.b = (int)(out[2] * 255.0f);
                if (this.r < 0) {
                    this.r = 0;
                }
                if (this.g < 0) {
                    this.g = 0;
                }
                if (this.b < 0) {
                    this.b = 0;
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.g > 255) {
                    this.g = 255;
                }
                if (this.b > 255) {
                    this.b = 255;
                }
                int raw = (this.r << 16) + (this.g << 8) + this.b;
                this.cache.put(key, raw);
            }
            this.lastL = l2;
            this.lastA = a10;
            this.lastBstar = bstar;
        }
    }

    @Override
    public final void setColor(float[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        float l2 = operand[0];
        float a10 = operand[1];
        float Bstar = operand[2];
        this.convertToRGB(l2, a10, Bstar);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }
}

