/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private float[] prevFloat;

    public ICCColorSpace(byte[] icc_data) {
        this.setType(1247168582);
        this.cs = ColorSpace.getInstance(1000);
        if (icc_data == null) {
            LogWriter.writeLog("Error in ICC data");
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(icc_data));
                this.type = this.cs.getType();
            }
            catch (Exception e2) {
                LogWriter.writeLog("[PDF] Problem " + e2.getMessage() + " with ICC data ");
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        if (this.componentCount == 3) {
            BufferedImage image = new BufferedImage(width, height, 1);
            Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, width, height);
            image.setData(raster);
            return image;
        }
        return ColorSpaceConvertor.convertFromICCCMYK(width, height, data);
    }

    private static boolean isSame(float[] arr0, float[] arr1) {
        if (arr0 == null || arr1 == null) {
            return false;
        }
        for (int i2 = 0; i2 < arr0.length; ++i2) {
            if (arr0[i2] == arr1[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setColor(float[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        if (!ICCColorSpace.isSame(this.prevFloat, operand)) {
            float[] result = this.cs.toRGB(operand);
            this.currentColor = new PdfColor(result[0], result[1], result[2]);
            this.prevFloat = (float[])operand.clone();
        }
    }

    @Override
    public byte[] convertIndexToRGB(byte[] data) {
        this.isConverted = true;
        if (this.componentCount == 4) {
            return this.convert4Index(data);
        }
        return data;
    }
}

