/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.util.Map;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.FastColorSpaceCMYK;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class GenericColorSpace {
    boolean isConverted;
    Map<String, byte[]> patterns;
    private int size;
    float c = -1.0f;
    float y = -1.0f;
    float m = -1.0f;
    float k = -1.0f;
    float[] W;
    float[] G;
    float[] Ma;
    float[] R;
    private static final ColorSpace rgbCS;
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    private int value = 1785221209;
    private static ColorConvertOp CSToRGB;
    ColorSpace cs;
    int type;
    PdfPaint currentColor = new PdfColor(0, 0, 0);
    private static ColorModel rgbModel;
    private static ICC_Profile ICCProfileForRGB;
    private static final int[] bands4;
    private int rawCSType;
    private byte[] IndexedColorMap;
    int componentCount = 3;
    GraphicsState gs;

    private static void initCMYKColorspace() {
        if (ICCProfileForRGB == null) {
            rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
        } else {
            int compCount = rgbCS.getNumComponents();
            int[] values = new int[compCount];
            for (int i2 = 0; i2 < compCount; ++i2) {
                values[i2] = 8;
            }
            rgbModel = new ComponentColorModel(rgbCS, values, false, false, 1, 0);
        }
        FastColorSpaceCMYK cmykCS = new FastColorSpaceCMYK();
        CSToRGB = new ColorConvertOp(cmykCS, rgbCS, ColorSpaces.hints);
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    GenericColorSpace() {
        this.cs = rgbCS;
    }

    public void setIndex(byte[] IndexedColorMap, int size) {
        this.IndexedColorMap = IndexedColorMap;
        this.size = size;
    }

    public byte[] getIndexedMap() {
        if (this.IndexedColorMap == null) {
            return null;
        }
        int size = this.IndexedColorMap.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.IndexedColorMap, 0, copy, 0, size);
        return copy;
    }

    public void setColor(String[] number_values) {
        int items = number_values.length;
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues);
    }

    public void setColor(int[] number_values) {
        int items = number_values.length;
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = (float)number_values[ii] / 255.0f;
        }
        this.setColor(colValues);
    }

    public void setColor(float[] value) {
        if (LogWriter.isRunningFromIDE) {
            throw new RuntimeException(" called setColor(float[] in Generic for " + this + " with values " + value.length);
        }
    }

    public byte[] dataToRGBByteArray(byte[] data, int w2, int h2) {
        if (LogWriter.isRunningFromIDE) {
            LogWriter.writeLog(" called dataToRGBByteArray in Generic for " + data.length + " with value " + w2 + ' ' + h2);
        }
        return data;
    }

    public byte[] dataToRGBByteArray(byte[] data, int w2, int h2, int intent) {
        return this.dataToRGBByteArray(data, w2, h2);
    }

    float[] flattenIndexedValue(float[] number_values) {
        int ptr = (int)(number_values[0] * (float)this.componentCount);
        byte[] cmap = this.getIndexedMap();
        number_values = new float[this.componentCount];
        for (int i2 = 0; i2 < this.componentCount; ++i2) {
            number_values[i2] = (float)(cmap[ptr + i2] & 0xFF) / 255.0f;
        }
        return number_values;
    }

    int[] flattenIndexedValue(int[] number_values) {
        int ptr = number_values[0] * this.componentCount;
        byte[] cmap = this.getIndexedMap();
        number_values = new int[this.componentCount];
        for (int i2 = 0; i2 < this.componentCount; ++i2) {
            number_values[i2] = cmap[ptr + i2] & 0xFF;
        }
        return number_values;
    }

    public BufferedImage dataToRGB(byte[] data, int w2, int h2) {
        BufferedImage image = new BufferedImage(w2, h2, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, w2, h2);
        image.setData(raster);
        return image;
    }

    public BufferedImage dataToRGB(byte[] data, int w2, int h2, int intent) {
        return this.dataToRGB(data, w2, h2);
    }

    public int getID() {
        return this.value;
    }

    final void setCIEValues(float[] W2, float[] R2, float[] Ma, float[] G2) {
        this.cs = ColorSpace.getInstance(1001);
        this.G = G2;
        this.Ma = Ma;
        this.W = W2;
        this.R = R2;
    }

    byte[] convert4Index(byte[] data) {
        int compCount = 4;
        if (this.value == 1498837125) {
            int len = data.length;
            byte[] rgb = new byte[len * 3 / 4];
            int j2 = 0;
            for (int ii = 0; ii < len; ii += 4) {
                int[] vals = new int[4];
                for (int j3 = 0; j3 < 4; ++j3) {
                    vals[j3] = data[ii + j3] & 0xFF;
                }
                this.setColor(vals);
                int foreground = this.currentColor.getRGB();
                rgb[j2] = (byte)(foreground >> 16 & 0xFF);
                rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
                rgb[j2 + 2] = (byte)(foreground & 0xFF);
                j2 += 3;
                if (len - 4 - ii >= 4) continue;
                ii = len;
            }
            return rgb;
        }
        try {
            int width = data.length / 4;
            boolean height = true;
            DataBufferByte db = new DataBufferByte(data, data.length);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, 1, width * 4, 4, bands4, null);
            if (CSToRGB == null) {
                GenericColorSpace.initCMYKColorspace();
                CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
            }
            WritableRaster rgbRaster = rgbModel.createCompatibleWritableRaster(width, 1);
            CSToRGB.filter(raster, rgbRaster);
            DataBuffer convertedData = rgbRaster.getDataBuffer();
            int size = width * 1 * 3;
            data = new byte[size];
            for (int ii = 0; ii < size; ++ii) {
                data[ii] = (byte)convertedData.getElem(ii);
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception  " + ee + " converting colorspace");
        }
        return data;
    }

    public byte[] convertIndexToRGB(byte[] index) {
        return index;
    }

    public String getXMLColorToken() {
        String colorToken;
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color col = new Color(this.currentColor.getRGB());
                float c2 = (float)(255 - col.getRed()) / 255.0f;
                float m2 = (float)(255 - col.getGreen()) / 255.0f;
                float y2 = (float)(255 - col.getBlue()) / 255.0f;
                float k2 = c2;
                if (k2 < m2) {
                    k2 = m2;
                }
                if (k2 < y2) {
                    k2 = y2;
                }
                colorToken = "<color C='" + c2 + "' M='" + m2 + "' Y='" + y2 + "' K='" + k2 + "' >";
            } else {
                colorToken = "<color type='shading'>";
            }
        } else {
            colorToken = "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >";
        }
        return colorToken;
    }

    public void setPattern(Map<String, byte[]> patterns) {
        this.patterns = patterns;
    }

    public void setColor(PdfPaint col) {
        this.currentColor = col;
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setColorComponentCount(int c2) {
        this.componentCount = c2;
    }

    public void setGS(GraphicsState currentGraphicsState) {
        this.gs = currentGraphicsState.deepCopy();
    }

    public boolean isIndexConverted() {
        return this.isConverted;
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace rgbCS = ColorSpace.getInstance(1000);
        String profile = System.getProperty("org.jpedal.RGBprofile");
        if (profile != null) {
            try {
                rgbCS = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(profile)));
            }
            catch (Exception e2) {
                LogWriter.writeLog("[PDF] Problem " + e2.getMessage() + " with ICC data ");
            }
        }
        return rgbCS;
    }

    int getType() {
        return this.type;
    }

    void setType(int rawValue) {
        this.value = rawValue;
        this.rawCSType = rawValue;
    }

    void setRawColorSpace(int rawType) {
        this.rawCSType = rawType;
    }

    public int getRawColorSpacePDFType() {
        return this.rawCSType;
    }

    public void invalidateCaching(int color) {
    }

    static {
        block3: {
            bands4 = new int[]{0, 1, 2, 3};
            String profile = System.getProperty("org.jpedal.RGBprofile");
            if (profile != null) {
                try {
                    ICCProfileForRGB = ICC_Profile.getInstance(new FileInputStream(profile));
                }
                catch (Exception e2) {
                    LogWriter.writeLog("[PDF] Problem " + e2.getMessage() + " with ICC data ");
                    if (ICCProfileForRGB != null) break block3;
                    throw new RuntimeException("Problem wth RGB profile " + profile + ' ' + e2.getMessage());
                }
            }
        }
        rgbCS = ICCProfileForRGB != null ? new ICC_ColorSpace(ICCProfileForRGB) : ColorSpace.getInstance(1000);
    }
}

