/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class DeviceRGBColorSpace
extends GenericColorSpace {
    public DeviceRGBColorSpace(boolean isARGB) {
        this.setType(1785221209);
        if (isARGB) {
            this.componentCount = 4;
        }
    }

    public DeviceRGBColorSpace() {
        this.setType(1785221209);
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image;
        if (width * height == data.length) {
            image = DeviceRGBColorSpace.makeIndexImage(width, height, data);
        } else {
            LogWriter.writeLog("Converting data to sRGB " + data.length);
            image = DeviceRGBColorSpace.makeImage(data, width, height);
        }
        return image;
    }

    private static BufferedImage makeImage(byte[] data, int w2, int h2) {
        BufferedImage image = new BufferedImage(w2, h2, 1);
        data = DeviceRGBColorSpace.checkSize(data, w2, h2);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, w2, h2);
        image.setData(raster);
        return image;
    }

    private static BufferedImage makeIndexImage(int w2, int h2, byte[] data) {
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0};
        BufferedImage image = new BufferedImage(w2, h2, 10);
        WritableRaster raster = Raster.createInterleavedRaster(db, w2, h2, w2, 1, bands, null);
        image.setData(raster);
        return image;
    }

    private static byte[] checkSize(byte[] data, int w2, int h2) {
        int correctSize = w2 * h2 * 3;
        if (data.length < correctSize) {
            byte[] newData = new byte[correctSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            return newData;
        }
        return data;
    }

    @Override
    public final void setColor(int[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        int r2 = DeviceRGBColorSpace.checkRange(operand[0]);
        int g2 = DeviceRGBColorSpace.checkRange(operand[1]);
        int b2 = DeviceRGBColorSpace.checkRange(operand[2]);
        this.currentColor = new PdfColor(r2, g2, b2);
    }

    private static int checkRange(int r2) {
        return r2 > 255 ? 255 : Math.max(r2, 0);
    }

    @Override
    public final void setColor(float[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        float r2 = DeviceRGBColorSpace.checkRange(operand[0]);
        float g2 = DeviceRGBColorSpace.checkRange(operand[1]);
        float b2 = DeviceRGBColorSpace.checkRange(operand[2]);
        this.currentColor = new PdfColor(r2, g2, b2);
    }

    private static float checkRange(float r2) {
        return r2 > 1.0f ? 1.0f : (r2 < 0.0f ? 0.0f : r2);
    }
}

