/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.LimitedArray;
import org.jpedal.color.PdfColor;
import org.jpedal.color.SeparationColorSpace;

public class DeviceNColorSpace
extends SeparationColorSpace {
    private final int[] lookup = new int[256];
    private final LimitedArray lim = new LimitedArray();

    DeviceNColorSpace(int componentCount, ColorMapping colorMapper, float[] domain, GenericColorSpace altCS) {
        this.setType(960981604);
        this.componentCount = componentCount;
        this.colorMapper = colorMapper;
        this.domain = domain;
        this.altCS = altCS;
    }

    @Override
    public void setColor(float[] raw) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            raw = this.flattenIndexedValue(raw);
        }
        if (raw.length == 1) {
            int key = (int)(raw[0] * 255.0f);
            if (this.lookup[key] != 0) {
                int v2 = this.lookup[key];
                this.altCS.currentColor = new PdfColor(v2 >> 16 & 0xFF, v2 >> 8 & 0xFF, v2 & 0xFF);
            } else {
                float[] operand = this.colorMapper.getOperandFloat(raw);
                this.altCS.setColor(operand);
                this.lookup[key] = this.altCS.getColor().getRGB();
            }
        } else {
            int v3 = this.lim.get(raw);
            if (v3 != 0) {
                this.altCS.currentColor = new PdfColor(v3 >> 16 & 0xFF, v3 >> 8 & 0xFF, v3 & 0xFF);
            } else {
                float[] operand = this.colorMapper.getOperandFloat(raw);
                this.altCS.setColor(operand);
                this.lim.put(raw, this.altCS.getColor().getRGB());
            }
        }
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int w2, int h2) {
        return this.createImage(w2, h2, data);
    }

    @Override
    BufferedImage createImage(int w2, int h2, byte[] rawData) {
        byte[] rgb = new byte[w2 * h2 * 3];
        int bytesCount = rawData.length;
        int byteCount = rawData.length / this.componentCount;
        int[] values = new int[this.componentCount];
        int j2 = 0;
        int j22 = 0;
        for (int i2 = 0; i2 < byteCount && j2 < bytesCount; ++i2) {
            for (int comp = 0; comp < this.componentCount; ++comp) {
                values[comp] = rawData[j2] & 0xFF;
                ++j2;
            }
            this.setColor(values);
            int foreground = this.altCS.currentColor.getRGB();
            rgb[j22] = (byte)(foreground >> 16 & 0xFF);
            rgb[j22 + 1] = (byte)(foreground >> 8 & 0xFF);
            rgb[j22 + 2] = (byte)(foreground & 0xFF);
            j22 += 3;
        }
        int[] bands = new int[]{0, 1, 2};
        BufferedImage image = new BufferedImage(w2, h2, 1);
        DataBufferByte dataBuf = new DataBufferByte(rgb, rgb.length);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuf, w2, h2, w2 * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }

    public byte[] getRGBBytes(byte[] rawData, int w2, int h2) {
        byte[] rgb = new byte[w2 * h2 * 3];
        int bytesCount = rawData.length;
        int byteCount = rawData.length / this.componentCount;
        int[] values = new int[this.componentCount];
        int j2 = 0;
        int j22 = 0;
        for (int i2 = 0; i2 < byteCount && j2 < bytesCount; ++i2) {
            for (int comp = 0; comp < this.componentCount; ++comp) {
                values[comp] = rawData[j2] & 0xFF;
                ++j2;
            }
            this.setColor(values);
            int foreground = this.altCS.currentColor.getRGB();
            rgb[j22] = (byte)(foreground >> 16 & 0xFF);
            rgb[j22 + 1] = (byte)(foreground >> 8 & 0xFF);
            rgb[j22 + 2] = (byte)(foreground & 0xFF);
            j22 += 3;
        }
        return rgb;
    }
}

